/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.argouml.core.propertypanels.ui.LabelledComponent;
import org.argouml.core.propertypanels.ui.Seperator;

class LabelledLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -5596655602155151443L;
    private int hgap;
    private int vgap;
    private boolean ignoreSplitters;

    public LabelledLayout() {
        this.ignoreSplitters = false;
        this.hgap = 0;
        this.vgap = 0;
    }

    public LabelledLayout(boolean ignoreSplitters) {
        this.ignoreSplitters = ignoreSplitters;
        this.hgap = 0;
        this.vgap = 0;
    }

    public LabelledLayout(int hgap, int vgap) {
        this.ignoreSplitters = false;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int preferredWidth = 0;
            int preferredHeight = 0;
            int widestLabel = 0;
            int componentCount = parent.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component childComp = parent.getComponent(i);
                if (!childComp.isVisible() || childComp instanceof Seperator) continue;
                int childHeight = this.getPreferredHeight(childComp);
                preferredHeight += childHeight + this.vgap;
            }
            return new Dimension(insets.left + widestLabel + (preferredWidth += insets.left + widestLabel + insets.right) + insets.right, preferredHeight += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int minimumHeight = insets.top + insets.bottom;
            return new Dimension(0, minimumHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int sectionX = parent.getInsets().left;
            ArrayList<Component> components = new ArrayList<Component>();
            int sectionCount = this.getSectionCount(parent);
            int sectionWidth = this.getSectionWidth(parent, sectionCount);
            int sectionNo = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component childComp = parent.getComponent(i);
                if (childComp instanceof Seperator) {
                    if (this.ignoreSplitters) continue;
                    this.layoutSection(parent, sectionX, sectionWidth, components, sectionNo++);
                    sectionX += sectionWidth + this.hgap;
                    components.clear();
                    continue;
                }
                components.add(parent.getComponent(i));
            }
            this.layoutSection(parent, sectionX, sectionWidth, components, sectionNo);
        }
    }

    private int getSectionCount(Container parent) {
        int sectionCount = 1;
        int componentCount = parent.getComponentCount();
        if (!this.ignoreSplitters) {
            for (int i = 0; i < componentCount; ++i) {
                if (!(parent.getComponent(i) instanceof Seperator)) continue;
                ++sectionCount;
            }
        }
        return sectionCount;
    }

    private int getSectionWidth(Container parent, int sectionCount) {
        return (this.getUsableWidth(parent) - (sectionCount - 1) * this.hgap) / sectionCount;
    }

    private int getUsableWidth(Container parent) {
        Insets insets = parent.getInsets();
        return parent.getWidth() - (insets.left + insets.right);
    }

    private void layoutSection(Container parent, int sectionX, int sectionWidth, ArrayList components, int sectionNo) {
        ArrayList<Integer> rowHeights = new ArrayList<Integer>();
        int componentCount = components.size();
        if (componentCount == 0) {
            return;
        }
        int labelWidth = 0;
        int unknownHeightCount = 0;
        int totalHeight = 0;
        for (int i = 0; i < componentCount; ++i) {
            int childHeight;
            LabelledComponent lc;
            JLabel label;
            Component childComp = (Component)components.get(i);
            if (childComp instanceof LabelledComponent && (label = (lc = (LabelledComponent)childComp).getLabel()) != null && label.getMinimumSize().width > labelWidth) {
                labelWidth = label.getMinimumSize().width;
            }
            if ((childHeight = this.getChildHeight(childComp)) == 0) {
                ++unknownHeightCount;
            }
            totalHeight += childHeight + this.vgap;
            rowHeights.add(new Integer(childHeight));
        }
        totalHeight -= this.vgap;
        Insets insets = parent.getInsets();
        int parentHeight = parent.getHeight() - (insets.top + insets.bottom);
        int y = insets.top;
        int row = 0;
        for (int i = 0; i < componentCount; ++i) {
            LabelledComponent lc;
            JLabel label;
            Component childComp = (Component)components.get(i);
            if (!childComp.isVisible()) continue;
            if (childComp instanceof LabelledComponent && (label = (lc = (LabelledComponent)childComp).getLabel()) != null) {
                label.setPreferredSize(new Dimension(labelWidth, label.getPreferredSize().height));
            }
            int componentWidth = sectionWidth;
            int componentX = sectionX;
            int rowHeight = (Integer)rowHeights.get(row);
            if (rowHeight == 0) {
                try {
                    rowHeight = this.calculateHeight(parentHeight, totalHeight, unknownHeightCount--, childComp);
                }
                catch (ArithmeticException e) {
                    String lookAndFeel = UIManager.getLookAndFeel().getClass().getName();
                    throw new IllegalStateException("Division by zero laying out " + childComp.getClass().getName() + " on " + parent.getClass().getName() + " in section " + sectionNo + " using " + lookAndFeel, e);
                }
                totalHeight += rowHeight;
            }
            if (childComp.getMaximumSize() != null && this.getMaximumWidth(childComp) < componentWidth) {
                componentWidth = this.getMaximumWidth(childComp);
            }
            childComp.setBounds(componentX, y, componentWidth, rowHeight);
            y += rowHeight + this.vgap;
            ++row;
        }
    }

    private int getChildHeight(Component childComp) {
        if (this.isResizable(childComp)) {
            return 0;
        }
        return this.getMinimumHeight(childComp);
    }

    private boolean isResizable(Component comp) {
        if (comp == null) {
            return false;
        }
        if (comp instanceof JComboBox) {
            return false;
        }
        if (comp.getPreferredSize() == null) {
            return false;
        }
        if (comp.getMinimumSize() == null) {
            return false;
        }
        return this.getMinimumHeight(comp) < this.getPreferredHeight(comp);
    }

    private final int calculateHeight(int parentHeight, int totalHeight, int unknownHeightsLeft, Component childComp) {
        return Math.max((parentHeight - totalHeight) / unknownHeightsLeft, this.getMinimumHeight(childComp));
    }

    private int getPreferredHeight(Component comp) {
        return (int)comp.getPreferredSize().getHeight();
    }

    private int getPreferredWidth(Component comp) {
        return (int)comp.getPreferredSize().getWidth();
    }

    private int getMinimumHeight(Component comp) {
        return (int)comp.getMinimumSize().getHeight();
    }

    private int getMaximumWidth(Component comp) {
        return (int)comp.getMaximumSize().getWidth();
    }

    public static Seperator getSeparator() {
        return new Seperator();
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }
}

