/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.argouml.language.sql.Utils;
import org.argouml.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelValidator {
    private Map<String, Object> associationForName = new HashMap<String, Object>();
    private Map<Object, Object> fkAttrForAssoc = new HashMap<Object, Object>();
    private List<String> problems;
    private Set validatedAssociations = new HashSet();

    public List<String> validate(Collection elements) {
        this.problems = new ArrayList<String>();
        for (Object relation : elements) {
            if (!Model.getFacade().isAClass(relation) || Model.getFacade().isAAssociationClass(relation)) continue;
            this.validateRelation(relation);
        }
        Set<Map.Entry<String, Object>> entries = this.associationForName.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String assocName = entry.getKey();
            Object association = entry.getValue();
            Object fkAttribute = this.fkAttrForAssoc.get(association);
            if (fkAttribute != null) continue;
            this.problems.add("Foreign key attribute missing for association " + assocName);
        }
        return this.problems;
    }

    private void validateRelation(Object relation) {
        this.validatePrimaryKey(relation);
        this.validateFkAttributes(relation);
        this.validateAssociations(relation);
    }

    private void validateFkAttributes(Object relation) {
        List attributes = Model.getFacade().getAttributes(relation);
        for (Object attribute : attributes) {
            if (!Utils.isFk(attribute)) continue;
            this.validateFkAttribute(relation, attribute);
        }
    }

    private void validatePrimaryKey(Object relation) {
        List attributes = Model.getFacade().getAttributes(relation);
        Iterator it = attributes.iterator();
        boolean valid = false;
        while (it.hasNext()) {
            Object attribute = it.next();
            if (!Utils.isPk(attribute)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            this.problems.add("Primary key missing for " + Model.getFacade().getName(relation));
        }
    }

    private void validateFkAttribute(Object relation, Object attribute) {
        String relName = Model.getFacade().getName(relation);
        String attrName = Model.getFacade().getName(attribute);
        String assocName = Model.getFacade().getTaggedValueValue(attribute, "association_name");
        Object association = Utils.getAssociationForName(relation, assocName);
        if (association == null) {
            this.problems.add("association named '" + assocName + "' for relation " + Model.getFacade().getName(relation) + " not found");
        } else {
            this.fkAttrForAssoc.put(association, attribute);
            Object relationAssocEnd = Model.getFacade().getAssociationEnd(relation, association);
            Collection otherAssocEnds = Model.getFacade().getOtherAssociationEnds(relationAssocEnd);
            if (otherAssocEnds.size() == 1) {
                int otherUpper;
                Object otherAssocEnd = otherAssocEnds.iterator().next();
                Object otherRelation = Model.getFacade().getClassifier(otherAssocEnd);
                Object srcAttr = Utils.getSourceAttribute(attribute, otherRelation);
                if (srcAttr == null) {
                    this.problems.add("fk attribute " + relName + "." + attrName + " does not reference " + " an attribute in " + Model.getFacade().getName(otherRelation));
                }
                if ((otherUpper = Model.getFacade().getUpper(otherAssocEnd)) != 1) {
                    this.problems.add("foreign key attribute " + relName + "." + attrName + " cannot be used to reference multiple " + Model.getFacade().getName(otherRelation));
                }
                int otherLower = Model.getFacade().getLower(otherAssocEnd);
                this.validateFkConsistence(relation, attribute, otherLower);
            }
        }
    }

    private void validateFkConsistence(Object relation, Object fkAttribute, int lowerBound) {
        String entName = Model.getFacade().getName(relation);
        String attrName = Model.getFacade().getName(fkAttribute);
        if (Utils.isNull(fkAttribute) && lowerBound == 1) {
            this.problems.add("conflict in " + entName + "." + attrName + ": " + "attribute is nullable and association lower bound " + "is one");
        } else if (Utils.isNotNull(fkAttribute) && lowerBound == 0) {
            this.problems.add("conflict in " + entName + "." + attrName + ": " + "attribute is not nullable and association lower " + "bound is zero");
        }
    }

    private void validateAssociations(Object relation) {
        Collection associationEnds = Model.getFacade().getAssociationEnds(relation);
        for (Object relationAssocEnd : associationEnds) {
            Object association = Model.getFacade().getAssociation(relationAssocEnd);
            this.validateAssociation(association);
        }
    }

    private void validateAssociation(Object association) {
        if (this.validatedAssociations.contains(association)) {
            return;
        }
        this.validatedAssociations.add(association);
        String assocName = Model.getFacade().getName(association);
        if (this.associationForName.containsKey(assocName)) {
            this.problems.add("Association name " + assocName + " found more than once");
        } else {
            this.associationForName.put(assocName, association);
            Collection assocEnds = Model.getFacade().getConnections(association);
            if (assocEnds.size() != 2) {
                this.problems.add("Association " + assocName + " is not binary");
            } else {
                Iterator it = assocEnds.iterator();
                Object assocEnd1 = it.next();
                Object assocEnd2 = it.next();
                int end1Upper = Model.getFacade().getUpper(assocEnd1);
                int end2Upper = Model.getFacade().getUpper(assocEnd2);
                if (end1Upper != 1 && end2Upper != 1) {
                    this.problems.add("Association " + assocName + " is n:m (not " + "allowed in a relational data model)");
                }
            }
        }
    }
}

