/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.InvalidObjectException;
import org.argouml.model.CollaborationsFactory;
import org.argouml.model.InvalidElementException;
import org.argouml.model.Model;
import org.argouml.model.mdr.AbstractUmlModelFactoryMDR;
import org.argouml.model.mdr.MDRModelImplementation;
import org.omg.uml.UmlPackage;
import org.omg.uml.behavioralelements.collaborations.AssociationEndRole;
import org.omg.uml.behavioralelements.collaborations.AssociationRole;
import org.omg.uml.behavioralelements.collaborations.ClassifierRole;
import org.omg.uml.behavioralelements.collaborations.Collaboration;
import org.omg.uml.behavioralelements.collaborations.CollaborationInstanceSet;
import org.omg.uml.behavioralelements.collaborations.CollaborationsPackage;
import org.omg.uml.behavioralelements.collaborations.Interaction;
import org.omg.uml.behavioralelements.collaborations.InteractionInstanceSet;
import org.omg.uml.behavioralelements.collaborations.Message;
import org.omg.uml.behavioralelements.commonbehavior.Link;
import org.omg.uml.foundation.core.AssociationEnd;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.datatypes.AggregationKind;
import org.omg.uml.foundation.datatypes.AggregationKindEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollaborationsFactoryMDRImpl
extends AbstractUmlModelFactoryMDR
implements CollaborationsFactory {
    private MDRModelImplementation modelImpl;

    CollaborationsFactoryMDRImpl(MDRModelImplementation implementation) {
        this.modelImpl = implementation;
    }

    public AssociationEndRole createAssociationEndRole() {
        AssociationEndRole myAssociationEndRole = this.getCollabPkg().getAssociationEndRole().createAssociationEndRole();
        super.initialize(myAssociationEndRole);
        return myAssociationEndRole;
    }

    private CollaborationsPackage getCollabPkg() {
        return this.modelImpl.getUmlPackage().getCollaborations();
    }

    public AssociationRole createAssociationRole() {
        AssociationRole myAssociationRole = this.getCollabPkg().getAssociationRole().createAssociationRole();
        super.initialize(myAssociationRole);
        return myAssociationRole;
    }

    public ClassifierRole createClassifierRole() {
        return this.createLifeline();
    }

    public Collaboration createCollaboration() {
        Collaboration myCollaboration = this.getCollabPkg().getCollaboration().createCollaboration();
        super.initialize(myCollaboration);
        return myCollaboration;
    }

    public CollaborationInstanceSet createCollaborationInstanceSet() {
        CollaborationInstanceSet obj = this.getCollabPkg().getCollaborationInstanceSet().createCollaborationInstanceSet();
        super.initialize(obj);
        return obj;
    }

    public Interaction createInteraction() {
        Interaction myInteraction = this.getCollabPkg().getInteraction().createInteraction();
        super.initialize(myInteraction);
        return myInteraction;
    }

    public InteractionInstanceSet createInteractionInstanceSet() {
        InteractionInstanceSet obj = this.getCollabPkg().getInteractionInstanceSet().createInteractionInstanceSet();
        super.initialize(obj);
        return obj;
    }

    public ClassifierRole createLifeline() {
        ClassifierRole myClassifierRole = this.getCollabPkg().getClassifierRole().createClassifierRole();
        super.initialize(myClassifierRole);
        return myClassifierRole;
    }

    public Message createMessage() {
        Message myMessage = this.getCollabPkg().getMessage().createMessage();
        super.initialize(myMessage);
        return myMessage;
    }

    public ClassifierRole buildClassifierRole(Object collaboration) {
        Collaboration myCollaboration = (Collaboration)collaboration;
        ClassifierRole classifierRole = this.createClassifierRole();
        classifierRole.setNamespace((Namespace)myCollaboration);
        this.modelImpl.getCoreHelper().setMultiplicity(classifierRole, 1, 1);
        return classifierRole;
    }

    @Override
    public Object buildCollaboration(Object handle) {
        Namespace namespace = (Namespace)handle;
        Collaboration modelelement = this.createCollaboration();
        modelelement.setNamespace(namespace);
        modelelement.setName("newCollaboration");
        modelelement.setAbstract(false);
        return modelelement;
    }

    @Override
    public Object buildCollaboration(Object namespace, Object representedElement) {
        if (!(namespace instanceof Namespace)) {
            throw new IllegalArgumentException("Argument is not a namespace");
        }
        if (representedElement instanceof Classifier || representedElement instanceof Operation) {
            Collaboration collaboration = (Collaboration)this.buildCollaboration(namespace);
            if (representedElement instanceof Classifier) {
                collaboration.setRepresentedClassifier((Classifier)representedElement);
                return collaboration;
            }
            if (representedElement instanceof Operation) {
                collaboration.setRepresentedOperation((Operation)representedElement);
                return collaboration;
            }
        }
        throw new IllegalArgumentException("Represented element must be Collaboration or Operation");
    }

    public Interaction buildInteraction(Object handle) {
        Collaboration collab = (Collaboration)handle;
        Interaction inter = this.createInteraction();
        inter.setContext(collab);
        inter.setName("newInteraction");
        return inter;
    }

    public ClassifierRole buildLifeline(Object collaboration) {
        Collaboration myCollaboration = (Collaboration)collaboration;
        ClassifierRole classifierRole = this.createClassifierRole();
        classifierRole.setNamespace((Namespace)myCollaboration);
        this.modelImpl.getCoreHelper().setMultiplicity(classifierRole, 1, 1);
        return classifierRole;
    }

    public AssociationEndRole buildAssociationEndRole(Object atype) {
        ClassifierRole type = (ClassifierRole)atype;
        AssociationEndRole end = this.createAssociationEndRole();
        end.setParticipant((Classifier)type);
        return end;
    }

    public AssociationRole buildAssociationRole(Object from, Object to) {
        return this.buildAssociationRole((ClassifierRole)from, (ClassifierRole)to);
    }

    private AssociationRole buildAssociationRole(ClassifierRole from, ClassifierRole to) {
        Collaboration collaboration = (Collaboration)from.getNamespace();
        if (collaboration == null || !collaboration.equals(to.getNamespace())) {
            throw new IllegalArgumentException("ClassifierRoles must be in same non-null namespace");
        }
        AssociationRole role = this.createAssociationRole();
        role.setNamespace((Namespace)collaboration);
        role.getConnection().add(this.buildAssociationEndRole(from));
        role.getConnection().add(this.buildAssociationEndRole(to));
        return role;
    }

    @Deprecated
    public AssociationRole buildAssociationRole(Object from, Object agg1, Object to, Object agg2, Boolean unidirectional) {
        if (unidirectional == null) {
            return this.buildAssociationRole(from, agg1, to, agg2, false);
        }
        return this.buildAssociationRole(from, agg1, to, agg2, (boolean)unidirectional);
    }

    public AssociationRole buildAssociationRole(Object from, Object agg1, Object to, Object agg2, boolean unidirectional) {
        AggregationKind ak1 = this.checkAggregationKind(agg1);
        AggregationKind ak2 = this.checkAggregationKind(agg2);
        AssociationRole role = this.buildAssociationRole((ClassifierRole)from, (ClassifierRole)to);
        AssociationEndRole end = (AssociationEndRole)role.getConnection().get(0);
        end.setAggregation(ak1);
        end.setNavigable(!unidirectional);
        end = (AssociationEndRole)role.getConnection().get(1);
        end.setAggregation(ak2);
        end.setNavigable(true);
        return role;
    }

    private AggregationKind checkAggregationKind(Object aggregationKind) {
        if (aggregationKind == null) {
            aggregationKind = AggregationKindEnum.AK_NONE;
        }
        return (AggregationKind)aggregationKind;
    }

    public AssociationRole buildAssociationRole(Object link) {
        if (!(link instanceof Link)) {
            throw new IllegalArgumentException("Argument is not a link");
        }
        Object from = this.modelImpl.getCoreHelper().getSource(link);
        Object to = this.modelImpl.getCoreHelper().getDestination(link);
        Object classifierRoleFrom = this.modelImpl.getFacade().getClassifiers(from).iterator().next();
        Object classifierRoleTo = this.modelImpl.getFacade().getClassifiers(to).iterator().next();
        Object collaboration = this.modelImpl.getFacade().getNamespace(classifierRoleFrom);
        if (collaboration != this.modelImpl.getFacade().getNamespace(classifierRoleTo)) {
            throw new IllegalStateException("ClassifierRoles do not belong to the same collaboration");
        }
        if (collaboration == null) {
            throw new IllegalStateException("Collaboration may not be null");
        }
        AssociationRole associationRole = this.createAssociationRole();
        this.modelImpl.getCoreHelper().setNamespace(associationRole, collaboration);
        this.modelImpl.getCoreHelper().addLink(associationRole, link);
        return associationRole;
    }

    private Message buildMessageInteraction(Interaction inter, AssociationRole role) {
        assert (inter != null) : "An interaction must be provided";
        assert (role != null) : "An association role must be provided";
        Message message = this.createMessage();
        inter.getMessage().add(message);
        message.setCommunicationConnection(role);
        if (role.getConnection().size() == 2) {
            message.setSender((ClassifierRole)((AssociationEnd)role.getConnection().get(0)).getParticipant());
            message.setReceiver((ClassifierRole)((AssociationEnd)role.getConnection().get(1)).getParticipant());
            Collection messages = Model.getFacade().getReceivedMessages(message.getSender());
            Message lastMsg = this.lastMessage(messages, message);
            if (lastMsg != null) {
                message.setActivator(lastMsg);
                messages = Model.getFacade().getActivatedMessages(lastMsg);
            } else {
                messages = Model.getFacade().getSentMessages(message.getSender());
            }
            lastMsg = this.lastMessage(messages, message);
            if (lastMsg != null) {
                message.getPredecessor().add(this.findEnd(lastMsg));
            }
        }
        return message;
    }

    private Message lastMessage(Collection<Message> c, Message m) {
        Message last = null;
        for (Message msg : c) {
            if (msg == null || msg == m) continue;
            last = msg;
        }
        return last;
    }

    private Message findEnd(Message m) {
        Collection c;
        Iterator it;
        while ((it = (c = Model.getFacade().getSuccessors(m)).iterator()).hasNext()) {
            m = (Message)it.next();
        }
        return m;
    }

    public Message buildMessage(Object acollab, Object arole) {
        if (!(arole instanceof AssociationRole)) {
            throw new IllegalArgumentException("An association role must be supplied - got " + arole);
        }
        try {
            if (acollab instanceof Collaboration) {
                return this.buildMessageCollab((Collaboration)acollab, (AssociationRole)arole);
            }
            if (acollab instanceof Interaction) {
                return this.buildMessageInteraction((Interaction)acollab, (AssociationRole)arole);
            }
            throw new IllegalArgumentException("No valid object " + acollab);
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    private Message buildMessageCollab(Collaboration collab, AssociationRole role) {
        Interaction inter = null;
        inter = collab.getInteraction().size() == 0 ? this.buildInteraction(collab) : (Interaction)collab.getInteraction().toArray()[0];
        return this.buildMessageInteraction(inter, role);
    }

    public Message buildActivator(Object owner, Object interaction) {
        Message theOwner = (Message)owner;
        Interaction theInteraction = interaction == null ? theOwner.getInteraction() : (Interaction)interaction;
        if (interaction == null) {
            throw new IllegalArgumentException();
        }
        Message activator = this.createMessage();
        activator.setInteraction(theInteraction);
        theOwner.setActivator(activator);
        return activator;
    }

    void deleteAssociationEndRole(Object elem) {
        if (!(elem instanceof AssociationEndRole)) {
            throw new IllegalArgumentException();
        }
    }

    void deleteAssociationRole(Object elem) {
        AssociationRole role = (AssociationRole)elem;
        for (Message message : role.getMessage()) {
            this.modelImpl.getUmlFactory().delete(message);
        }
    }

    void deleteClassifierRole(Object elem) {
        ClassifierRole cr = (ClassifierRole)elem;
        CollaborationsPackage cPkg = ((UmlPackage)cr.refOutermostPackage()).getCollaborations();
        this.modelImpl.getUmlHelper().deleteCollection(cPkg.getAMessageSender().getMessage(cr));
        this.modelImpl.getUmlHelper().deleteCollection(cPkg.getAReceiverMessage().getMessage(cr));
    }

    void deleteCollaboration(Object elem) {
        if (!(elem instanceof Collaboration)) {
            throw new IllegalArgumentException();
        }
    }

    void deleteCollaborationInstanceSet(Object elem) {
        if (!(elem instanceof CollaborationInstanceSet)) {
            throw new IllegalArgumentException();
        }
    }

    void deleteInteraction(Object elem) {
        if (!(elem instanceof Interaction)) {
            throw new IllegalArgumentException();
        }
    }

    void deleteInteractionInstanceSet(Object elem) {
        if (!(elem instanceof InteractionInstanceSet)) {
            throw new IllegalArgumentException();
        }
    }

    void deleteMessage(Object elem) {
        Message message = (Message)elem;
        Interaction i = message.getInteraction();
        if (i != null && i.getMessage().size() == 1) {
            this.modelImpl.getUmlFactory().delete(i);
        }
    }
}

