/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng.classfile;

import org.apache.log4j.Logger;
import org.argouml.language.java.reveng.classfile.ClassifierNotFoundException;
import org.argouml.language.java.reveng.classfile.Context;
import org.argouml.model.Model;

class PackageContext
extends Context {
    static final Logger LOG = Logger.getLogger(PackageContext.class);
    private Object mPackage;
    private String javaName;
    private static final String GENERATED_TAG_VALUE = "true";

    public PackageContext(Context base, Object thePackage) {
        super(base);
        this.mPackage = thePackage;
        this.javaName = this.getJavaName(thePackage);
    }

    public Object getInterface(String name) throws ClassifierNotFoundException {
        return this.get(name, true);
    }

    public Object get(String name) throws ClassifierNotFoundException {
        return this.get(name, false);
    }

    public Object get(String name, boolean interfacesOnly) throws ClassifierNotFoundException {
        Object mClassifier = Model.getFacade().lookupIn(this.mPackage, name);
        if (mClassifier == null) {
            Class<?> classifier;
            String clazzName = name;
            if (!Model.getFacade().isAModel(this.mPackage)) {
                clazzName = this.javaName + "." + name;
            }
            if ((classifier = this.findClass(clazzName, interfacesOnly)) != null && (mClassifier = classifier.isInterface() ? Model.getCoreFactory().buildInterface(name, this.mPackage) : Model.getCoreFactory().buildClass(name, this.mPackage)) != null) {
                this.setGeneratedTag(mClassifier);
            }
        }
        if (mClassifier == null) {
            if (this.getContext() != null) {
                mClassifier = this.getContext().get(name, interfacesOnly);
            } else if (!interfacesOnly && name.equals("int") || name.equals("long") || name.equals("short") || name.equals("byte") || name.equals("char") || name.equals("float") || name.equals("double") || name.equals("boolean") || name.equals("void") || name.indexOf("[]") != -1) {
                mClassifier = Model.getCoreFactory().buildDataType(name, this.mPackage);
            }
        }
        if (mClassifier == null) {
            throw new ClassifierNotFoundException(name);
        }
        return mClassifier;
    }

    private void setGeneratedTag(Object element) {
        Object tv = Model.getFacade().getTaggedValue(element, "GeneratedFromImport");
        if (tv == null) {
            Model.getExtensionMechanismsHelper().addTaggedValue(element, Model.getExtensionMechanismsFactory().buildTaggedValue("GeneratedFromImport", GENERATED_TAG_VALUE));
        } else {
            Model.getExtensionMechanismsHelper().setValueOfTag(tv, GENERATED_TAG_VALUE);
        }
    }
}

