/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.sequence2.diagram;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import org.apache.log4j.Logger;
import org.argouml.sequence2.diagram.FigClassifierRole;
import org.argouml.sequence2.diagram.FigMessage;
import org.argouml.uml.diagram.ui.FigEdgeModelElement;
import org.argouml.uml.diagram.ui.SelectionRerouteEdge;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;

class SelectionMessage
extends SelectionRerouteEdge {
    private static final Logger LOG = Logger.getLogger(SelectionMessage.class);

    public SelectionMessage(FigEdgeModelElement feme) {
        super(feme);
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 37 || ke.getKeyCode() == 39) {
            ke.consume();
        } else {
            this.handleMovement();
        }
    }

    public void mousePressed(MouseEvent me) {
        FigMessage message = (FigMessage)this.getContent();
        if (!message.isSelfMessage()) {
            super.mousePressed(me);
        }
    }

    public void dragHandle(int x, int y, int w, int h, Handle handle) {
        FigMessage message = (FigMessage)this.getContent();
        if (message.isSelfMessage()) {
            message.translate(0, y - message.getY());
        } else {
            super.dragHandle(x, y, w, h, handle);
            this.handleMovement();
        }
    }

    private void handleMovement() {
        FigMessage figMessage = (FigMessage)this.getContent();
        FigClassifierRole source = (FigClassifierRole)figMessage.getSourceFigNode();
        FigClassifierRole dest = (FigClassifierRole)figMessage.getDestFigNode();
        if (figMessage.getFinalY() > source.getY() + source.getHeight() - 10) {
            int newHeight = source.getHeight() + 10;
            List figs = this.getContent().getLayer().getContents();
            for (Fig workOnFig : figs) {
                if (!(workOnFig instanceof FigClassifierRole)) continue;
                workOnFig.setHeight(newHeight);
            }
        }
        dest.positionHead(figMessage);
        source.createActivations();
        if (!figMessage.isSelfMessage()) {
            dest.createActivations();
        }
    }
}

