/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.argouml.core.propertypanels.ui.UMLModelElementListModel;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.uml.ui.AbstractActionAddModelElement2;

class UMLPartitionContentListModel
extends UMLModelElementListModel {
    public UMLPartitionContentListModel(Object modelElement) {
        super("contents", modelElement.getClass(), new ActionAddPartitionContent());
        this.setTarget(modelElement);
    }

    protected void buildModelList() {
        Object partition = this.getTarget();
        this.setAllElements(Model.getFacade().getContents(partition));
    }

    protected boolean isValidElement(Object element) {
        if (!Model.getFacade().isAModelElement(element)) {
            return false;
        }
        Object partition = this.getTarget();
        return Model.getFacade().getContents(partition).contains(element);
    }

    private static class ActionAddPartitionContent
    extends AbstractActionAddModelElement2 {
        private static final long serialVersionUID = -3371454533555822156L;

        public ActionAddPartitionContent() {
            this.setMultiSelect(true);
        }

        protected void doIt(Collection selected) {
            Object partition = this.getTarget();
            if (Model.getFacade().isAPartition(partition)) {
                Model.getActivityGraphsHelper().setContents(partition, selected);
            }
        }

        protected List getChoices() {
            ArrayList ret = new ArrayList();
            if (Model.getFacade().isAPartition(this.getTarget())) {
                Object partition = this.getTarget();
                Object ag = Model.getFacade().getActivityGraph(partition);
                if (ag != null) {
                    Object top = Model.getFacade().getTop(ag);
                    ret.addAll(Model.getFacade().getSubvertices(top));
                }
            }
            return ret;
        }

        protected String getDialogTitle() {
            return Translator.localize((String)"dialog.title.add-contents");
        }

        protected List getSelected() {
            ArrayList ret = new ArrayList();
            ret.addAll(Model.getFacade().getContents(this.getTarget()));
            return ret;
        }
    }
}

