/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.argouml.core.propertypanels.ui.UMLModelElementListModel;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.uml.ui.AbstractActionAddModelElement2;
import org.argouml.uml.ui.AbstractActionRemoveElement;

class UMLOFSStateListModel
extends UMLModelElementListModel {
    private static final long serialVersionUID = -9214579555300746872L;

    public UMLOFSStateListModel(Object modelElement) {
        super("type", modelElement.getClass(), (AbstractActionAddModelElement2)new ActionAddOFSState(), new ActionRemoveOFSState());
        this.setTarget(modelElement);
    }

    protected void buildModelList() {
        if (this.getTarget() != null) {
            Object classifier = Model.getFacade().getType(this.getTarget());
            if (Model.getFacade().isAClassifierInState(classifier)) {
                Collection c = Model.getFacade().getInStates(classifier);
                this.setAllElements(c);
            }
        }
    }

    protected boolean isValidElement(Object elem) {
        Object t = this.getTarget();
        if (Model.getFacade().isAState(elem) && Model.getFacade().isAObjectFlowState(t)) {
            Collection c;
            Object type = Model.getFacade().getType(t);
            if (Model.getFacade().isAClassifierInState(type) && (c = Model.getFacade().getInStates(type)).contains(elem)) {
                return true;
            }
        }
        return false;
    }

    private static class ActionRemoveOFSState
    extends AbstractActionRemoveElement {
        private static final long serialVersionUID = 4745674604611374936L;

        public ActionRemoveOFSState() {
            super(Translator.localize((String)"menu.popup.remove"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Object state = this.getObjectToRemove();
            if (state != null) {
                Object t = this.getTarget();
                if (Model.getFacade().isAObjectFlowState(t)) {
                    Object type = Model.getFacade().getType(t);
                    if (Model.getFacade().isAClassifierInState(type)) {
                        ArrayList states = new ArrayList(Model.getFacade().getInStates(type));
                        states.remove(state);
                        Model.getActivityGraphsHelper().setInStates(type, states);
                    }
                }
            }
        }
    }

    private static class ActionAddOFSState
    extends AbstractActionAddModelElement2 {
        private Object choiceClass = Model.getMetaTypes().getState();

        public ActionAddOFSState() {
            this.setMultiSelect(true);
        }

        protected void doIt(Collection selected) {
            Object t = this.getTarget();
            if (Model.getFacade().isAObjectFlowState(t)) {
                Object type = Model.getFacade().getType(t);
                if (Model.getFacade().isAClassifierInState(type)) {
                    Model.getActivityGraphsHelper().setInStates(type, selected);
                } else if (Model.getFacade().isAClassifier(type) && selected != null && selected.size() > 0) {
                    Object cis = Model.getActivityGraphsFactory().buildClassifierInState(type, selected);
                    Model.getCoreHelper().setType(t, cis);
                }
            }
        }

        protected List getChoices() {
            ArrayList ret = new ArrayList();
            Object t = this.getTarget();
            if (Model.getFacade().isAObjectFlowState(t)) {
                Object classifier = ActionAddOFSState.getType(t);
                if (Model.getFacade().isAClassifier(classifier)) {
                    ret.addAll(Model.getModelManagementHelper().getAllModelElementsOfKindWithModel(classifier, this.choiceClass));
                }
                ActionAddOFSState.removeTopStateFrom(ret);
            }
            return ret;
        }

        protected String getDialogTitle() {
            return Translator.localize((String)"dialog.title.add-state");
        }

        protected List getSelected() {
            Object t = this.getTarget();
            if (Model.getFacade().isAObjectFlowState(t)) {
                Object type = Model.getFacade().getType(t);
                if (Model.getFacade().isAClassifierInState(type)) {
                    return new ArrayList(Model.getFacade().getInStates(type));
                }
            }
            return new ArrayList();
        }

        private static Object getType(Object target) {
            Object type = Model.getFacade().getType(target);
            if (Model.getFacade().isAClassifierInState(type)) {
                type = Model.getFacade().getType(type);
            }
            return type;
        }

        static void removeTopStateFrom(Collection ret) {
            ArrayList tops = new ArrayList();
            for (Object state : ret) {
                if (!Model.getFacade().isACompositeState(state) || !Model.getFacade().isTop(state)) continue;
                tops.add(state);
            }
            ret.removeAll(tops);
        }
    }
}

