/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.tigris.gef.util.UnexpectedException;

public class Util {
    private Util() {
    }

    public static final String filenameToURI(String str) {
        char ch0;
        if ((str = str.replace(File.separatorChar, '/')).length() >= 2 && str.charAt(1) == ':' && (ch0 = Character.toUpperCase(str.charAt(0))) >= 'A' && ch0 <= 'Z') {
            str = "/" + str;
        }
        return str;
    }

    public static final URL fileToURL(File file) throws MalformedURLException, IOException {
        return new URL("file", "", Util.filenameToURI(file.getCanonicalPath()));
    }

    public static final URL fixURLExtension(URL url, String desiredExtension) {
        if (!url.getFile().endsWith(desiredExtension)) {
            try {
                url = new URL(url, url.getFile() + desiredExtension);
            }
            catch (MalformedURLException e) {
                throw new UnexpectedException(e);
            }
        }
        return url;
    }

    public static final URL exchangeURLExtension(URL url, String desiredExtension, String oldExtension) {
        if (!url.getFile().endsWith(oldExtension)) {
            return Util.fixURLExtension(url, desiredExtension);
        }
        try {
            String newURL = url.getFile();
            newURL = newURL.substring(0, newURL.lastIndexOf(46));
            url = new URL(url, newURL);
        }
        catch (MalformedURLException mue) {
            throw new UnexpectedException(mue);
        }
        return url;
    }

    public static final String stripJunk(String s) {
        int i;
        int len = s.length();
        int pos = 0;
        int i2 = 0;
        while (i2 < len && Character.isJavaIdentifierPart(s.charAt(i2))) {
            ++i2;
            ++pos;
        }
        if (pos == len) {
            return s;
        }
        StringBuffer buf = new StringBuffer(len);
        for (i = 0; i < pos; ++i) {
            buf.append(s.charAt(i));
        }
        for (i = pos + 1; i < len; ++i) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static final String URIToFilename(String str) {
        char ch1;
        if (str.length() >= 3 && str.charAt(0) == '/' && str.charAt(2) == ':' && (ch1 = Character.toUpperCase(str.charAt(1))) >= 'A' && ch1 <= 'Z') {
            str = str.substring(1);
        }
        str = str.replace('/', File.separatorChar);
        return str;
    }

    public static final File URLToFile(URL url) throws MalformedURLException {
        if (!"file".equals(url.getProtocol())) {
            throw new MalformedURLException("URL protocol must be 'file'.");
        }
        return new File(Util.URIToFilename(url.getFile()));
    }

    public static final String URLToShortName(URL url) {
        String name = url.getFile();
        return name.substring(name.lastIndexOf(47) + 1);
    }
}

