/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.graph.GraphController;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphEvent;
import org.tigris.gef.graph.GraphListener;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.presentation.DefaultGraphEdgeRenderer;
import org.tigris.gef.graph.presentation.DefaultGraphNodeRenderer;
import org.tigris.gef.graph.presentation.NetEdge;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

public class LayerPerspective
extends LayerDiagram
implements GraphListener {
    private static final long serialVersionUID = -3219953846728127850L;
    public static final int GAP = 16;
    private GraphModel _gm;
    private GraphController controller;
    private GraphNodeRenderer _nodeRenderer = new DefaultGraphNodeRenderer();
    private GraphEdgeRenderer _edgeRenderer = new DefaultGraphEdgeRenderer();
    private Vector _allowedNetClasses = new Vector();
    private Hashtable _nodeTypeRegions = new Hashtable();
    private Diagram diagram;
    private static Log LOG = LogFactory.getLog(LayerPerspective.class);

    public LayerPerspective(String name, GraphModel gm) {
        super(name);
        this._gm = gm;
        this.controller = null;
        this._gm.addGraphEventListener(this);
    }

    public LayerPerspective(String name, GraphModel gm, GraphController controller) {
        super(name);
        this._gm = gm;
        this.controller = controller;
        this._gm.addGraphEventListener(this);
    }

    public GraphModel getGraphModel() {
        return this._gm;
    }

    public void setGraphModel(GraphModel gm) {
        this._gm.removeGraphEventListener(this);
        this._gm = gm;
        this._gm.addGraphEventListener(this);
    }

    public GraphController getGraphController() {
        return this.controller;
    }

    public void setGraphController(GraphController controller) {
        this.controller = controller;
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._nodeRenderer;
    }

    public void setGraphNodeRenderer(GraphNodeRenderer rend) {
        this._nodeRenderer = rend;
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._edgeRenderer;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer rend) {
        this._edgeRenderer = rend;
    }

    public void allowNetClass(Class c) {
        this._allowedNetClasses.addElement(c);
    }

    public void addNodeTypeRegion(Class nodeClass, Rectangle region) {
        this._nodeTypeRegions.put(nodeClass, region);
    }

    public void putInPosition(Fig f) {
        Class<?> nodeClass = f.getOwner().getClass();
        Rectangle placementRegion = (Rectangle)this._nodeTypeRegions.get(nodeClass);
        if (placementRegion != null) {
            f.setLocation(placementRegion.x, placementRegion.y);
            this.bumpOffOtherNodesIn(f, placementRegion, false, true);
        }
    }

    public void bumpOffOtherNodesIn(Fig newFig, Rectangle bounds, boolean stagger, boolean vertical) {
        Rectangle bbox = newFig.getBounds();
        int origX = bbox.x;
        int origY = bbox.y;
        int col = 0;
        int row = 0;
        int i = 1;
        while (bounds.intersects(bbox)) {
            Enumeration overlappers = this.nodesIn(bbox);
            if (!overlappers.hasMoreElements()) {
                return;
            }
            if (overlappers.nextElement() == newFig && !overlappers.hasMoreElements()) {
                return;
            }
            int unitOffset = (i + 1) / 2 * (i % 2 == 0 ? -1 : 1);
            if (vertical) {
                bbox.y = origY + unitOffset * (bbox.height + 16);
            } else {
                bbox.x = origX + unitOffset * (bbox.width + 16);
            }
            newFig.setLocation(bbox.x, bbox.y);
            if (!bounds.intersects(bbox)) {
                int x = bounds.x;
                int y = bounds.y;
                if (vertical) {
                    ++col;
                    x = bbox.x + bbox.width + 16;
                    if (stagger) {
                        y += col % 2 * (bbox.height + 16) / 2;
                    }
                } else {
                    ++row;
                    y = bbox.y + bbox.height + 16;
                    if (stagger) {
                        x += row % 2 * (bbox.width + 16) / 2;
                    }
                }
                newFig.setLocation(x, y);
                bbox.setLocation(x, y);
            }
            ++i;
        }
    }

    public void nodeAdded(GraphEvent ge) {
        Object node = ge.getArg();
        Fig oldDE = this.presentationFor(node);
        if (null == oldDE) {
            if (!this.shouldShow(node)) {
                System.out.println("node rejected");
                return;
            }
            FigNode newFigNode = this._nodeRenderer.getFigNodeFor(this._gm, this, node, null);
            if (newFigNode != null) {
                newFigNode.setLayer(this);
                this.putInPosition(newFigNode);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Adding node");
                }
                this.add(newFigNode);
            }
        }
    }

    public void edgeAdded(GraphEvent ge) {
        Object edge = ge.getArg();
        Fig oldFig = this.presentationFor(edge);
        if (null == oldFig) {
            if (!this.shouldShow(edge)) {
                System.out.println("edge rejected");
                return;
            }
            FigEdge newFigEdge = this._edgeRenderer.getFigEdgeFor(this._gm, this, edge, null);
            if (newFigEdge != null) {
                newFigEdge.setLayer(this);
                this.add(newFigEdge);
                newFigEdge.computeRoute();
                newFigEdge.endTrans();
            }
        }
    }

    public void nodeRemoved(GraphEvent ge) {
        Fig node = this.presentationFor(ge.getArg());
        if (null != node) {
            if (node instanceof FigNode && ((FigNode)node).getHighlight()) {
                ((FigNode)node).setHighlight(false);
            }
            this.remove(node);
        }
    }

    public void edgeRemoved(GraphEvent ge) {
        Fig edge = this.presentationFor(ge.getArg());
        if (null != edge) {
            this.remove(edge);
        }
    }

    public void graphChanged(GraphEvent ge) {
    }

    public boolean shouldShow(Object obj) {
        if (this._allowedNetClasses.size() > 0 && !this._allowedNetClasses.contains(obj.getClass())) {
            return false;
        }
        return !(obj instanceof NetEdge) || this.getPortFig(((NetEdge)obj).getSourcePort()) != null && this.getPortFig(((NetEdge)obj).getDestPort()) != null;
    }

    void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }
}

