/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.util.Localizer;

public class CmdZoom
extends Cmd {
    private static final long serialVersionUID = 8472508088519383941L;
    protected double _magnitude;

    public CmdZoom() {
        this(0.0);
    }

    public CmdZoom(double magnitude) {
        super(CmdZoom.wordFor(magnitude));
        this._magnitude = magnitude;
    }

    protected static String wordFor(double magnitude) {
        if (magnitude < 0.0) {
            throw new IllegalArgumentException("Zoom magnitude cannot be less than 0");
        }
        if (magnitude == 0.0) {
            return Localizer.localize("GefBase", "ZoomReset");
        }
        if (magnitude > 1.0) {
            return Localizer.localize("GefBase", "ZoomIn");
        }
        if (magnitude < 1.0) {
            return Localizer.localize("GefBase", "ZoomOut");
        }
        return Localizer.localize("GefBase", "DoNothing");
    }

    public void doIt() {
        Editor ed = Globals.curEditor();
        if (ed == null) {
            return;
        }
        if (this._magnitude > 0.0) {
            ed.setScale(ed.getScale() * this._magnitude);
        } else {
            ed.setScale(1.0);
        }
        ed.damageAll();
    }

    public void undoIt() {
        Editor ed = Globals.curEditor();
        if (ed == null) {
            return;
        }
        if (this._magnitude > 0.0) {
            ed.setScale(ed.getScale() / this._magnitude);
        } else {
            System.out.println("Cannot undo CmdZoom reset, yet.");
        }
    }
}

