import { useCallback, useEffect, useRef } from 'react';

/**
 * Allows access to a changing value in a stable way.
 */
export function useStable(value) {
  var ref = useRef(value);
  useEffect(function () {
    ref.current = value;
  }, [value]);
  var getValue = useCallback(function () {
    return ref.current;
  }, []);
  return getValue;
}