/* Copyright (c) 2002
 *	Marko Boomstra (m.boomstra@chello.nl).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <conf.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <ncurses.h>
#include <panel.h>
#include "mudix.h"


void show_tabs(void)
{
    static int		 current;
    	   TABS    	*tabs;
    	   char    	*str;
    	   int      	 line, i, width, height, centre, wsize;

    width  = LEN_COL-4;
    height = 20;
    wsize  = height-2;
    centre = ((width-2)/2)-1;

    wresize(wMsg, height, width);
    werase(wMsg);
    move_panel(pMsg, 1, 2);

    if (panel_hidden(pMsg) == PANEL_HIDDEN)
	current = 0;

    for (line=1, i=0, tabs = settings->tabs_list; tabs; tabs = tabs->next) {
    	if (!tabs->name)
            continue;

	i++;
	if (i < (current*wsize)+1)
	    continue;

	mvwprintw(wMsg, line++, 1, "Name: %s", tabs->name);

	if (line >= wsize && tabs->next) {
	    current++;
	    break;
	}

	if (!tabs->next)	/* last one */
	    current = 0;
    }

    draw_border(wMsg);
    str = "Tab Completion";
    mvwprintw(wMsg, 0, centre-strlen(str)/2, str);
    show_panel(pMsg);
    return;
}

TABS *new_tabs(bool last)
{
    TABS *tabs;

    if (!(tabs = (TABS *)malloc(sizeof(TABS))))
        return NULL;

    if (last && settings->tabs_list) {
        TABS *iTabs;

        for (iTabs = settings->tabs_list; iTabs; iTabs = iTabs->next) {
            if (!iTabs->next)
                break;
        }
        iTabs->next = tabs;
        tabs->next  = NULL;
    }
    else {
    	tabs->next = settings->tabs_list;
    	settings->tabs_list = tabs;
    }

    tabs->name = NULL;

    return tabs;
}

void free_tabs(TABS *pTabs)
{
    TABS *tabs;

    if (!pTabs)
	return;

    for (tabs = settings->tabs_list; tabs; tabs = tabs->next) {
    	if (tabs->next == pTabs) {
            tabs->next = pTabs->next;
            break;
        }
    }

    if (pTabs == settings->tabs_list)
        settings->tabs_list = pTabs->next;

    if (pTabs->name)
	free(pTabs->name);
    free(pTabs);
}

void check_tab(char *buffer, char *end)
{
    TABS *tabs;
    char *pName = end, *pNew;
    int   i, len;
 
    if (end == buffer)
	return;

    pName--;
    if (*pName == ' ')
	return;

    while (pName > buffer && *(pName-1) != ' ')
	pName--;

    len = (end-pName);
    for (tabs = settings->tabs_list; tabs; tabs = tabs->next) {
	if (!tabs->name)
	    continue;

	for (i=0; i<len; i++)
	    if (tolower(tabs->name[i]) != tolower(pName[i]))
		break;
	if (i == len)
	    break;
    }

    if (!tabs)
	return;
   
    pNew = tabs->name;
    while (pName != pEndIn)
	*pName++ = *pNew++;
    for (i=len; i<strlen(tabs->name); i++) {
        *pEndIn++ = tabs->name[i];
	if (pEndIn >= (inbuf+INPUT_MAX)) {
            beep();
            break;
        }
	pCursor++;
        if (pCursor == pEndIn) {
            if (pCursor >= (LINE_LENGTH + inbuf))
                print_cmd_line();
        }
        else {
            char *pTemp;

            pCursor--;
            pTemp = pEndIn-1;
            while (pTemp != pCursor) {
                *pTemp = *(pTemp-1);
                pTemp--;
            }
            *pCursor++ = tabs->name[i];

            print_cmd_line();
            if (pCursor < (LINE_LENGTH + inbuf))
            	wmove(wInput, 0, pCursor-inbuf);
        }
    }

    print_cmd_line();

    return;
}
