/*
 * This file is part of the Yices SMT Solver.
 * Copyright (C) 2017 SRI International.
 *
 * Yices is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Yices is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Yices.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Tables of actions for parsing the SMT-LIB language
 */

#ifndef __SMT_PARSE_TABLES_H
#define __SMT_PARSE_TABLES_H

#include <stdint.h>


typedef enum state_s {
  an0, an1,
  bt0, bt1, bt2, bt3,
  s0, s1, s2, s3, s4, s5, s6, s7, s8,
  f0, f1, f3, f4, f5, f6, f7, f8, f9, f10, f11,
  f14, f15, f16, f17, f19, f20, f21, f23, f24, f25, f26, f27,
  b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10,
  b11, b12, b13, b14, b15, b16, b17, b18, b19,
  b20, b21, b22, b24, b25, b27
} state_t;


/*
 * Action codes
 */
typedef enum actions {
  // annotations
  next_goto_an1,
  return_notoken,
  next_goto_an0,

  // basic term or atom
  var_next_return,
  fvar_next_return,
  rational_next_return,
  float_next_return,
  bvbin_next_return,
  bvhex_next_return,
  true_next_return,
  false_next_return,
  bit0_next_return,
  bit1_next_return,
  next_goto_bt1,  // bvconst
  next_goto_bt2,  // [
  endbvconst_return,
  next_goto_bt3,  // rational
  next_return,    // ]

  // sort
  //  u_next_return,
  int_next_return,
  real_next_return,
  array1_next_return,
  array2_next_return,
  sortsymbol_next_return,
  next_goto_s1,  // BitVec
  next_goto_s4,  // Array
  next_goto_s2,  // [
  next_goto_s3,  // rational
  next_goto_s5,  // [
  array_return,
  next_goto_s6,  // rational
  next_goto_s7,
  next_goto_s8,  // rational
  bvarray_next_return,

  // annotated formula or term
  termsymbol_next_return,
  next_goto_f1,
  goto_bt0,

  // all simple function keywords:
  distinct_next_push_f3_goto_f0,
  eq_next_push_f3_goto_f0,
  not_next_push_f3_goto_f0,
  implies_next_push_f3_goto_f0,
  if_then_else_next_push_f3_goto_f0,
  and_next_push_f3_goto_f0,
  or_next_push_f3_goto_f0,
  xor_next_push_f3_goto_f0,
  iff_next_push_f3_goto_f0,
  ite_next_push_f3_goto_f0,
  add_next_push_f3_goto_f0,
  sub_next_push_f3_goto_f0,
  mul_next_push_f3_goto_f0,
  div_next_push_f3_goto_f0,
  tilde_next_push_f3_goto_f0,
  lt_next_push_f3_goto_f0,
  le_next_push_f3_goto_f0,
  gt_next_push_f3_goto_f0,
  ge_next_push_f3_goto_f0,
  select_next_push_f3_goto_f0,
  store_next_push_f3_goto_f0,
  bvadd_next_push_f3_goto_f0,
  bvsub_next_push_f3_goto_f0,
  bvmul_next_push_f3_goto_f0,
  bvneg_next_push_f3_goto_f0,
  bvor_next_push_f3_goto_f0,
  bvand_next_push_f3_goto_f0,
  bvxor_next_push_f3_goto_f0,
  bvnot_next_push_f3_goto_f0,
  bvlt_next_push_f3_goto_f0,
  bvleq_next_push_f3_goto_f0,
  bvgt_next_push_f3_goto_f0,
  bvgeq_next_push_f3_goto_f0,
  bvslt_next_push_f3_goto_f0,
  bvsleq_next_push_f3_goto_f0,
  bvsgt_next_push_f3_goto_f0,
  bvsgeq_next_push_f3_goto_f0,
  concat_next_push_f3_goto_f0,
  shift_left0_next_push_f3_goto_f0,
  shift_right0_next_push_f3_goto_f0,
  shift_left1_next_push_f3_goto_f0,
  shift_right1_next_push_f3_goto_f0,
  bvudiv_next_push_f3_goto_f0,
  bvurem_next_push_f3_goto_f0,
  bvsdiv_next_push_f3_goto_f0,
  bvsrem_next_push_f3_goto_f0,
  bvsmod_next_push_f3_goto_f0,
  bvshl_next_push_f3_goto_f0,
  bvlshr_next_push_f3_goto_f0,
  bvashr_next_push_f3_goto_f0,
  bvnand_next_push_f3_goto_f0,
  bvnor_next_push_f3_goto_f0,
  bvxnor_next_push_f3_goto_f0,
  bvredor_next_push_f3_goto_f0,
  bvredand_next_push_f3_goto_f0,
  bvcomp_next_push_f3_goto_f0,
  bvult_next_push_f3_goto_f0,
  bvule_next_push_f3_goto_f0,
  bvugt_next_push_f3_goto_f0,
  bvuge_next_push_f3_goto_f0,
  bvsle_next_push_f3_goto_f0,
  bvsge_next_push_f3_goto_f0,

  symbol_next_goto_f4,
  extract_next_goto_f6,
  rotate_left_next_goto_f9,
  rotate_right_next_goto_f9,
  repeat_next_goto_f9,
  zero_extend_next_goto_f9,
  sign_extend_next_goto_f14,
  let_next_goto_f16,
  exists_next_goto_f20,
  forall_next_goto_f20,
  push_f5_goto_bt0,

  next_push_f26_goto_an1,
  push_f3_goto_f0,

  next_push_f27_goto_an1,
  applyfun_push_f3_goto_f0,

  next_return_noapply, // f27

  next_goto_f7,
  rational_next_goto_f8,
  next_goto_f10,
  rational_next_goto_f11,
  next_push_f26_push_an0_goto_f0,

  push_f15_goto_f0,
  rational_next_push_f26_goto_an0,

  next_goto_f17,
  var_next_push_f19_goto_f0,
  bind_next_push_f26_push_an0_goto_f0,

  next_goto_f21,
  var_next_push_f23_goto_s0,
  next_goto_f24,

  next_goto_f25,
  symbol_next_push_f26_goto_an0,
  push_f26_push_an0_goto_bt0,

  push_f26_push_an0_goto_f1,

  // benchmark
  next_goto_b1,
  next_goto_b2,
  benchmarkname_next_goto_b3,

  notes_next_goto_b4,
  status_next_goto_b5,
  assert_next_push_b6_goto_f0,
  logic_next_goto_b7,
  extrasorts_next_goto_b11,
  extrapreds_next_goto_b14,
  extrafuns_next_goto_b20,
  next_push_b3_goto_an1,
  end_benchmark_return,

  next_goto_b3,
  sat_next_goto_b3,
  unsat_next_goto_b3,
  unknown_next_goto_b3,

  eval_assert_goto_b3,

  logicname_next_goto_b8,
  next_goto_b9,
  goto_b3,
  rational_next_goto_b10,
  endlogic_next_goto_b3,

  next_goto_b12,
  sortsymbol_next_goto_b13,

  next_goto_b15,
  next_goto_b16,
  predsymbol_next_goto_b17,
  next_goto_b19,
  next_push_b18_goto_an1,
  push_b17_goto_s0,

  next_goto_b21,
  next_goto_b22,
  funsymbol_next_push_b24_goto_s0,
  next_goto_b25,
  next_push_b27_goto_an1,
  push_b24_goto_s0,

  error_rational_expected,
  error_rb_expected,
  error_lb_expected,
  error_colon_expected,
  error_attribute_expected,
  error_lp_expected,
  error_rp_expected,
  error_var_expected,
  error_benchmark_expected,
  error_symbol_expected,
  error_string_expected,
  error_status_expected,
  error,
} action_t;


/*
 * Tables generated by table_builder
 * see utils/table_builder.c
 */

// Table sizes
#define NSTATES 64
#define BSIZE 290

// Default values for each state
static const uint8_t default_value[NSTATES] = {
  return_notoken,
  return_notoken,
  error,
  endbvconst_return,
  error_rational_expected,
  error_rb_expected,
  error,
  error_lb_expected,
  error_rational_expected,
  error_rb_expected,
  array_return,
  error_rational_expected,
  error_colon_expected,
  error_rational_expected,
  error_rb_expected,
  goto_bt0,
  push_f5_goto_bt0,
  push_f3_goto_f0,
  applyfun_push_f3_goto_f0,
  error_attribute_expected,
  error_lb_expected,
  error_rational_expected,
  error_colon_expected,
  error_lb_expected,
  error_rational_expected,
  error_rb_expected,
  push_f15_goto_f0,
  error_rational_expected,
  error_lp_expected,
  error_var_expected,
  error_rp_expected,
  error_lp_expected,
  error_var_expected,
  error_rp_expected,
  push_f26_push_an0_goto_bt0,
  push_f26_push_an0_goto_f1,
  error_rp_expected,
  error_rp_expected,
  error_lp_expected,
  error_benchmark_expected,
  error_symbol_expected,
  error,
  error_string_expected,
  error_status_expected,
  eval_assert_goto_b3,
  error_symbol_expected,
  goto_b3,
  error_rational_expected,
  error_rb_expected,
  error_lp_expected,
  error_symbol_expected,
  error,
  error_lp_expected,
  error,
  error,
  push_b17_goto_s0,
  error_rp_expected,
  error,
  error_lp_expected,
  error_lp_expected,
  error_symbol_expected,
  push_b24_goto_s0,
  error,
  error_rp_expected,
};

// Base values for each state
static const uint8_t base[NSTATES] = {
     0,   2,   6,   0,   4,   0,   0,   2,   5,   2,
     4,  11,   4,  12,   6,  25,  46,  27,  21,  33,
     9,  17,  26,  36,  27,  37,  39,  30,   0,  36,
     0,  46,  48,  56,  79,  50,  58,  61,  80,  46,
    75, 158,  77,  51,   0,  77,  83,  78,  88,  92,
    88, 159,  96,  97,  91, 160, 132, 162, 134, 164,
   158, 172, 171, 166,
};

// Check table
static const uint8_t check[BSIZE] = {
    28,  30,   3,   5,   7,   9,  10,   6,  12,  14,
     0,  20,   1,   1,   2,   2,   4,   8,   2,   2,
     2,   2,   2,  11,  13,  15,   2,   2,  17,  21,
    22,  18,  15,   0,   0,   1,   1,  17,  23,  24,
    25,  26,  27,  19,  29,  29,  31,   6,   6,   6,
     6,   6,   6,  16,  18,  18,  32,  33,  35,  36,
    17,  17,  37,  16,  16,  16,  19,  19,  16,  16,
    16,  16,  16,  16,  16,  16,  16,  16,  16,  34,
    38,  39,  40,  42,  45,  46,  34,  43,  43,  43,
    47,  48,  49,   2,   2,  50,  52,  53,  54,  16,
    16,  16,  16,  16,  16,  16,  16,  16,  16,  16,
    16,  16,  16,  16,  16,  16,  16,  16,  16,  16,
    16,  16,  16,  16,  16,  16,  16,  16,  16,  16,
    16,  16,  16,  56,  58,  16,  16,  16,  16,  16,
    16,  16,  16,  16,  16,  16,  16,  16,  16,  16,
    16,  16,  16,  16,  16,  16,  16,  16,  16,  41,
    51,  55,  57,  57,  59,  60,  51,  63,  41,  64,
    55,  62,  62,  61,  64,  64,  64,  64,  64,  64,
    64,  64,  61,  64,  64,  64,  64,  64,  64,  64,
    64,  41,  41,  55,  55,  64,  64,  41,  41,  41,
    41,  41,  41,  41,  41,  61,  61,  64,  64,  64,
    64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
    64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
    64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
    64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
    64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
    64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
    64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
    64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
};

// Value table
static const uint8_t value[BSIZE] = {
  next_goto_f17,
  bind_next_push_f26_push_an0_goto_f0,
  next_goto_bt2,
  next_return,
  next_goto_s2,
  next_return,
  next_goto_s5,
  sortsymbol_next_return,
  next_goto_s7,
  bvarray_next_return,
  next_goto_an1,
  next_goto_f7,
  next_goto_an1,
  next_goto_an0,
  var_next_return,
  fvar_next_return,
  next_goto_bt3,
  next_goto_s3,
  rational_next_return,
  float_next_return,
  next_goto_bt1,
  bvbin_next_return,
  bvhex_next_return,
  next_goto_s6,
  next_goto_s8,
  next_goto_f1,
  true_next_return,
  false_next_return,
  next_return,
  rational_next_goto_f8,
  next_goto_f10,
  next_push_f27_goto_an1,
  termsymbol_next_return,
  next_goto_an1,
  next_goto_an1,
  next_goto_an1,
  next_goto_an1,
  next_push_f26_goto_an1,
  next_goto_f10,
  rational_next_goto_f11,
  next_push_f26_push_an0_goto_f0,
  next_goto_f10,
  rational_next_push_f26_goto_an0,
  next_push_f27_goto_an1,
  var_next_push_f19_goto_f0,
  var_next_push_f19_goto_f0,
  next_goto_f21,
  next_goto_s4,
  int_next_return,
  real_next_return,
  array1_next_return,
  array2_next_return,
  next_goto_s1,
  symbol_next_goto_f4,
  next_push_f27_goto_an1,
  next_push_f27_goto_an1,
  var_next_push_f23_goto_s0,
  next_goto_f24,
  var_next_push_f23_goto_s0,
  next_return,
  next_push_f26_goto_an1,
  next_push_f26_goto_an1,
  next_return_noapply,
  distinct_next_push_f3_goto_f0,
  ite_next_push_f3_goto_f0,
  eq_next_push_f3_goto_f0,
  next_push_f27_goto_an1,
  next_push_f27_goto_an1,
  not_next_push_f3_goto_f0,
  implies_next_push_f3_goto_f0,
  if_then_else_next_push_f3_goto_f0,
  and_next_push_f3_goto_f0,
  or_next_push_f3_goto_f0,
  xor_next_push_f3_goto_f0,
  iff_next_push_f3_goto_f0,
  exists_next_goto_f20,
  forall_next_goto_f20,
  let_next_goto_f16,
  let_next_goto_f16,
  next_goto_f25,
  next_goto_b1,
  next_goto_b2,
  benchmarkname_next_goto_b3,
  next_goto_b3,
  logicname_next_goto_b8,
  next_goto_b9,
  symbol_next_push_f26_goto_an0,
  sat_next_goto_b3,
  unsat_next_goto_b3,
  unknown_next_goto_b3,
  rational_next_goto_b10,
  endlogic_next_goto_b3,
  next_goto_b12,
  bit0_next_return,
  bit1_next_return,
  sortsymbol_next_goto_b13,
  next_goto_b15,
  next_goto_b16,
  predsymbol_next_goto_b17,
  add_next_push_f3_goto_f0,
  sub_next_push_f3_goto_f0,
  mul_next_push_f3_goto_f0,
  div_next_push_f3_goto_f0,
  tilde_next_push_f3_goto_f0,
  lt_next_push_f3_goto_f0,
  le_next_push_f3_goto_f0,
  gt_next_push_f3_goto_f0,
  ge_next_push_f3_goto_f0,
  select_next_push_f3_goto_f0,
  store_next_push_f3_goto_f0,
  bvadd_next_push_f3_goto_f0,
  bvsub_next_push_f3_goto_f0,
  bvmul_next_push_f3_goto_f0,
  bvneg_next_push_f3_goto_f0,
  bvor_next_push_f3_goto_f0,
  bvand_next_push_f3_goto_f0,
  bvxor_next_push_f3_goto_f0,
  bvnot_next_push_f3_goto_f0,
  bvlt_next_push_f3_goto_f0,
  bvleq_next_push_f3_goto_f0,
  bvgt_next_push_f3_goto_f0,
  bvgeq_next_push_f3_goto_f0,
  bvslt_next_push_f3_goto_f0,
  bvsleq_next_push_f3_goto_f0,
  bvsgt_next_push_f3_goto_f0,
  bvsgeq_next_push_f3_goto_f0,
  concat_next_push_f3_goto_f0,
  extract_next_goto_f6,
  sign_extend_next_goto_f14,
  shift_left0_next_push_f3_goto_f0,
  shift_left1_next_push_f3_goto_f0,
  shift_right0_next_push_f3_goto_f0,
  shift_right1_next_push_f3_goto_f0,
  next_goto_b19,
  next_goto_b21,
  bvudiv_next_push_f3_goto_f0,
  bvurem_next_push_f3_goto_f0,
  bvsdiv_next_push_f3_goto_f0,
  bvsrem_next_push_f3_goto_f0,
  bvsmod_next_push_f3_goto_f0,
  bvshl_next_push_f3_goto_f0,
  bvlshr_next_push_f3_goto_f0,
  bvashr_next_push_f3_goto_f0,
  bvnand_next_push_f3_goto_f0,
  bvnor_next_push_f3_goto_f0,
  bvxnor_next_push_f3_goto_f0,
  bvredor_next_push_f3_goto_f0,
  bvredand_next_push_f3_goto_f0,
  bvcomp_next_push_f3_goto_f0,
  repeat_next_goto_f9,
  zero_extend_next_goto_f9,
  rotate_left_next_goto_f9,
  rotate_right_next_goto_f9,
  bvult_next_push_f3_goto_f0,
  bvule_next_push_f3_goto_f0,
  bvugt_next_push_f3_goto_f0,
  bvuge_next_push_f3_goto_f0,
  bvsle_next_push_f3_goto_f0,
  bvsge_next_push_f3_goto_f0,
  end_benchmark_return,
  next_goto_b3,
  next_goto_b19,
  next_goto_b16,
  next_goto_b3,
  next_goto_b22,
  funsymbol_next_push_b24_goto_s0,
  sortsymbol_next_goto_b13,
  next_goto_b25,
  next_push_b3_goto_an1,
  error,
  next_push_b18_goto_an1,
  next_goto_b22,
  next_goto_b3,
  next_goto_b25,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  next_push_b27_goto_an1,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  next_push_b3_goto_an1,
  next_push_b3_goto_an1,
  next_push_b18_goto_an1,
  next_push_b18_goto_an1,
  error,
  error,
  logic_next_goto_b7,
  assert_next_push_b6_goto_f0,
  assert_next_push_b6_goto_f0,
  status_next_goto_b5,
  extrasorts_next_goto_b11,
  extrafuns_next_goto_b20,
  extrapreds_next_goto_b14,
  notes_next_goto_b4,
  next_push_b27_goto_an1,
  next_push_b27_goto_an1,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
};


#endif /* __SMT_PARSE_TABLES_H */
