GprParser Java API
==================

This package contains the Java bindings for the gpr_parser library.

Build and install
-----------------

This project use `Maven` for the build and install process and the required
Java version is 1.8 or later.
The building process also uses `GCC` and `Make` to build the JNI library so it
must be installed on your system and in your path.

Firstly you need to set the `JAVA_HOME` environment variable to your JDK
installation.

```sh
$> export JAVA_HOME=/path/to/jdk
```

Then you can build and install the Java API.

```sh
$> mvn clean install
```

Usage
-----

You can use the Java API in any Java code.

```java
import com.adacore.gpr_parser.GprParser;

public class Main {
    public static void main(String[] args) {

        // Parse the wanted file
        String myFile = "path/to/file/to/parse"
        GprParser.AnalysisContext ctx =
            GprParser.AnalysisContext.create();
        GprParser.AnalysisUnit unit = ctx.getUnitFromFile(myFile);

        // Dump the AST
        System.out.println(unit.root().dump());

    }
}
```
