OutFile "rotoscope-setup-0.2.exe"
Name "Rotoscope"
InstallDir "$PROGRAMFILES\rotoscope"
Page Directory
Page instfiles

Section
	# Install rotoscope files.
	SetOutPath $INSTDIR
	File "src\rotoscope.exe"
	File "src\rotoscope.glade"
	File "website.url"
	File "howtouse.url"
	writeUninstaller "uninstall.exe"

	# Install Start Menu entries.
	CreateDirectory "$SMPROGRAMS\Rotoscope"
	CreateShortcut "$SMPROGRAMS\Rotoscope\Website.lnk" "$INSTDIR\website.url"
	CreateShortcut "$SMPROGRAMS\Rotoscope\How to use Rotoscope.lnk" "$INSTDIR\howtouse.url"
	CreateShortCut "$SMPROGRAMS\Rotoscope\Rotoscope.lnk" "$INSTDIR\rotoscope.exe"
	CreateShortCut "$SMPROGRAMS\Rotoscope\Uninstall.lnk" "$INSTDIR\uninstall.exe"

	# Install Registry entries.
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\rotoscope" \
		"DisplayName" "Rotoscope"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\rotoscope" \
		"UninstallString" "$INSTDIR\uninstall.exe"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\rotoscope" \
		"INSTDIR" "$INSTDIR"
SectionEnd

Section "Uninstall"
	# Confirm uninstall.
	MessageBox MB_YESNO "Are you sure you want to uninstall rotoscope?" IDNO no IDYES yes
	no:
		Quit
	yes:

	# Fetch the installation directory.
	ReadRegStr $0 HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\rotoscope" "INSTDIR"

	# Remove rotoscope files.
	Delete "$0\uninstall.exe"
	Delete "$0\rotoscope.exe"
	Delete "$0\rotoscope.glade"
	Delete "$0\website.url"
	Delete "$0\howtouse.url"
	RMDir "$0"

	# Remove rotoscope registry entries.
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\rotoscope"

	# Remove rotoscope from start menu.
	Delete "$SMPROGRAMS\Rotoscope\Rotoscope.lnk"
	Delete "$SMPROGRAMS\Rotoscope\Website.lnk"
	Delete "$SMPROGRAMS\Rotoscope\How to use Rotoscope.lnk"
	Delete "$SMPROGRAMS\Rotoscope\Uninstall.lnk"
	RMDir "$SMPROGRAMS\Rotoscope"
SectionEnd

