# OpenRA Contributing Guidelines

## Participating
Help us keep OpenRA open and inclusive. Please read and follow our [Code of Conduct](https://github.com/OpenRA/OpenRA/blob/bleed/CODE_OF_CONDUCT.md).

## Bug reports

* Have you read the [FAQ](https://github.com/OpenRA/OpenRA/wiki/FAQ)?
* Add the appropriate log files on crashes.
* Mention the version you have tested against.
* Please be specific on how to reproduce the problem.
* Do not submit duplicate issues. Search first.
* Avoid including multiple requests/bugs into a single issue.

## Patches

* [Coding standard](https://github.com/OpenRA/OpenRA/wiki/Coding-Standard)
* [Branches and Releases](https://github.com/OpenRA/OpenRA/wiki/Branches-and-Releases)
* [Licensing](http://www.gnu.org/licenses/quick-guide-gplv3.html)

Please `git rebase` to the latest revision of the bleed branch.

Don't forget to add yourself to [AUTHORS](https://github.com/OpenRA/OpenRA/blob/bleed/AUTHORS).

Please propose a [CHANGELOG](https://github.com/OpenRA/OpenRA/wiki/CHANGELOG) entry in the pull-request comments.

While your pull-request is in review it will be helpful if you join [IRC](irc://chat.freenode.net/openra) to discuss the changes.

See also the in-depth guide on [contributing](https://github.com/OpenRA/OpenRA/wiki/Contributing) to the OpenRA project.
