/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import net.gcalc.plugin.gui.ColorPanel;

class PalettePanel
extends ColorPanel {
    private static final int BOGUS = -10;
    private int x = -10;
    private int y = -10;
    private int cx = -10;
    private int cy = -10;

    public PalettePanel() {
        super(null);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                PalettePanel.this.setCursor(evt.getX(), evt.getY());
            }

            public void mouseDragged(MouseEvent evt) {
                PalettePanel.this.setCursor(evt.getX(), evt.getY());
            }
        });
        this.setCursor(new Cursor(1));
    }

    protected void paintComponent(Graphics g) {
        int W = this.getWidth();
        int H = this.getHeight();
        int z = this.getHeight() / 2;
        g.setColor(Color.white);
        g.fillRect(0, 0, W, H);
        int i = 0;
        while (i < W) {
            int j = 0;
            while (j < z) {
                g.setColor(this.getColorAt(i, j));
                g.drawLine(i, j, i, j);
                g.setColor(this.getColorAt(i, j + z));
                g.drawLine(i, j + z, i, j + z);
                ++j;
            }
            ++i;
        }
        g.drawOval(this.x - 2, this.y - 2, 5, 5);
        g.drawLine(0, this.cy, this.getWidth(), this.cy);
        g.drawLine(this.cx, 0, this.cx, this.getHeight());
    }

    public void setCoordinates(int x, int y) {
        this.x = x;
        this.y = y;
        this.repaint();
    }

    public void clearCursors() {
        this.y = -10;
        this.x = -10;
        this.cy = -10;
        this.cx = -10;
        this.repaint();
    }

    public void setCursor(int x, int y) {
        this.cx = x;
        this.cy = y;
        this.repaint();
    }

    public Color getColorAt(int x, int y) {
        float hue = (float)x / (float)this.getWidth();
        float v = (float)(2 * (y % (this.getHeight() / 2))) / (float)this.getHeight();
        if (y >= this.getHeight() / 2) {
            return Color.getHSBColor(hue, 1.0f - v, 1.0f);
        }
        return Color.getHSBColor(hue, 1.0f, v);
    }
}

