/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import com.sun.electric.tool.simulation.sctiming.SCTimingException;
import com.sun.electric.tool.simulation.sctiming.Table2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TableData {
    List<String> headers;
    List<double[]> rows;

    public TableData(List<String> headers) {
        this.headers = headers;
        this.rows = new ArrayList<double[]>();
    }

    public void addRow(double[] row) {
        if (row.length != this.headers.size()) {
            System.out.println("Cannot add row of length " + row.length + " to table of length " + this.headers.size());
            return;
        }
        this.rows.add(row);
    }

    public int getNumCols() {
        return this.headers.size();
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public double[] getRow(int row) {
        return this.rows.get(row);
    }

    public int getColumn(String headername) {
        if (headername == null) {
            return -1;
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!this.headers.get(i).equalsIgnoreCase(headername)) continue;
            return i;
        }
        return -1;
    }

    public double getValue(int row, String header) {
        int col = this.getColumn(header);
        if (col < 0) {
            return Double.NaN;
        }
        if (row < 0 || row >= this.rows.size()) {
            return Double.NaN;
        }
        return this.rows.get(row)[col];
    }

    public void printData() {
        int i;
        int colwidth = 12;
        for (String s2 : this.headers) {
            if (s2.length() <= colwidth) continue;
            colwidth = s2.length() + 1;
        }
        StringBuffer line = new StringBuffer();
        for (String s3 : this.headers) {
            line.append(s3);
            for (i = s3.length(); i < colwidth; ++i) {
                line.append(" ");
            }
        }
        System.out.println(line);
        for (double[] row : this.rows) {
            line = new StringBuffer();
            for (i = 0; i < row.length; ++i) {
                String s4 = Double.toString(row[i]);
                line.append(s4);
                for (int j = s4.length(); j < colwidth; ++j) {
                    line.append(" ");
                }
            }
            System.out.println(line);
        }
    }

    public Table2D getTable2D(String index1, String index2, String index3, String index3ExcludeValues) {
        int i1 = this.getColumn(index1);
        int i2 = this.getColumn(index2);
        int i3 = this.getColumn(index3);
        double[] excludeValues = this.getDoubleValues(index3ExcludeValues);
        if (i1 < 0 || i2 < 0) {
            return null;
        }
        ArrayList<Double> values1 = new ArrayList<Double>();
        ArrayList<Double> values2 = new ArrayList<Double>();
        for (double[] row : this.rows) {
            Double d1 = new Double(row[i1]);
            Double d2 = new Double(row[i2]);
            if (!values1.contains(d1)) {
                values1.add(d1);
            }
            if (values2.contains(d2)) continue;
            values2.add(d2);
        }
        double[] di1 = new double[values1.size()];
        double[] di2 = new double[values2.size()];
        int i = 0;
        Iterator it = values1.iterator();
        while (it.hasNext()) {
            di1[i] = (Double)it.next();
            ++i;
        }
        i = 0;
        it = values2.iterator();
        while (it.hasNext()) {
            di2[i] = (Double)it.next();
            ++i;
        }
        Table2D table = new Table2D(di1, index1, di2, index2);
        boolean getStdDev = false;
        if (di1.length * di2.length < this.getNumRows()) {
            System.out.println("Warning: Conversion of TableData to Table2D will average some values because the number of unique values of " + index1 + " times " + index2 + " is smaller than the dimensions of the TableData");
            getStdDev = true;
        }
        for (int j = 0; j < this.headers.size(); ++j) {
            String key = this.headers.get(j);
            if (key.equals(index1) || key.equals(index2)) continue;
            double[][] data = new double[di1.length][di2.length];
            int[][] count2 = new int[di1.length][di2.length];
            for (int x = 0; x < di1.length; ++x) {
                Arrays.fill(data[x], 0.0);
                Arrays.fill(count2[x], 0);
            }
            for (double[] row : this.rows) {
                double ii1 = row[i1];
                double ii2 = row[i2];
                boolean skipThisVal = false;
                if (i3 >= 0) {
                    double ii3 = row[i3];
                    for (double excludeval : excludeValues) {
                        if (excludeval != ii3) continue;
                        skipThisVal = true;
                        break;
                    }
                }
                if (skipThisVal) continue;
                int r = 0;
                int c = 0;
                for (r = 0; r < di1.length && di1[r] != ii1; ++r) {
                }
                for (c = 0; c < di2.length && di2[c] != ii2; ++c) {
                }
                double[] dArray = data[r];
                int n = c;
                dArray[n] = dArray[n] + row[j];
                int[] nArray = count2[r];
                int n2 = c;
                nArray[n2] = nArray[n2] + 1;
            }
            for (int r = 0; r < di1.length; ++r) {
                for (int c = 0; c < di2.length; ++c) {
                    if (count2[r][c] <= 1) continue;
                    double[] dArray = data[r];
                    int n = c;
                    dArray[n] = dArray[n] / (double)count2[r][c];
                }
            }
            table.setData(key, data);
            if (!getStdDev) continue;
            double[][] stddev = new double[di1.length][di2.length];
            for (int x = 0; x < di1.length; ++x) {
                Arrays.fill(stddev[x], 0.0);
            }
            for (double[] row : this.rows) {
                double ii1 = row[i1];
                double ii2 = row[i2];
                boolean skipThisVal = false;
                if (i3 >= 0) {
                    double ii3 = row[i3];
                    for (double excludeval : excludeValues) {
                        if (excludeval != ii3) continue;
                        skipThisVal = true;
                        break;
                    }
                }
                if (skipThisVal) continue;
                int r = 0;
                int c = 0;
                for (r = 0; r < di1.length && di1[r] != ii1; ++r) {
                }
                for (c = 0; c < di2.length && di2[c] != ii2; ++c) {
                }
                double diff2 = data[r][c] - row[j];
                double[] dArray = stddev[r];
                int n = c;
                dArray[n] = dArray[n] + diff2 * diff2;
            }
            int thirdD = this.getNumRows() / di1.length / di2.length;
            for (int r = 0; r < di1.length; ++r) {
                for (int c = 0; c < di2.length; ++c) {
                    stddev[r][c] = Math.sqrt(stddev[r][c] / (double)thirdD);
                }
            }
            table.setData(key + "_stddev", stddev);
        }
        return table;
    }

    public double getAverage(int column) {
        if (column < 0 || column >= this.headers.size()) {
            return 0.0;
        }
        double total = 0.0;
        for (double[] row : this.rows) {
            total += row[column];
        }
        return total / (double)this.rows.size();
    }

    private double[] getDoubleValues(String list) {
        if (list == null) {
            return new double[0];
        }
        String[] svals = list.split("\\s+");
        double[] dvals = new double[svals.length];
        Arrays.fill(dvals, -1.0);
        for (int i = 0; i < svals.length; ++i) {
            try {
                dvals[i] = Double.valueOf(svals[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return new double[0];
            }
        }
        return dvals;
    }

    public static TableData readSpiceMeasResults(String filename) throws SCTimingException {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        try {
            int ttype;
            ArrayList<String> headers = new ArrayList<String>();
            StreamTokenizer s2 = new StreamTokenizer(reader);
            s2.resetSyntax();
            s2.wordChars(0, 255);
            s2.whitespaceChars(32, 32);
            s2.whitespaceChars(9, 9);
            s2.whitespaceChars(13, 13);
            s2.whitespaceChars(10, 10);
            s2.whitespaceChars(12, 12);
            s2.quoteChar(39);
            s2.quoteChar(34);
            s2.eolIsSignificant(true);
            boolean title = false;
            while ((ttype = s2.nextToken()) != -1) {
                if (!title && ttype == -3 && s2.sval.equalsIgnoreCase(".TITLE")) {
                    title = true;
                    continue;
                }
                if (!title || ttype != 10) continue;
            }
            s2.eolIsSignificant(false);
            while ((ttype = s2.nextToken()) != -1) {
                if (ttype != -3) {
                    throw new SCTimingException("Expected string, but got " + s2.toString() + " while parsing index data of " + filename);
                }
                headers.add(s2.sval);
                if (!s2.sval.equals("alter#")) continue;
            }
            TableData data = new TableData(headers);
            int i = 0;
            double[] row = new double[headers.size()];
            while ((ttype = s2.nextToken()) != -1) {
                if (i == 0) {
                    row = new double[headers.size()];
                }
                if (ttype != -3) {
                    throw new SCTimingException("Expected value, but got '" + s2.toString() + "' while parsing index data of " + filename);
                }
                try {
                    row[i] = Double.parseDouble(s2.sval);
                }
                catch (NumberFormatException e) {
                    if (s2.sval.equalsIgnoreCase("failed")) {
                        row[i] = Double.NaN;
                    }
                    throw new SCTimingException("Expected numeric value, but got '" + s2.toString() + "' while parsing spice measurement file " + filename);
                }
                if (++i != headers.size()) continue;
                data.addRow(row);
                i = 0;
            }
            reader.close();
            return data;
        }
        catch (IOException e) {
            throw new SCTimingException(e.getMessage());
        }
    }
}

