/*
   Copyright (c) 1999,2000,2001,2002 Grahame M. Kelly (grahame@wildpossum.com)
   You may distribute and/or use for any purpose modified or unmodified
   copies of this software if you preserve the copyright notice above.

   THIS SOFTWARE IS PROVIDED AS IS AND COME WITH NO WARRANTY OF ANY
   KIND, EITHER EXPRESSED OR IMPLIED.  IN NO EVENT WILL THE
   COPYRIGHT HOLDER BE LIABLE FOR ANY DAMAGES RESULTING FROM THE
   USE OF THIS SOFTWARE.

   LinuxSPA (Linux Serial Protocol Analyser) for reverse engineering
   the Nikon E950 Digitial Camera Protocols so that the GNU GPhoto system may
   be used under Linux OS.

   My thanks to Walter Harms <WHarms@bfs.de> for Modem Status monitoring code.


   Revision     Date            Comments
   --------     ----            ---------------------------------------

   07           19/04/02        Command Line Switches and some bug fixes
   06		02/02/02	Bug Fixes
   05		02/10/99	Modified for User Filter Operation
   00           26/09/99        Initial 

*/

#define _GNU_SOURCE
#define _POSIX_SOURCE 1         /* POSIX compliant source */

#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>

#define TRUE 1
#define FALSE 0
#define CAMERA_IN	'<'
#define CAMERA_OUT	'>'
#define REV_Major "0\0"
#define REV_Minor "7\0"

#define BUFFSIZE 256
#define SSIZE  BUFFSIZE-1
#define LOWSIZE 40
#define LineMAX 8
#define PipeBuffSize 16
#define SOH '#'
#define EOH '@'
#define DEFAULT_A	"/dev/ttyS0"
#define DEFAULT_B	"/dev/ttyS1"
#define DEFAULT_BAUD	"115200"
#define DEFAULT_DATA	8
#define DEFAULT_PARITY	0
#define DEFAULT_STOP	1

/* Type 1 PLUG is where we don't echo char but just listen  */
/* Type 2 PLUG is where we have to input and then echo char */
#define DEFAULT_TYPE	1
#define DEFAULT_DEBUG	FALSE

typedef unsigned char byte;
typedef int boolean;
typedef void Sigfunc (int);
#if defined(SIG_IGN) && !defined(SIG_ERR)
#defined SIG_ERR ((Sigfunc *)-1)
#endif

Sigfunc *signal_intr (int, Sigfunc *);
int piper (int fdD);
char *Convert (byte inchar);
int user_format (char direction, byte * Obuffer, int bytes_read);
void help (void);
speed_t what_speed (int);

struct ppack
  {
    char direction;
    int count;
    byte PBuff[PipeBuffSize];
  };
