/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.jrobin.mrtg.MrtgConstants;
import org.jrobin.mrtg.client.LinkInfo;
import org.jrobin.mrtg.client.RouterInfo;

class RpcClient
implements MrtgConstants {
    private XmlRpcClient webClient;

    RpcClient(String string) throws IOException {
        this.webClient = new XmlRpcClient(string, 35353);
    }

    Hashtable getMrtgInfo() throws IOException, XmlRpcException {
        Vector vector = new Vector();
        return (Hashtable)this.webClient.execute("mrtg.getMrtgInfo", vector);
    }

    byte[] getPngGraph(RouterInfo routerInfo, LinkInfo linkInfo, Date date, Date date2) throws IOException, XmlRpcException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(routerInfo.getHost());
        vector.add(linkInfo.getIfDescr());
        vector.add(date);
        vector.add(date2);
        return (byte[])this.webClient.execute("mrtg.getPngGraph", vector);
    }

    int addRouter(RouterInfo routerInfo) throws IOException, XmlRpcException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(routerInfo.getHost());
        vector.add(routerInfo.getCommunity());
        vector.add(routerInfo.getDescr());
        vector.add(new Boolean(routerInfo.isActive()));
        return (Integer)this.webClient.execute("mrtg.addRouter", vector);
    }

    int updateRouter(RouterInfo routerInfo) throws IOException, XmlRpcException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(routerInfo.getHost());
        vector.add(routerInfo.getCommunity());
        vector.add(routerInfo.getDescr());
        vector.add(new Boolean(routerInfo.isActive()));
        return (Integer)this.webClient.execute("mrtg.updateRouter", vector);
    }

    int deleteRouter(RouterInfo routerInfo) throws IOException, XmlRpcException {
        Vector<String> vector = new Vector<String>();
        vector.add(routerInfo.getHost());
        return (Integer)this.webClient.execute("mrtg.removeRouter", vector);
    }

    Vector getAvailableLinks(RouterInfo routerInfo) throws IOException, XmlRpcException {
        Vector<String> vector = new Vector<String>();
        vector.add(routerInfo.getHost());
        Vector vector2 = (Vector)this.webClient.execute("mrtg.getAvailableLinks", vector);
        return vector2;
    }

    int addLink(RouterInfo routerInfo, LinkInfo linkInfo) throws XmlRpcException, IOException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(routerInfo.getHost());
        vector.add(linkInfo.getIfDescr());
        vector.add(linkInfo.getDescr());
        vector.add(new Integer(linkInfo.getSamplingInterval()));
        vector.add(new Boolean(linkInfo.isActive()));
        return (Integer)this.webClient.execute("mrtg.addLink", vector);
    }

    int updateLink(RouterInfo routerInfo, LinkInfo linkInfo) throws XmlRpcException, IOException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(routerInfo.getHost());
        vector.add(linkInfo.getIfDescr());
        vector.add(linkInfo.getDescr());
        vector.add(new Integer(linkInfo.getSamplingInterval()));
        vector.add(new Boolean(linkInfo.isActive()));
        return (Integer)this.webClient.execute("mrtg.updateLink", vector);
    }

    int removeLink(RouterInfo routerInfo, LinkInfo linkInfo) throws XmlRpcException, IOException {
        Vector<String> vector = new Vector<String>();
        vector.add(routerInfo.getHost());
        vector.add(linkInfo.getIfDescr());
        return (Integer)this.webClient.execute("mrtg.removeLink", vector);
    }
}

