/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MultimapSubject
extends Subject {
    private static final Ordered ALREADY_FAILED = new Ordered(){

        @Override
        public void inOrder() {
        }
    };
    private final Multimap<?, ?> actual;

    protected MultimapSubject(FailureMetadata metadata, @Nullable Multimap<?, ?> multimap) {
        this(metadata, multimap, (String)null);
    }

    MultimapSubject(FailureMetadata metadata, @Nullable Multimap<?, ?> multimap, @Nullable String typeDescription) {
        super(metadata, multimap, typeDescription);
        this.actual = multimap;
    }

    public final void isEmpty() {
        if (!this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (this.actual.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (int)expectedSize);
        this.check("size()", new Object[0]).that(this.actual.size()).isEqualTo(expectedSize);
    }

    public final void containsKey(@Nullable Object key) {
        this.check("keySet()", new Object[0]).that(this.actual.keySet()).contains(key);
    }

    public final void doesNotContainKey(@Nullable Object key) {
        this.check("keySet()", new Object[0]).that(this.actual.keySet()).doesNotContain(key);
    }

    public final void containsEntry(@Nullable Object key, @Nullable Object value) {
        if (!this.actual.containsEntry(key, value)) {
            Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
            ImmutableList entryList = ImmutableList.of((Object)entry);
            if (SubjectUtils.hasMatchingToStringPair(this.actual.entries(), entryList)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.fact("an instance of", SubjectUtils.objectToTypeName(entry)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.entries(), entryList))), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (this.actual.containsKey(key)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.simpleFact("but did not"), Fact.fact("though it did contain values with that key", this.actual.asMap().get(key)), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (this.actual.containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : this.actual.entries()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.simpleFact("but did not"), Fact.fact("though it did contain keys with that value", keys), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else {
                this.failWithActual("expected to contain entry", Maps.immutableEntry((Object)key, (Object)value));
            }
        }
    }

    public final void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        this.checkNoNeedToDisplayBothValues("entries()", new Object[0]).that(this.actual.entries()).doesNotContain(Maps.immutableEntry((Object)key, (Object)value));
    }

    public IterableSubject valuesForKey(@Nullable Object key) {
        return this.check("valuesForKey(%s)", key).that(this.actual.get(key));
    }

    @Override
    public final void isEqualTo(@Nullable Object other) {
        boolean isEqual = Objects.equal(this.actual, (Object)other);
        if (isEqual) {
            return;
        }
        if (this.actual instanceof ListMultimap && other instanceof SetMultimap || this.actual instanceof SetMultimap && other instanceof ListMultimap) {
            String actualType = this.actual instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
            String otherType = other instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
            this.failWithoutActual(Fact.fact("expected", other), Fact.fact("an instance of", otherType), Fact.fact("but was", this.actualCustomStringRepresentationForPackageMembersToCall()), Fact.fact("an instance of", actualType), Fact.simpleFact(Strings.lenientFormat((String)"a %s cannot equal a %s if either is non-empty", (Object[])new Object[]{actualType, otherType})));
        } else if (this.actual instanceof ListMultimap) {
            this.containsExactlyEntriesIn((Multimap)other).inOrder();
        } else if (this.actual instanceof SetMultimap) {
            this.containsExactlyEntriesIn((Multimap)other);
        } else {
            super.isEqualTo(other);
        }
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, (Object)"expectedMultimap");
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, this.actual);
        ListMultimap<?, ?> extra = MultimapSubject.difference(this.actual, expectedMultimap);
        if (!missing.isEmpty()) {
            if (!extra.isEmpty()) {
                boolean addTypeInfo = SubjectUtils.hasMatchingToStringPair(missing.entries(), extra.entries());
                String missingDisplay = addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(missing).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing));
                String extraDisplay = addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(extra).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra));
                this.failWithActual(Fact.fact("missing", missingDisplay), Fact.fact("unexpected", extraDisplay), Fact.simpleFact("---"), Fact.fact("expected", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
                return ALREADY_FAILED;
            }
            this.failWithActual(Fact.fact("missing", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing))), Fact.simpleFact("---"), Fact.fact("expected", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
            return ALREADY_FAILED;
        }
        if (!extra.isEmpty()) {
            this.failWithActual(Fact.fact("unexpected", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra))), Fact.simpleFact("---"), Fact.fact("expected", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
            return ALREADY_FAILED;
        }
        return new MultimapInOrder(false, expectedMultimap);
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeastEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, (Object)"expectedMultimap");
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, this.actual);
        if (!missing.isEmpty()) {
            this.failWithActual(Fact.fact("missing", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing))), Fact.simpleFact("---"), Fact.fact("expected to contain at least", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
            return ALREADY_FAILED;
        }
        return new MultimapInOrder(true, expectedMultimap);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly() {
        return this.check().about(this.iterableEntries()).that(this.actual.entries()).containsExactly(new Object[0]);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn(MultimapSubject.accumulateMultimap(k0, v0, rest));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeast(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.containsAtLeastEntriesIn(MultimapSubject.accumulateMultimap(k0, v0, rest));
    }

    private static Multimap<Object, Object> accumulateMultimap(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        Preconditions.checkArgument((rest.length % 2 == 0 ? 1 : 0) != 0, (String)"There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", (int)(rest.length + 2));
        LinkedListMultimap expectedMultimap = LinkedListMultimap.create();
        expectedMultimap.put(k0, v0);
        for (int i = 0; i < rest.length; i += 2) {
            expectedMultimap.put(rest[i], rest[i + 1]);
        }
        return expectedMultimap;
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterableEntries() {
        return new Subject.Factory<IterableSubject, Iterable<?>>(){

            @Override
            public IterableSubject createSubject(FailureMetadata metadata, Iterable<?> actual) {
                return new IterableEntries(metadata, MultimapSubject.this, actual);
            }
        };
    }

    private static boolean advanceToFind(Iterator<?> iterator, Object value) {
        while (iterator.hasNext()) {
            if (!Objects.equal(iterator.next(), (Object)value)) continue;
            return true;
        }
        return false;
    }

    private static <V> Collection<V> get(Multimap<?, V> multimap, @Nullable Object key) {
        if (multimap.containsKey(key)) {
            return (Collection)multimap.asMap().get(key);
        }
        return ImmutableList.of();
    }

    private static ListMultimap<?, ?> difference(Multimap<?, ?> minuend, Multimap<?, ?> subtrahend) {
        LinkedListMultimap difference = LinkedListMultimap.create();
        for (Object key : minuend.keySet()) {
            List<?> valDifference = MultimapSubject.difference(Lists.newArrayList(MultimapSubject.get(minuend, key)), Lists.newArrayList(MultimapSubject.get(subtrahend, key)));
            difference.putAll(key, valDifference);
        }
        return difference;
    }

    private static List<?> difference(List<?> minuend, List<?> subtrahend) {
        LinkedHashMultiset remaining = LinkedHashMultiset.create(subtrahend);
        ArrayList difference = Lists.newArrayList();
        for (Object elem : minuend) {
            if (remaining.remove(elem)) continue;
            difference.add(elem);
        }
        return difference;
    }

    private static String countDuplicatesMultimap(Multimap<?, ?> multimap) {
        ArrayList<String> entries = new ArrayList<String>();
        for (Object key : multimap.keySet()) {
            String string = String.valueOf(key);
            String string2 = SubjectUtils.countDuplicates(MultimapSubject.get(multimap, key));
            entries.add(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on((String)", ").appendTo(sb, entries);
        sb.append("}");
        return sb.toString();
    }

    private static Multimap<?, ?> annotateEmptyStringsMultimap(Multimap<?, ?> multimap) {
        if (multimap.containsKey((Object)"") || multimap.containsValue((Object)"")) {
            LinkedListMultimap annotatedMultimap = LinkedListMultimap.create();
            for (Map.Entry entry : multimap.entries()) {
                String key = "".equals(entry.getKey()) ? "\"\" (empty String)" : entry.getKey();
                String value = "".equals(entry.getValue()) ? "\"\" (empty String)" : entry.getValue();
                annotatedMultimap.put((Object)key, (Object)value);
            }
            return annotatedMultimap;
        }
        return multimap;
    }

    public <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    private static final class EntryCorrespondence<K, A, E>
    extends Correspondence<Map.Entry<K, A>, Map.Entry<K, E>> {
        private final Correspondence<? super A, ? super E> valueCorrespondence;

        EntryCorrespondence(Correspondence<? super A, ? super E> valueCorrespondence) {
            this.valueCorrespondence = valueCorrespondence;
        }

        @Override
        public boolean compare(Map.Entry<K, A> actual, Map.Entry<K, E> expected) {
            return Objects.equal(actual.getKey(), expected.getKey()) && this.valueCorrespondence.compare(actual.getValue(), expected.getValue());
        }

        @Override
        public String toString() {
            return Strings.lenientFormat((String)"has a key that is equal to and a value that %s the key and value of", (Object[])new Object[]{this.valueCorrespondence});
        }
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<? super A, ? super E> correspondence;

        private UsingCorrespondence(Correspondence<? super A, ? super E> correspondence) {
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(@Nullable Object expectedKey, @Nullable E expectedValue) {
            if (MultimapSubject.this.actual.containsKey(expectedKey)) {
                Collection actualValues = (Collection)this.getCastActual().asMap().get(expectedKey);
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Object actualValue : actualValues) {
                    if (!this.correspondence.safeCompare(actualValue, expectedValue, exceptions)) continue;
                    if (exceptions.hasCompareException()) {
                        MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected to contain entry", Maps.immutableEntry((Object)expectedKey, expectedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.fact("found match (but failing because of exception)", Maps.immutableEntry((Object)expectedKey, actualValue))).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).build());
                    }
                    return;
                }
                MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain entry", Maps.immutableEntry((Object)expectedKey, expectedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.simpleFact("but did not")).add((Object)Fact.fact("though it did contain values for that key", actualValues)).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).addAll(exceptions.describeAsAdditionalInfo()).build());
            } else {
                LinkedHashSet<Map.Entry> entries = new LinkedHashSet<Map.Entry>();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Map.Entry actualEntry : this.getCastActual().entries()) {
                    if (!this.correspondence.safeCompare(actualEntry.getValue(), expectedValue, exceptions)) continue;
                    entries.add(actualEntry);
                }
                if (!entries.isEmpty()) {
                    MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain entry", Maps.immutableEntry((Object)expectedKey, expectedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.simpleFact("but did not")).add((Object)Fact.fact("though it did contain entries with matching values", entries)).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).addAll(exceptions.describeAsAdditionalInfo()).build());
                } else {
                    MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain entry", Maps.immutableEntry((Object)expectedKey, expectedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.simpleFact("but did not")).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).addAll(exceptions.describeAsAdditionalInfo()).build());
                }
            }
        }

        public void doesNotContainEntry(@Nullable Object excludedKey, @Nullable E excludedValue) {
            if (MultimapSubject.this.actual.containsKey(excludedKey)) {
                Collection actualValues = (Collection)this.getCastActual().asMap().get(excludedKey);
                ArrayList matchingValues = new ArrayList();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Object actualValue : actualValues) {
                    if (!this.correspondence.safeCompare(actualValue, excludedValue, exceptions)) continue;
                    matchingValues.add(actualValue);
                }
                if (!matchingValues.isEmpty()) {
                    MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected not to contain entry", Maps.immutableEntry((Object)excludedKey, excludedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.fact("but contained that key with matching values", matchingValues)).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).addAll(exceptions.describeAsAdditionalInfo()).build());
                } else if (exceptions.hasCompareException()) {
                    MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected not to contain entry", Maps.immutableEntry((Object)excludedKey, excludedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.simpleFact("found no match (but failing because of exception)")).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).build());
                }
            }
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Multimap<?, ? extends E> expectedMultimap) {
            return this.internalContainsExactlyEntriesIn(expectedMultimap);
        }

        private <K, V extends E> Ordered internalContainsExactlyEntriesIn(Multimap<K, V> expectedMultimap) {
            return ((IterableSubject)MultimapSubject.this.check().about(MultimapSubject.this.iterableEntries()).that(MultimapSubject.this.actual.entries())).comparingElementsUsing(new EntryCorrespondence(this.correspondence)).containsExactlyElementsIn(expectedMultimap.entries());
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastEntriesIn(Multimap<?, ? extends E> expectedMultimap) {
            return this.internalContainsAtLeastEntriesIn(expectedMultimap);
        }

        private <K, V extends E> Ordered internalContainsAtLeastEntriesIn(Multimap<K, V> expectedMultimap) {
            return ((IterableSubject)MultimapSubject.this.check().about(MultimapSubject.this.iterableEntries()).that(MultimapSubject.this.actual.entries())).comparingElementsUsing(new EntryCorrespondence(this.correspondence)).containsAtLeastElementsIn(expectedMultimap.entries());
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(@Nullable Object k0, @Nullable E v0, Object ... rest) {
            Multimap expectedMultimap = MultimapSubject.accumulateMultimap(k0, v0, rest);
            return this.containsExactlyEntriesIn(expectedMultimap);
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly() {
            return MultimapSubject.this.containsExactly();
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeast(@Nullable Object k0, @Nullable E v0, Object ... rest) {
            Multimap expectedMultimap = MultimapSubject.accumulateMultimap(k0, v0, rest);
            return this.containsAtLeastEntriesIn(expectedMultimap);
        }

        private Multimap<?, A> getCastActual() {
            return MultimapSubject.this.actual;
        }
    }

    private class MultimapInOrder
    implements Ordered {
        private final Multimap<?, ?> expectedMultimap;
        private final boolean allowUnexpected;

        MultimapInOrder(boolean allowUnexpected, Multimap<?, ?> expectedMultimap) {
            this.expectedMultimap = expectedMultimap;
            this.allowUnexpected = allowUnexpected;
        }

        @Override
        public void inOrder() {
            boolean keysInOrder = Lists.newArrayList((Iterable)Sets.intersection((Set)MultimapSubject.this.actual.keySet(), (Set)this.expectedMultimap.keySet())).equals(Lists.newArrayList((Iterable)this.expectedMultimap.keySet()));
            LinkedHashSet keysWithValuesOutOfOrder = Sets.newLinkedHashSet();
            block0: for (Object key : this.expectedMultimap.keySet()) {
                ArrayList actualVals = Lists.newArrayList((Iterable)MultimapSubject.get(MultimapSubject.this.actual, key));
                ArrayList expectedVals = Lists.newArrayList((Iterable)MultimapSubject.get(this.expectedMultimap, key));
                Iterator actualIterator = actualVals.iterator();
                for (Object value : expectedVals) {
                    if (MultimapSubject.advanceToFind(actualIterator, value)) continue;
                    keysWithValuesOutOfOrder.add(key);
                    continue block0;
                }
            }
            if (!keysInOrder) {
                if (!keysWithValuesOutOfOrder.isEmpty()) {
                    MultimapSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.simpleFact("keys are not in order"), Fact.fact("keys with out-of-order values", keysWithValuesOutOfOrder), Fact.simpleFact("---"), Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMultimap));
                } else {
                    MultimapSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.simpleFact("keys are not in order"), Fact.simpleFact("---"), Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMultimap));
                }
            } else if (!keysWithValuesOutOfOrder.isEmpty()) {
                MultimapSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.fact("keys with out-of-order values", keysWithValuesOutOfOrder), Fact.simpleFact("---"), Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMultimap));
            }
        }
    }

    private static class IterableEntries
    extends IterableSubject {
        private final String stringRepresentation;

        IterableEntries(FailureMetadata metadata, MultimapSubject multimapSubject, Iterable<?> actual) {
            super(metadata, actual);
            this.stringRepresentation = multimapSubject.actual.toString();
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return this.stringRepresentation;
        }
    }
}

