/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery;

import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.config.discovery.AbstractDiscoveryService;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.binding.ThingHandler;
import org.openhab.core.thing.binding.ThingHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractThingHandlerDiscoveryService<T extends ThingHandler>
extends AbstractDiscoveryService
implements ThingHandlerService {
    private final Logger logger = LoggerFactory.getLogger(AbstractThingHandlerDiscoveryService.class);
    private final Class<T> thingClazz;
    private boolean backgroundDiscoveryEnabled = false;
    @NonNullByDefault(value={})
    protected T thingHandler = null;

    protected AbstractThingHandlerDiscoveryService(Class<T> thingClazz, @Nullable Set<ThingTypeUID> supportedThingTypes, int timeout, boolean backgroundDiscoveryEnabledByDefault, @Nullable String scanInputLabel, @Nullable String scanInputDescription) throws IllegalArgumentException {
        super(supportedThingTypes, timeout, backgroundDiscoveryEnabledByDefault, scanInputLabel, scanInputDescription);
        this.thingClazz = thingClazz;
        this.backgroundDiscoveryEnabled = backgroundDiscoveryEnabledByDefault;
    }

    protected AbstractThingHandlerDiscoveryService(Class<T> thingClazz, @Nullable Set<ThingTypeUID> supportedThingTypes, int timeout, boolean backgroundDiscoveryEnabledByDefault) throws IllegalArgumentException {
        this(thingClazz, supportedThingTypes, timeout, backgroundDiscoveryEnabledByDefault, null, null);
    }

    protected AbstractThingHandlerDiscoveryService(Class<T> thingClazz, @Nullable Set<ThingTypeUID> supportedThingTypes, int timeout) throws IllegalArgumentException {
        this(thingClazz, supportedThingTypes, timeout, true);
    }

    protected AbstractThingHandlerDiscoveryService(Class<T> thingClazz, int timeout) throws IllegalArgumentException {
        this(thingClazz, null, timeout);
    }

    @Override
    protected abstract void startScan();

    public void setThingHandler(ThingHandler handler) {
        if (!this.thingClazz.isAssignableFrom(handler.getClass())) {
            throw new IllegalArgumentException("Expected class is " + String.valueOf(this.thingClazz) + " but the parameter has class " + String.valueOf(handler.getClass()));
        }
        this.thingHandler = handler;
    }

    public @Nullable ThingHandler getThingHandler() {
        return this.thingHandler;
    }

    @Override
    public void activate(@Nullable Map<String, Object> config) {
        if (config != null) {
            this.backgroundDiscoveryEnabled = (Boolean)ConfigParser.valueAsOrElse((Object)config.get("background"), Boolean.class, (Object)this.backgroundDiscoveryEnabled);
        }
    }

    @Override
    public void modified(@Nullable Map<String, Object> config) {
        if (config != null) {
            boolean enabled = (Boolean)ConfigParser.valueAsOrElse((Object)config.get("background"), Boolean.class, (Object)this.backgroundDiscoveryEnabled);
            if (this.backgroundDiscoveryEnabled && !enabled) {
                this.stopBackgroundDiscovery();
                this.logger.debug("Background discovery for discovery service '{}' disabled.", (Object)this.getClass().getName());
            } else if (!this.backgroundDiscoveryEnabled && enabled) {
                this.startBackgroundDiscovery();
                this.logger.debug("Background discovery for discovery service '{}' enabled.", (Object)this.getClass().getName());
            }
            this.backgroundDiscoveryEnabled = enabled;
        }
    }

    @Override
    public void deactivate() {
    }

    public void initialize() {
        if (this.backgroundDiscoveryEnabled) {
            this.startBackgroundDiscovery();
            this.logger.debug("Background discovery for discovery service '{}' enabled.", (Object)this.getClass().getName());
        }
    }

    public void dispose() {
        if (this.backgroundDiscoveryEnabled) {
            this.stopBackgroundDiscovery();
        }
    }
}

