/* arithmetic and bits */
OP(IADD,     "add")
OP(ISUB,     "sub")
OP(INEG,     "neg")
OP(IDIV,     "div")
OP(IMUL,     "mul")
OP(IUDIV,    "udiv")
OP(IREM,     "rem")
OP(IUREM,    "urem")
OP(IOR,      "or")
OP(IXOR,     "xor")
OP(IAND,     "and")
OP(ISAR,     "sar")
OP(ISHR,     "shr")
OP(ISHL,     "shl")

/* memory */
OP(ISTORED,  "stored")
OP(ISTORES,  "stores")
OP(ISTOREL,  "storel")
OP(ISTOREW,  "storew")
OP(ISTOREH,  "storeh")
OP(ISTOREB,  "storeb")
OP(ILOADD,   "loadd")
OP(ILOADS,   "loads")
OP(ILOADL,   "loadl")
OP(ILOADW,   "loadw")
OP(ILOADSH,  "loadsh")
OP(ILOADUH,  "loaduh")
OP(ILOADSB,  "loadsb")
OP(ILOADUB,  "loadub")
OP(IALLOC4,  "alloc4")
OP(IALLOC8,  "alloc8")
OP(IALLOC16, "alloc16")

/* comparisons */
OP(ICEQW,    "ceqw")
OP(ICNEW,    "cnew")
OP(ICSLEW,   "cslew")
OP(ICSLTW,   "csltw")
OP(ICSGEW,   "csgew")
OP(ICSGTW,   "csgtw")
OP(ICULEW,   "culew")
OP(ICULTW,   "cultw")
OP(ICUGEW,   "cugew")
OP(ICUGTW,   "cugtw")

OP(ICEQL,    "ceql")
OP(ICNEL,    "cnel")
OP(ICSLEL,   "cslel")
OP(ICSLTL,   "csltl")
OP(ICSGEL,   "csgel")
OP(ICSGTL,   "csgtl")
OP(ICULEL,   "culel")
OP(ICULTL,   "cultl")
OP(ICUGEL,   "cugel")
OP(ICUGTL,   "cugtl")

OP(ICEQS,    "ceqs")
OP(ICNES,    "cnes")
OP(ICLES,    "cles")
OP(ICLTS,    "clts")
OP(ICGES,    "cges")
OP(ICGTS,    "cgts")
OP(ICOS,     "cos")
OP(ICUOS,    "cuos")

OP(ICEQD,    "ceqd")
OP(ICNED,    "cned")
OP(ICLED,    "cled")
OP(ICLTD,    "cltd")
OP(ICGED,    "cged")
OP(ICGTD,    "cgtd")
OP(ICOD,     "cod")
OP(ICUOD,    "cuod")

/* conversions */
OP(IEXTSW,   "extsw")
OP(IEXTUW,   "extuw")
OP(IEXTSH,   "extsh")
OP(IEXTUH,   "extuh")
OP(IEXTSB,   "extsb")
OP(IEXTUB,   "extub")
OP(IEXTS,    "exts")
OP(ITRUNCD,  "truncd")
OP(ISTOSI,   "stosi")
OP(ISTOUI,   "stoui")
OP(IDTOSI,   "dtosi")
OP(IDTOUI,   "dtoui")
OP(ISWTOF,   "swtof")
OP(IUWTOF,   "uwtof")
OP(ISLTOF,   "sltof")
OP(IULTOF,   "ultof")

/* cast and copy */
OP(ICAST,    "cast")
OP(ICOPY,    "copy")

/* call */
OP(ICALL,    "call")

/* variadic */
OP(IVASTART, "vastart")
OP(IVAARG,   "vaarg")
