#pragma once

static std::vector<std::string> db_justifier_games {
    "42f3084ce3f529b46090b9e1d781717d", // Lethal Enforcers (Europe)
    "3a33512ae5b1f2047bcd77e1d3e1ce4a", // Lethal Enforcers (Japan)
    "928a0d7feeb4edee8d53203a575968e6", // Lethal Enforcers (USA)
};

static std::vector<std::string> db_mouse_games {
    "76392b4b33146fe4fac5b26358a9b9f4", // ACME Animation Factory (Europe)
    "4623fc6ecf936f67c21e2d4bcadabf80", // ACME Animation Factory (USA)
    "37c38e3fc469d69e8432e69982537de3", // Advanced Dungeons & Dragons - Eye of the Beholder (USA)
    "9907058db9815c7f4068a6edb870d673", // Alice no Paint Adventure (Japan)
    "06effcf7fd688f89e63e83ae2369d1c5", // Arkanoid - Doh It Again (Europe)
    "2cdba2ea2369bfe29e9b5c59a04c8f8e", // Arkanoid - Doh It Again (Japan) (En)
    "03d30ca9aaa89738640cf14532ddfe6c", // Arkanoid - Doh It Again (USA)
    "a7cf8b4a9da276955118aef0df61987c", // Asameshimae Nyanko (Japan)
    "60e054a73bcab9c73a73c05c5e17dcd1", // Bishoujo Senshi Sailor Moon S - Kondo wa Puzzle de Oshioki yo! (Japan)
    "3e649d0b0fa80578bc25f7d225556061", // Brandish 2 - Expert (Japan)
    "16647a6edc60975425d52c255c4c8523", // Brandish 2 - The Planet Buster (Japan)
    "269025c5eb1c97f7effc613762ee06cf", // BreakThru! (USA)
    "8a61ea1d3b53375aae00cc69367dec7e", // Cannon Fodder (Europe)
    "e90e62287c85eb0a0cd975a941ef47e5", // Civilization - Sekai Shichi Daibunmei (Japan)
    "f48d823cf1c1536910efa30b5bf3be0f", // Doukyuusei 2 (Japan) (NP)
    "ef22dfadc9c5f1de69ee0416b144372a", // Farland Story 2 (Japan)
    "52c34e40808950a2c985c1c3962c30d9", // Galaxy Robo (Japan)
    "64b9b14ba3a44d720deefc50cf8c2540", // Hiouden - Mamono-tachi to no Chikai (Japan)
    "374642fc7f368a7af262c7d945c26f9e", // Lemmings 2 - The Tribes (Europe)
    "3bcbd2878d937046ec2379c7433631db", // Lemmings 2 - The Tribes (Japan)
    "4269b8d0d9def1ac349faadf3b93bcef", // Lemmings 2 - The Tribes (USA)
    "e892b0b0e2d58bd74abb1a730f7552f6", // Mario Paint (Europe)
    "881d3772a3eb37a8a0fb254e940c6767", // Mario Paint (Japan, USA)
    "85b259000a1dbe674af2f5459f13e4b8", // Mario Paint (Japan, USA) (Beta)
    "b1774f03700dfc311bfd86411db629c3", // Mario to Wario (Japan)
    "18db415de1a6eaf478852bd1f1f63c3a", // Mario's Early Years - Fun with Letters (USA)
    "d097b8f2871522c7c1d2bbd18e7c9ad4", // Mario's Early Years - Fun with Numbers (USA)
    "32b01a3af01aaaf7c65ba5d193e00050", // Mario's Early Years - Preschool Fun (USA)
    "c4f00590c3f40736a13739b5785c2ff4", // Mega lo Mania (Europe) (En,Fr,De) (Beta)
    "34d8995fe25908757ad225b4d7a17581", // Mega lo Mania - Jikuu Daisenryaku (Japan)
    "7a67d33f2cfc8c284f772cb681c411a2", // Mega-lo-Mania (Europe) (En,Fr,De)
    "08f47c5f448e1fc8e07b89e14bd7461e", // Might and Magic III - Isles of Terra (USA)
    "d1eafd8e9569ca325d6ef29833224eea", // Might and Magic III - Isles of Terra (USA) (Beta)
    "ae83f7bb3966cc887fa210aebb5422b0", // Motoko-chan no Wonder Kitchen (Japan)
    "fa557c6b77c393c6d7796b0c5d445acb", // Nobunaga no Yabou - Haouden (Japan)
    "f82bd76788a41937041d8a5dcdce368a", // Nobunaga no Yabou - Haouden (Japan) (Rev 1)
    "6ddce6fdbf50da1a3d8089844a7bdbf6", // Populous II - Trials of the Olympian Gods (Europe)
    "7b93c4a184cd4d360c2cf7c9411f3644", // Populous II - Trials of the Olympian Gods (Germany)
    "83b543020e09bf69dfc1d4ad41da1f2d", // Populous II - Trials of the Olympian Gods (Japan)
    "cc6ebda0842675456a8d6a5372e19683", // PowerMonger (Europe)
    "82eae959ae51b041489f7c1c2a1fef11", // PowerMonger - Mashou no Bouryaku (Japan)
    "cec5cf36812a8390a739bdf3fe654c22", // Sangokushi Seishi - Tenbu Spirits (Japan)
    "73653db58071937b4d2bb03c7a057a5f", // Sgt. Saunders' Combat! (Japan)
    "faa2d43f507e35caebbea263a36dc6bf", // Sid Meier's Civilization (USA)
    "6a0e385197cac8f64318ec7117d232fd", // Sid Meier's Civilization (USA) (Beta)
    "8646848425c8d218a711f440bcafde3b", // SimAnt (Japan)
    "1662e41dec5c6976987b482cdceedd2e", // SimAnt (USA) (Beta)
    "330f18b975341a10ee1d36f7a626330c", // SimAnt - The Electronic Ant Colony (USA)
    "5ae643072832047b09462f111099b4f5", // Sound Factory (Japan) (En) (Proto)
    "88fbe1d0108b212e4a5e05659f68ee2e", // SpellCraft - Aspects of Valor (USA) (Proto)
    "84aaaaffeb14ed94344b0495e8beffb1", // Super Castles (Japan)
    "12a8b93c8e3bc5e62c63d6572e014f10", // Super Nobunaga no Yabou - Zenkoku Ban (Japan)
    "992d003e36eb35b063b2abce309dc959", // Super Nobunaga no Yabou - Zenkoku Ban (Japan) (Rev 1)
    "0edf50a2fc6957b29291030b002762c3", // Super Solitaire (Europe) (En,Fr,De,Es,It) (Proto)
    "2810c6f1191e23ed158ae4237d0519fe", // Super Solitaire (USA) (En,Fr,De,Es,It)
    "5b19374bf681017280af4841c3d97adc", // Trump Island (Japan)
    "cdca5978f74062b38b5fde8c54c833ca", // Tokimeki Memorial - Densetsu no Ki no Shita de (Japan)
    "cd36eb8982de4bf8369deb9f2f23e590", // Tokimeki Memorial - Densetsu no Ki no Shita de (Japan) (Rev 1)
    "69b3902862e87ced1efe9c10f1a7fe08", // Utopia - The Creation of a Nation (Europe)
    "45ce898bf6d5d2e6985c09ade904b1f7", // Utopia (Germany)
    "4ec1f4febe8e9f33d87a57dc04c5a086", // Utopia (Japan)
    "69b3902862e87ced1efe9c10f1a7fe08", // Utopia - The Creation of a Nation (Europe)
    "b8b521a743405aea9e9c2ca9a5c77f9f", // Utopia - The Creation of a Nation (USA)
    "5bb4f9f013b8cd61e65fb6f0e07ff4f5", // Utopia - The Creation of a Nation (USA) (Beta)
    "42e9be5f98bb5ece06da79b3dbf26fa9", // Wonder Project J - Kikai no Shounen Pino (Japan)
    "df5744da0eb4342f2e3302ca5db81b01", // Zico Soccer (Japan)
};

struct mtentry_t {
    std::string md5; int players;
};

// This list may not be complete or accurate -- 5 players assumed if unknown
static std::vector<mtentry_t> db_multitap_games = {
    { "6f76a0bc204424863a9ba846f5183996", 5 }, // Bakukyuu Renpatsu!! Super B-Daman (Japan)
    { "0af9942d16a95e484c5b689e80ccb6ae", 5 }, // Bakutou Dochers - Bumps-jima wa Oosawagi (Japan)
    { "7537f4b1bb522c1b65b2a623bbe3982a", 4 }, // Barkley Shut Up and Jam! (Europe)
    { "c153b93d685c7f9afabcde953b97b211", 4 }, // Barkley Shut Up and Jam! (USA)
    { "3cbbb9e3abd7d472c640e48ff5e1a2a2", 4 }, // Barkley no Power Dunk (Japan) (En)
    { "f0c2849e45efdf55ad078d78de427c42", 5 }, // Battle Cross (Japan)
    { "cbeed25156db82fe6e87c3d57ffaa37d", 5 }, // Battle Jockey (Japan)
    { "8ee34ea0392d7f637fe96d82e034270d", 5 }, // Bill Walsh College Football (USA)
    { "d66e6ecc1e56820f7bcb2ac68bb26c21", 4 }, // Bomberman B-Daman (Japan)
    { "43d7b44bd4655316c130c20b1c95a664", 4 }, // Capcom's Soccer Shootout (USA) (Beta)
    { "6f805455e3bff392c51c65fc07eed939", 4 }, // Capcom's Soccer Shootout (USA)
    { "b1143f5577bf8a872e58010202d371c8", 5 }, // Chibi Maruko-chan - Harikiri 365-nichi no Maki (Japan)
    { "8d594e0dd7e6c90e062d3f961d14c89f", 5 }, // Chibi Maruko-chan - Mezase! Minami no Island!! (Japan) (Beta)
    { "6260edbf892cb17fa58a0a1f0557eb32", 5 }, // Chibi Maruko-chan - Mezase! Minami no Island!! (Japan)
    { "b428007a4cc5344c18de547a5212ac22", 4 }, // College Slam (USA) (Beta)
    { "2d854d5e4cf1e6277c12a0def1ca49c3", 4 }, // College Slam (USA)
    { "18c356623ae0407119ceae8c06edfa7a", 3 }, // Crystal Beans from Dungeon Explorer (Japan)
    { "931c9baff50537c97c69f0b54dd2b3d5", 3 }, // Dragon - The Bruce Lee Story (Europe)
    { "103152554973d6db6e53013eb10c383f", 3 }, // Dragon - The Bruce Lee Story (USA)
    { "bf0c7779579125fd2868f42669b6e67c", 5 }, // Dream Basketball - Dunk & Hoop (Japan)
    { "2a41d00e04f6b3d785320867ed63f351", 5 }, // Dynamic Stadium (Japan)
    { "76d7ade004f309504b2229118c7cf93c", 5 }, // ESPN National Hockey Night (USA)
    { "4db096b5d157e41b5d26acb6e6cf8420", 5 }, // Elite Soccer (USA)
    { "9036d197e04ee34d7d364edc70c6744f", 5 }, // FIFA - A Caminho Da Copa 98 (Brazil) (En,Fr,De,Es,It,Sv)
    { "ca3d4c3e4c3d4716b82b3b91aefd16b0", 5 }, // FIFA - Road to World Cup 98 (Europe) (En,Fr,De,Es,It,Sv) (A8FE)
    { "29b3e4be108867b5742aacdb7f554956", 5 }, // FIFA - Road to World Cup 98 (Europe) (En,Fr,De,Es,It,Sv) (A8FP)
    { "a668ab370210847e7922c58a9ea7fddb", 5 }, // FIFA International Soccer (Europe)
    { "a04c2348002ecb96b0739ad2f7bdf51c", 5 }, // FIFA International Soccer (Japan)
    { "ad986d7bcf92de548441e03fc60b4ee7", 5 }, // FIFA International Soccer (USA)
    { "ee9652bef0f7930ba02ec06028dd5bd2", 5 }, // FIFA Soccer 96 (Europe) (En,Fr,De,Es,It,Sv)
    { "8b3448cce7440268d34fa7b4c46c5966", 5 }, // FIFA Soccer 96 (USA) (En,Fr,De,Es,It,Sv)
    { "c4b3ea8ce3780425ef7d8ce2f5951400", 5 }, // FIFA Soccer 97 (USA) (En,Fr,De,Es,It,Sv)
    { "e76185ddf24f2ccd4b57bd25990a179f", 5 }, // Fever Pitch Soccer (Europe) (Beta)
    { "c2a0a1f3c9687e8c08e531986a8b2cb8", 5 }, // Fever Pitch Soccer (Europe) (En,Fr,De,Es,It)
    { "081b7732af4ebf84061f9066cfc6c005", 5 }, // Finalset (Japan) (Beta)
    { "e7983ce819f5a5976b0bd6e9ec20b9ba", 5 }, // Finalset (Japan)
    { "4106c9d86f490566cc87ca763d74ce66", 4 }, // FireStriker (USA) (Beta)
    { "a9bb24a7622114b91ca85dcb30026830", 4 }, // FireStriker (USA)
    { "665fc614ef687fd2158e738cc1fd710d", 5 }, // From TV Animation Slam Dunk - SD Heat Up!! (Japan)
    { "8cb900956009cbb50803760f30c57e48", 5 }, // Go! Go! Dodge League (Japan) (Rev 1)
    { "6d08044c3f407679ab69523100868529", 5 }, // Go! Go! Dodge League (Japan)
    { "8a0e00d2ac4f6ae8cc4dd17f46620304", 4 }, // Hammer Lock Wrestling (USA)
    { "112263a10a15ae69a6ea39ec33e66b67", 5 }, // Harapeko Bakka (Japan)
    { "875ebd0b9ecc6ffb7a071d619586fb37", 5 }, // Hat Trick Hero 2 (Japan)
    { "3595c2e9736c100e263b699ada348b68", 5 }, // Head-On Soccer (USA)
    { "4c001cfc562003f8b9ec93326b10a2fe", 5 }, // Hebereke no Oishii Puzzle wa Irimasenka (Japan)
    { "68b340464b26ad36f5db110918c1e06d", 5 }, // Holy Striker (Japan)
    { "6ef82f3f011176c6969a9aed5845b8f7", 3 }, // Human Grand Prix III - F1 Triple Battle (Japan) (En)
    { "6e5f7a29c72b33d684b57ca369ff8cd1", 3 }, // Human Grand Prix IV - F1 Dream Battle (Japan) (En)
    { "5d3e67f185018083a9d49ff46273d793", 4 }, // Hungry Dinosaurs (Europe)
    { "51da200d9c04bb26c3c3e55796d84f0c", 4 }, // International Superstar Soccer Deluxe (Europe)
    { "345ddedcd63412b9373dabb67c11fc05", 4 }, // International Superstar Soccer Deluxe (USA)
    { "cd34ab3048ef09529ad5120ad30095ba", 4 }, // J.League Excite Stage '94 (Japan) (Rev 1)
    { "a9a8496cc8da79cd29ac63e949cf8f59", 4 }, // J.League Excite Stage '94 (Japan)
    { "6d092fb5d91bdb0ed6dc1e7683073925", 4 }, // J.League Excite Stage '95 (Japan) (Demo)
    { "583a60bf58d18f3fa49fb3276367fed9", 4 }, // J.League Excite Stage '95 (Japan)
    { "67671c905ab72b72359d395fe207e8b8", 4 }, // J.League Excite Stage '96 (Japan) (Rev 1)
    { "cfd8d8340bc2b384b5081272ea081e2e", 4 }, // J.League Excite Stage '96 (Japan)
    { "869bb5b70154ace0f8c3a3c763ce5b18", 4 }, // J.League Super Soccer '95 - Jikkyou Stadium (Japan)
    { "d44a415b0fa893b73648452d97dadad2", 5 }, // J.R.R. Tolkien's The Lord of the Rings - Volume 1 (USA)
    { "3ff7bd6fbbf6ca7c20381d12df9e5050", 5 }, // J.R.R. Tolkien's The Lord of the Rings - Volume One (Europe)
    { "4e6a28fc481fd0d5f3b93c2179e8d7e9", 5 }, // J.R.R. Tolkien's The Lord of the Rings - Volume One (Germany)
    { "6179d87851acd0e0fa24e5806db04f22", 5 }, // JWP Joshi Pro Wres - Pure Wrestle Queens (Japan)
    { "5f904b8c2c346c3aefbbe7f9781998a9", 3 }, // Jeopardy! - Deluxe Edition (USA)
    { "80eed41a2ea019ad32cffec4642c217a", 3 }, // Jeopardy! - Sports Edition (USA)
    { "3f54273940292e55c4b07317c4694c68", 5 }, // Jigsaw Party (Japan) (Beta) (1994-03-25)
    { "52e1cb037d122b5651fc514e1c233fdb", 5 }, // Jigsaw Party (Japan)
    { "1eab10a5ce91e2e27e407d949c28b032", 5 }, // Jikkyou Power Pro Wrestling '96 - Max Voltage (Japan)
    { "b4a9fdbe7cffa3e10e4ffa98df278361", 5 }, // Jikkyou World Soccer 2 - Fighting Eleven (Japan) (Beta)
    { "0938e286d17bad969fe6da0ab7a6c516", 5 }, // Jikkyou World Soccer 2 - Fighting Eleven (Japan) (Rev 1) (NP)
    { "686098f1c6873ea20d42e7c4b6ad569f", 5 }, // Jikkyou World Soccer 2 - Fighting Eleven (Japan)
    { "c3fa909cd175b5e179d74f7b1bf0f9ad", 5 }, // Jimmy Connors Pro Tennis Tour (Europe)
    { "7424445c51692ead97568e0a53b3d4a0", 5 }, // Jimmy Connors Pro Tennis Tour (France)
    { "a31c650101bd06993480309356dc325f", 5 }, // Jimmy Connors Pro Tennis Tour (Germany) (Beta)
    { "6ca06d22206dcad105a8426c943287b1", 5 }, // Jimmy Connors Pro Tennis Tour (Germany)
    { "f9be2cd00aa7dfaa64a963d099309e18", 5 }, // Jimmy Connors Pro Tennis Tour (Japan)
    { "106290995e3295b9d13c888e806a491a", 5 }, // Jimmy Connors Pro Tennis Tour (USA)
    { "36a901ef2e35b960bd475de115f87e98", 5 }, // Kingyo Chuuihou! - Tobidase! Game Gakuen (Japan)
    { "569936c3595514a594fe4f13d8bef24a", 4 }, // Kunio-kun no Dodge Ball Da yo Zenin Shuugou! (Japan)
    { "9fc9439aec3b423a65d4d971b3c5db4d", 5 }, // Las Vegas Dream in Golden Paradise (Japan)
    { "9cc7336325379139afc58d12a776696a", 5 }, // Looney Tunes B-Ball (USA)
    { "8b50319e3eea44705e4f1044c9856fdb", 5 }, // Looney Tunes Basketball (Europe)
    { "c2fc84a296e192ff1c7119d0cd1a165a", 5 }, // Madden NFL '94 (Europe)
    { "de29c57948c9e53b1b4e1ca9aba5b3eb", 5 }, // Madden NFL '94 (USA)
    { "6a966d433ed26b0cdf2e55b2d34be748", 5 }, // Madden NFL 95 (Europe)
    { "592f4c8dc4aaf84857154c63e9a533ab", 5 }, // Madden NFL 95 (USA)
    { "f8d8d5d48bb35286ade572fe1e57417c", 5 }, // Madden NFL 96 (USA) (Sample)
    { "58caadda4254884a65ae3db95394aa9a", 5 }, // Madden NFL 96 (USA)
    { "84279a0957e800bbaa0c90e6a0b0ba88", 5 }, // Madden NFL 97 (USA)
    { "3a361826ad0eb7c4ab3e295aecdd3f64", 5 }, // Madden NFL 98 (USA)
    { "ef9460fb2fb4f10c0bebdfff4ddde532", 5 }, // Magic Johnson no Super Slam Dunk (Japan) (En)
    { "02061638a5e74746fd24e5aa9c1f1f60", 4 }, // Micro Machines (Europe)
    { "b447b20f378bff1342338c5c1acc0e53", 4 }, // Micro Machines (USA)
    { "a49a0c96a6b466d045ddc40a615cb983", 4 }, // Micro Machines 2 - Turbo Tournament (Europe) (Beta)
    { "fff6243187f907e58dc16f6dbbad5d3a", 4 }, // Micro Machines 2 - Turbo Tournament (Europe)
    { "6db27710a4a5167e5fff97f50f8fe252", 5 }, // Mizuki Shigeru no Youkai Hyakkiyakou (Japan)
    { "177c79bcd095d112889845188e8d082d", 5 }, // Multi Play Volleyball (Japan)
    { "6af767734a8e5526d08cf76b75216594", 5 }, // Muscle Bomber - The Body Explosion (Japan)
    { "4bf5287384ff382eb2e83269270e2114", 4 }, // NBA Give 'n Go (Europe)
    { "5b6433c5c709d9f054f06f4e90485d06", 4 }, // NBA Give 'n Go (USA)
    { "abc44359e784588692f6ed0bc5ef1f61", 4 }, // NBA Hang Time (Europe)
    { "e9a46430216ca4cbcc3d58dadb4e3ff1", 4 }, // NBA Hang Time (USA)
    { "81dcfbbaa66f8bed4c0ab0e2b6d3e053", 4 }, // NBA Jam (Europe) (Rev 1)
    { "5a7bb097ed50ed69f852d2b4a148d450", 4 }, // NBA Jam (Europe)
    { "cbc2a1c18973474945c830d54a3cc420", 4 }, // NBA Jam (Japan) (En) (Beta)
    { "d9d67a64841f05fcd4f567415f1c7e25", 4 }, // NBA Jam (Japan) (En)
    { "16a0200371580df2204884b35ce1f30d", 4 }, // NBA Jam (USA) (Beta 1)
    { "5249645bac2564fe08d2f6ea4df680c0", 4 }, // NBA Jam (USA) (Beta 2)
    { "6ee56e3fdfa9543ef7755a08897767ec", 4 }, // NBA Jam (USA) (Rev 1)
    { "808b6d01ca9c7e1938541f55eb71f73c", 4 }, // NBA Jam (USA)
    { "fd9cccc7d07699e79d6f634bd5c3e0d5", 4 }, // NBA Jam - Tournament Edition (Europe)
    { "c9c9ea0e0855c282c27fecd491cd4365", 4 }, // NBA Jam - Tournament Edition (Japan) (En)
    { "7026b4fb575b014d89e159f7623848ee", 4 }, // NBA Jam - Tournament Edition (USA) (Beta)
    { "503965fc09952186f79dd89d730d8d7f", 4 }, // NBA Jam - Tournament Edition (USA)
    { "a0878d1e96535ccf202a36159adb54db", 5 }, // NBA Jikkyou Basket - Winning Dunk (Japan)
    { "32fb4e765c4bfe354403154c92b70db7", 5 }, // NBA Live 95 (Europe)
    { "50427975c0f5833f10a7ff02a5de3c61", 5 }, // NBA Live 95 (Japan)
    { "86021f9150c5a03e00d7f9e688a5a981", 5 }, // NBA Live 95 (USA)
    { "6e0dc79e19307e6961390553a79ab4cf", 5 }, // NBA Live 96 (Europe)
    { "9299bd183eb84d5ae7a3661438002e31", 5 }, // NBA Live 96 (USA)
    { "59af406928546b8e9579dc74a1918f67", 5 }, // NBA Live 97 (Europe)
    { "362c3bfba31038172dba396cce3c1eec", 5 }, // NBA Live 97 (USA)
    { "fbbc69e91c2aa544b37c97395c67486f", 5 }, // NBA Live 98 (USA)
    { "76a13ceb63c98ba797f7405c8bfe39e8", 5 }, // NCAA Final Four Basketball (USA)
    { "2ae8390a41f010a5c97a16c28839a76c", 4 }, // NCAA Football (USA)
    { "b22cdbfbbd47bf49e0d69c7edb23323a", 5 }, // NFL Quarterback Club '95 (Japan) (En)
    { "1a723ba2e11992ede14e9d9eb875b9bf", 5 }, // NFL Quarterback Club (Europe)
    { "99c0888d7d55d682bfee209ea5e959ef", 5 }, // NFL Quarterback Club (USA) (Beta)
    { "90cad22930418d69bc55bb8be81b9654", 5 }, // NFL Quarterback Club (USA)
    { "d0ac8ecf45a99c310370fac78933b9df", 5 }, // NFL Quarterback Club 96 (Europe) (Beta)
    { "fcd126a28f94a44314ca3b5e0a826a14", 5 }, // NFL Quarterback Club 96 (Europe)
    { "d67a3e33268937c39c764bb8b2eaf220", 5 }, // NFL Quarterback Club 96 (Japan) (En)
    { "d036d484f2f2a50a45b34f45fc6fd360", 5 }, // NFL Quarterback Club 96 (USA)
    { "4d8f6f821e779839d9680fddf11003b0", 5 }, // NHL Hockey '94 (Europe)
    { "21ea8a54b6439e80d99c51c4917fd651", 5 }, // NHL Pro Hockey '94 (Japan)
    { "52824e72c80a8309797e5a8ea4e9536f", 5 }, // NHL '94 (USA) (Beta)
    { "a93ffed8ea7198a8cd23d698933e2cd9", 5 }, // NHL '94 (USA)
    { "89c8251afbced80297426d2b4a4ed20a", 5 }, // NHL '97 (USA) (Beta)
    { "a878a1c7c8a65b1e231987f1cdf8fedc", 5 }, // NHL 95 (Europe)
    { "deea8f94027f374d432dea56e0c72917", 5 }, // NHL 95 (USA)
    { "cff67a517f479b64189c0a248d3c3d8d", 5 }, // NHL 96 (Europe)
    { "5558aa840d9f842b7a6c97b26c80c244", 5 }, // NHL 96 (USA)
    { "cb9b48905598a3d4eabd9a568d7186db", 5 }, // NHL 97 (Europe) (Rev 1)
    { "d1e63437af76c2a2ed5567b527c3af05", 5 }, // NHL 97 (Europe)
    { "8d684564175be2683efbbb15e9bf0f4c", 5 }, // NHL 97 (USA) (Rev 1)
    { "4e93b6a3ea6bc0fd338a66565b5e4716", 5 }, // NHL 97 (USA)
    { "2b4a2f7722ca9c2c305f72d4a9d4e83e", 5 }, // NHL 98 (USA)
    { "2067f76b1ac029c6a6c59b0beafb2b80", 4 }, // Natsume Championship Wrestling (USA)
    { "393d7aeffa667255cf4f592ac92c222a", 5 }, // Olympic Summer Games (Europe) (Beta)
    { "8ab1fe6f37d3c826b01a09be6c36933b", 5 }, // Olympic Summer Games (Europe)
    { "f082072b16e7ed337503ec4df334171f", 5 }, // Olympic Summer Games (USA)
    { "9917261ef54d9fb42048a9eef57d1ee3", 4 }, // Peace Keepers, The (USA)
    { "f0da10d1a7311ffdf1270dfb38ca3dbb", 5 }, // Pieces (USA)
    { "6ae194d9f8022c9a2962a423ffbc40cc", 5 }, // Planet's Champ TG 3000, The (Japan)
    { "e8ac9546c334f910b36aa1c202edc86a", 5 }, // Puzzle'n Desu! (Japan).sfc
    { "bc4b5b11b75e0d701c8275a6d93574e2", 5 }, // Rap Jam - Volume One (USA) (En,Fr,Es)
    { "325a9d637c9f6e7211b2d413ee1fef3d", 5 }, // Rushing Beat Shura (Japan)
    { "59361b30b09dc94163a654616e328185", 4 }, // Saturday Night Slam Masters (Europe)
    { "c8dd52b075e1681f590d2f97ab5b4d7e", 4 }, // Saturday Night Slam Masters (USA)
    { "5e1602019d4e337b9c6a714a6224ba1d", 3 }, // Secret of Mana (France) (Rev 1)
    { "35afb723a7a1166d894549519d78622c", 3 }, // Secret of Mana (France)
    { "b57303407986c0d28f2d78f931efc59c", 3 }, // Secret of Mana (Germany)
    { "1d2c4c03366af008eacb32de98a7f5c1", 3 }, // Secret of Mana (USA) (Virtual Console)
    { "10a894199a9adc50ff88815fd9853e19", 3 }, // Secret of Mana (USA)
    { "0194f74c93b0edf3e4a7672a448572ad", 3 }, // Secret of Mana (United Kingdom)
    { "d273dd449b204a6eb90f611e5a72f80c", 3 }, // Secret of Mana (United Kingdom, Australia) (Rev 1)
    { "ff5790e984d6ab8109963c7b2f8a2a97", 3 }, // Secret of Mana (World) (De) (Collection of Mana)
    { "de712de1abcb0eb554911c374ef8919b", 3 }, // Secret of Mana (World) (Fr) (Rev 1) (Collection of Mana)
    { "3481b8e87a19ef4d9341590eaf0d5165", 5 }, // Shin Nihon Pro Wrestling - Chou Senshi in Tokyo Dome - Fantastic Story (Japan)
    { "16177c7d92339627c8cb202425e8d269", 5 }, // Shin Nihon Pro Wrestling Kounin - '94 Battlefield in Tokyo Dome (Japan)
    { "b72b4bc93893591c5ef38306119069b0", 5 }, // Shin Nihon Pro Wrestling Kounin - '95 Tokyo Dome Battle 7 (Japan)
    { "b9501bb47074288b8e83615ec83e6f2b", 4 }, // Smash Tennis (Europe) (Beta)
    { "91e75245c75c1f498e345cd368309801", 4 }, // Smash Tennis (Europe)
    { "0379b3f0d6d4358a9490c791bf6bb678", 4 }, // Soccer Shootout (Europe)
    { "999f80a3c6058a3b988459938896d01e", 4 }, // Sporting News Baseball, The (USA) (Beta)
    { "95689bdd54ddde67fea1b05a96bcb6f4", 4 }, // Sporting News Baseball, The (USA)
    { "88e1ba3bee88da20fe3c427e4ac98bfe", 5 }, // Sterling Sharpe - End 2 End (USA)
    { "8950b0a924b55353849cc7f101e9a684", 4 }, // Street Hockey '95 (USA) (Beta)
    { "49faf656058152cec1c04e11810fc7e5", 4 }, // Street Racer (Europe) (Rev 1)
    { "395d3f386a12ce28d08ac5c96d13d150", 4 }, // Street Racer (Europe)
    { "99d4998cb5d6a35796a6799b636dcd8e", 4 }, // Street Racer (Japan) (En)
    { "94f164f81c4bbf336e6aaf4f6a1d8c84", 4 }, // Street Racer (USA) (Beta 1)
    { "9b6142ae845235d29fb572a061ea419d", 4 }, // Street Racer (USA) (Beta 2)
    { "75f7951686376738196110052dd86835", 4 }, // Street Racer (USA)
    { "9c0029b686d23eee27d9a66626395ed4", 5 }, // Sugoi Hebereke (Japan)
    { "76a89008043d1e160d9487a26f149b7e", 5 }, // Sugoro Quest++ - Dicenics (Japan)
    { "ddee4ddff2f3b6e31b8f73d0cb597ef1", 4 }, // Super Bomberman (Europe)
    { "cbef5f02304a2b821a0e1642a6307564", 4 }, // Super Bomberman (Japan)
    { "d67a1a2b0fac0564d950f8cd45fee3c2", 4 }, // Super Bomberman (USA) (Beta) (1993-05-11)
    { "d83699a009a62480a7e7e9f1bb5bff6e", 4 }, // Super Bomberman (USA)
    { "cc9c8195b55b94e075c771ca1628cbc8", 4 }, // Super Bomberman - Panic Bomber W (Japan)
    { "084a8595dd56c37358f80edf6427938c", 4 }, // Super Bomberman 2 (Europe)
    { "7dd89c3f953b4e507274e428b1250ecb", 4 }, // Super Bomberman 2 (Japan) (Caravan You Taikenban)
    { "3e0481ede2ce82e5faf297cc501e8b7d", 4 }, // Super Bomberman 2 (Japan) (En)
    { "3126555b2d68b07f5e828b374c358d68", 4 }, // Super Bomberman 2 (USA) (Beta)
    { "0990cda295bd51587c6e3f173bdadba8", 4 }, // Super Bomberman 2 (USA)
    { "06f36d421da383f788612ce99440cddf", 5 }, // Super Bomberman 3 (Europe) (Beta)
    { "681343f71b5fce4f7e960f3091e56026", 5 }, // Super Bomberman 3 (Europe)
    { "cfeb2bfd16859a82fafff30be2884736", 5 }, // Super Bomberman 3 (Japan)
    { "df33e261104efee409de8f294d80ad6e", 5 }, // Super Bomberman 4 (Japan)
    { "772ca292857d5bcf1f8776009fa1d280", 5 }, // Super Bomberman 5 (Japan) (Caravan Event Ban)
    { "3103de24bd9b46aad3e211574e5a0621", 5 }, // Super Bomberman 5 (Japan)
    { "6980f890a84995d1a9ff8e135995e077", 4 }, // Super Family Tennis (Japan)
    { "84fd0b42b13c90de42993edc69871c34", 5 }, // Super Final Match Tennis (Japan)
    { "04eaa42826543706cf6b9db9db527766", 5 }, // Super Fire Pro Wrestling 2 (Japan) (Beta)
    { "4c517f4a68fdbc876b9a70eaed1fcba7", 5 }, // Super Fire Pro Wrestling 2 (Japan)
    { "b8436814b79fa539376a627f531ae244", 5 }, // Super Fire Pro Wrestling III - Easy Type (Japan)
    { "800fbeb7fd019665fd2abed34472eed3", 5 }, // Super Fire Pro Wrestling III - Final Bout (Japan) (Rev 1)
    { "37fbc6773cc3493a8095fbcae82691cc", 5 }, // Super Fire Pro Wrestling III - Final Bout (Japan)
    { "f5f1e0691d62e308b86bc7bbf500bed9", 5 }, // Super Fire Pro Wrestling Special (Japan) (Rev 1)
    { "df71b6ca861ebf02ac73a6e335718f79", 5 }, // Super Fire Pro Wrestling Special (Japan)
    { "427937b1bc30dd134707c5b1ab8cec49", 5 }, // Super Fire Pro Wrestling X (Japan)
    { "88b3c5b6e79bf4859940090c4ca6eabe", 5 }, // Super Fire Pro Wrestling X Premium (Japan)
    { "868c5612612444e545ee610245990fc0", 5 }, // Super Fire Pro Wrestling - Queen's Special (Japan)
    { "06af11ffb21b5b72f112585f8d3ed098", 5 }, // Super Formation Soccer 94 - World Cup Edition (Japan)
    { "985535c613bcd504e18ab235bdc02c8c", 5 }, // Super Formation Soccer 94 - World Cup Final Data (Japan)
    { "292f727b0eb90783c0367cc5721939fc", 5 }, // Super Formation Soccer 95 - della Serie A (Japan) (UCC Xaqua Version)
    { "8da4706f41ed35fcab35072649f2ae19", 5 }, // Super Formation Soccer 95 - della Serie A (Japan)
    { "c645d7275de38d747885a7295f0e8fb8", 5 }, // Super Formation Soccer 96 - World Club Edition (Japan)
    { "f53baa0c5ecd0b3942c22260a569562e", 5 }, // Super Formation Soccer II (Japan)
    { "6aeedaad578afd7bff989388e486b48a", 5 }, // Super Hockey '94 (Japan) (En)
    { "0652e8e1c7712ced0d1e04825fdbfa5a", 5 }, // Super Hockey (Europe)
    { "9a1d538f553bcbbeadf248ef1fde8646", 5 }, // Super Hockey (France) (En,Fr)
    { "ba0aab6f4e9cff302d4313041fcd6ee9", 5 }, // Super Ice Hockey (Europe)
    { "a734dc909fabd211ccd2e140e6d361dd", 5 }, // Super Kyousouba - Kaze no Sylphid (Japan)
    { "679c59911e0449ab82a409ad51deaae4", 5 }, // Super Power League (Japan)
    { "0dc4efac96b9e965009e9c613913c6f8", 4 }, // Super Puyo Puyo Tsuu Remix (Japan)
    { "96c38a14f55c58b51435e9bdb0235998", 5 }, // Super Tekkyuu Fight! (Japan)
    { "f912c443a57a5ae1687eeaf6f2da49fc", 4 }, // Super Tetris 3 (Japan) (En)
    { "cb983ec82a0825496cff3f6db14e40cc", 5 }, // Takeda Nobuhiro no Super League Soccer (Japan)
    { "17a7ed97f6dc9c3e4ffab7d33e07a3f0", 5 }, // Tiny Toon Adventures - Dotabata Daiundoukai (Japan)
    { "3d946c89e1b62223a505f367babac5da", 4 }, // Tiny Toon Adventures - Wacky Sports Challenge (USA)
    { "047684cd1c2d6cb158bef2e3176a048b", 4 }, // Tiny Toon Adventures - Wild & Wacky Sports (Europe) (Beta)
    { "513443cbeb457a436350226d8e40ff08", 4 }, // Tiny Toon Adventures - Wild & Wacky Sports (Europe) (Rev 1)
    { "b4c4d7760020444ae63dbe794e154aa1", 4 }, // Tiny Toon Adventures - Wild & Wacky Sports (Europe)
    { "462e15c018c653335ba634d3c1cd06c9", 4 }, // Top Gear 3000 (Europe)
    { "23eaa07e3f3315fa43f4b4d94ec97a7b", 4 }, // Top Gear 3000 (USA)
    { "3dfd2c576e5ad135a58d12e8197f1254", 4 }, // Turbo Toons (Europe)
    { "22399656483ec9a37281d93ec538ff70", 4 }, // Turbo Toons (USA) (Proto)
    { "10561d1820eb4b294087d130d0783366", 5 }, // Vegas Stakes (Europe)
    { "6200c8cc3f28cf80a5181586ef92a7e1", 5 }, // Vegas Stakes (USA)
    { "a6f7d56d7855fd10a843fe72fe210f7a", 5 }, // Virtual Soccer (Europe)
    { "93ff7a8eced813e16da0c8c8b633d3f8", 5 }, // Virtual Soccer (USA) (Proto)
    { "6fa817fa8bb28d12151f4cad181e904d", 5 }, // Vs. Collection (Japan)
    { "9697253eac2b9137d803271d47c402fb", 4 }, // WCW Super Brawl Wrestling (USA)
    { "c9621e6293ab2de3fe03439ba09969a2", 4 }, // WWF Raw (Europe)
    { "6852754ebd4115e1db335b6492586c8b", 4 }, // WWF Raw (USA)
    { "026314480d07c1670197d34fcca725b1", 5 }, // Wedding Peach (Japan)
    { "9476c8969035157de84db6fd5cd8608d", 5 }, // World Cup Striker (Europe) (En,Fr,De) (Beta)
    { "ae748774dcb36a05609310318e313dcc", 5 }, // World Cup Striker (Europe) (En,Fr,De)
    { "4f18a5f363066feaa1f7d83df726fc1f", 5 }, // World Cup Striker (Japan)
    { "aac5b6d034c6ece60aa0be540aa5af53", 5 }, // Yuujin no Furi Furi Girls (Japan)
    { "43fad4683fe691c4fa3d50f73a70499e", 5 }, // Zero 4 Champ RR (Japan) (Rev 1)
    { "120f5e57adfc69885cdedad4433d3efe", 5 }, // Zero 4 Champ RR (Japan)
    { "43498a8764c3ff15d28e4120639a06f9", 5 }, // Zero 4 Champ RR-Z (Japan)

    // Super Game Boy Enhanced Game Boy games
    { "9fb9c42cf52dcfdcfbad5e61ae1b5777", 4 }, // Bomberman Collection (Japan) (SGB Enhanced)
    { "2cad6ee6df3402aeb8f8ab7921517779", 4 }, // Bomberman GB (Japan) (SGB Enhanced)
    { "7e4c9c3620bea7b633394beb67e9680b", 4 }, // Bomberman GB (USA, Europe) (SGB Enhanced)
    { "4ab78239e79ba059d0d7aa7a629a9474", 4 }, // Bomberman GB 2 (Japan) (SGB Enhanced)
    { "3addab2611566ab072fc996f8a81b224", 4 }, // Bomberman GB 3 (Japan) (SGB Enhanced)
    { "8ac5c061641b2a8b4c44b46ef693aeef", 4 }, // F-1 Race (World) (Rev 1)
    { "3ad6a2e9c2872cd8f92d86e18332262c", 4 }, // F-1 Race (World)
    { "05ba7f165dab1ffd49b63b4f5c704c02", 5 }, // Faceball 2000 (USA)
    { "b67196db786a67cdfe50d6d2e902aa11", 4 }, // Jinsei Game (Japan) (SGB Enhanced)
    { "9ba2999ef3ecf9e27ac6c88e995c9d7a", 4 }, // Super R.C. Pro-Am (USA, Europe)
    { "14fe7234ee4bcb14adf20c743f084a35", 4 }, // Wario Blast Featuring Bomberman! (USA, Europe) (SGB Enhanced)
};

struct ssentry_t {
    std::string md5; int x; int y;
};

static std::vector<ssentry_t> db_superscope_games {
    { "391c2d0e4e81ca2139bc86080a2c4d2d", 0, 0 },    // Battle Clash (Europe)
    { "d9b2a11d20a10fe4f82be4a92481d3d3", 0, 0 },    // Battle Clash (USA)
    { "079eade13305bcc130e09597faeff4f0", 1, 19 },   // Bazooka Blitzkrieg (USA)
    { "dad772810b232ccf10053cb24e13d850", 1, 19 },   // Destructive (Japan)
    { "2335cdc8cd98be81d8eaef1ce73b951f", 0, 0 },    // Hunt for Red October, The (Europe)
    { "083cc827e556260298859f21cbf6f352", 0, 0 },    // Hunt for Red October, The (Japan)
    { "47d7b7ba3419b894002b0402685a0960", 0, 0 },    // Hunt for Red October, The (USA)
    { "44a7735d6dceed9fb4eab61113daa410", 0, 0 },    // Metal Combat - Falcon's Revenge (Europe)
    { "d4bc4f3cb46cc09d8db58f0ce0142646", 0, 0 },    // Metal Combat - Falcon's Revenge (USA)
    { "6cd53158ac83005a5f7e09d1e78b87c9", 0, 0 },    // Nintendo Scope 6 (Europe)
    { "be4f6b60a2ce518ba46c9f33e4fa0ff5", 0, 0 },    // Operation Thunderbolt (USA)
    { "0e59675372ca0ca16c7a7158b5597f2c", 0, 0 },    // Space Bazooka (Japan)
    { "df69587755e80a5a2b0ec747aef19d74", 0, 0 },    // Super Scope 6 (Japan)
    { "a17d52680cc29e46ce41da360e8febe3", 0, 0 },    // Super Scope 6 (USA)
    { "3af126f4b6e5e0af52ecc734fa5d12cf", 36, -14 }, // T2 - The Arcade Game (Europe)
    { "060c2f08f03bfab47ec283b9562f4a2d", 36, -14 }, // T2 - The Arcade Game (Japan)
    { "49a4cf748b491f6e7bdbfc86f2cf4d16", 36, -14 }, // T2 - The Arcade Game (USA)
    { "54981549724b1da80e7f52407f9c83cf", 0, 0 },    // Tin Star (USA)
    { "966498b44281629893f0e5b5a6558cf2", 40, -7 },  // X Zone (Europe)
    { "a316475dfca41b864b7be021afbcad00", 40, -7 },  // X Zone (Japan, USA)
    { "044d6d9860e635d55bbb6192b5cbb121", 0, 0 },    // Yoshi's Safari (Europe)
    { "70db2519602d9d6e6dc6fa0069ed54da", 0, 0 },    // Yoshi's Safari (USA)
    { "ad04758596f502576972ea3b163e8f13", 0, 0 },    // Yoshi no Road Hunting (Japan)
};
