/**
 *
 * Character classes
 *
 * By John Snelson
 *
 */

#include "char_classes.h"

typedef struct CharClass_s {

  Char32 c;
  uint8_t flags;

} CharClass;

/*
 * [2]     Char     ::=    [#x1-#xD7FF] | [#xE000-#xFFFD] | [#x10000-#x10FFFF]
 * [2a]    RestrictedChar     ::=    [#x1-#x8] | [#xB-#xC] | [#xE-#x1F] |
 *                                   [#x7F-#x84] | [#x86-#x9F]
 *
 * [3]     S    ::=    (#x20 | #x9 | #xD | #xA)+
 *
 * [4]     NameStartChar    ::=    ":" | [A-Z] | "_" | [a-z] | [#xC0-#xD6] |
 *                                 [#xD8-#xF6] | [#xF8-#x2FF] | [#x370-#x37D] |
 *                                 [#x37F-#x1FFF] | [#x200C-#x200D] |
 *                                 [#x2070-#x218F] | [#x2C00-#x2FEF] |
 *                                 [#x3001-#xD7FF] | [#xF900-#xFDCF] |
 *                                 [#xFDF0-#xFFFD] | [#x10000-#xEFFFF]
 * [4a]    NameChar     ::=    NameStartChar | "-" | "." | [0-9] | #xB7 |
 *                             [#x0300-#x036F] | [#x203F-#x2040]
 *
 * [5]     NCNameChar     ::=    NameChar - ':'
 * [5a]    NCNameStartChar    ::=    NameStartChar - ':'
 *
 * '-' = 0x2D, '.' = 0x2E, '0' = 0x30, '9' = 0x39, ':' = 0x3A, 'A' = 0x41, 'Z' = 0x5A, '_' = 0x5F, 'a' = 0x61, 'z' = 0x7A
 */

#define CHAR_CLASSES_SIZE 608
static const CharClass char_classes[CHAR_CLASSES_SIZE] = {
  // Don't need the region between 0x00 and 0xFF, since we look
  // them up directly in the table below
/*   { 0x000000, 0 }, */
/*   { 0x000001, CHAR11 }, */
/*   { 0x000009, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 | WHITESPACE_CHAR }, */
/*   { 0x00000B, CHAR11 }, */
/*   { 0x00000D, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 | WHITESPACE_CHAR }, */
/*   { 0x00000E, CHAR11 }, */
/*   { 0x000020, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 | WHITESPACE_CHAR }, */
/*   { 0x000021, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x00002D, NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x00002F, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x000030, NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x00003A, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x000041, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x00005B, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x00005F, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x000060, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x000061, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x00007B, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x00007F, NON_RESTRICTED_CHAR10 | CHAR11 }, */
/*   { 0x000085, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x000086, NON_RESTRICTED_CHAR10 | CHAR11 }, */
/*   { 0x0000A0, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x0000B7, NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x0000B8, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x0000C0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x0000D7, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x0000D8, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */
/*   { 0x0000F7, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 }, */

  { 0x0000F8, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000132, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000134, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00013F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000141, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000149, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00014A, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00017F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000180, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0001C4, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0001CD, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0001F1, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0001F4, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0001F6, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0001FA, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000218, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000250, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0002A9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0002BB, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0002C2, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0002D0, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0002D2, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000300, NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000346, NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000360, NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000362, NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000370, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00037E, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00037F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000386, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000387, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000388, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00038B, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00038C, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00038D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00038E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003A2, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003A3, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003CF, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003D0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003D7, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003DA, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003DB, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003DC, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003DD, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003DE, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003DF, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003E0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003E1, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003E2, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0003F4, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000401, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00040D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00040E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000450, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000451, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00045D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00045E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000482, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000483, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000487, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000490, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004C5, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004C7, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004C9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004CB, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004CD, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004D0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004EC, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004EE, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004F6, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004F8, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0004FA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000531, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000557, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000559, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00055A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000561, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000587, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000591, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005A2, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005A3, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005BA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005BB, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005BE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005BF, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005C0, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005C1, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005C3, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005C4, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005C5, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005D0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005EB, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005F0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0005F3, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000621, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00063B, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000640, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000641, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00064B, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000653, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000660, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00066A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000670, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000671, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006B8, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006BA, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006BF, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006C0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006CF, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006D0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006D4, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006D5, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006D6, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006E5, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006E7, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006E9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006EA, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006EE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006F0, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0006FA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000901, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000904, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000905, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00093A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00093C, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00093D, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00093E, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00094E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000951, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000955, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000958, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000962, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000964, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000966, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000970, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000981, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000984, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000985, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00098D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00098F, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000991, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000993, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009A9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009AA, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009B1, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009B2, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009B3, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009B6, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009BA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009BC, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009BD, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009BE, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009C5, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009C7, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009C9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009CB, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009CE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009D7, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009D8, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009DC, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009DE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009DF, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009E2, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009E4, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009E6, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009F0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0009F2, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A02, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A03, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A05, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A0B, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A0F, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A11, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A13, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A29, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A2A, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A31, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A32, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A34, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A35, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A37, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A38, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A3A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A3C, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A3D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A3E, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A43, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A47, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A49, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A4B, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A4E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A59, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A5D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A5E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A5F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A66, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A72, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A75, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A81, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A84, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A85, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A8C, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A8D, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A8E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A8F, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A92, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000A93, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AA9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AAA, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AB1, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AB2, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AB4, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AB5, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000ABA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000ABC, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000ABD, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000ABE, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AC6, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AC7, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000ACA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000ACB, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000ACE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AE0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AE1, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AE6, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000AF0, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B01, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B04, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B05, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B0D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B0F, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B11, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B13, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B29, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B2A, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B31, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B32, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B34, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B36, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B3A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B3C, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B3D, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B3E, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B44, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B47, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B49, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B4B, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B4E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B56, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B58, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B5C, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B5E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B5F, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B62, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B66, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B70, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B82, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B84, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B85, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B8B, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B8E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B91, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B92, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B96, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B99, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B9B, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B9C, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B9D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000B9E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BA0, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BA3, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BA5, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BA8, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BAB, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BAE, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BB6, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BB7, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BBA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BBE, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BC3, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BC6, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BC9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BCA, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BCE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BD7, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BD8, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BE7, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000BF0, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C01, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C04, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C05, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C0D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C0E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C11, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C12, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C29, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C2A, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C34, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C35, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C3A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C3E, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C45, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C46, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C49, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C4A, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C4E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C55, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C57, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C60, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C62, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C66, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C70, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C82, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C84, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C85, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C8D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C8E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C91, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000C92, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CA9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CAA, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CB4, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CB5, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CBA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CBE, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CC5, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CC6, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CC9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CCA, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CCE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CD5, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CD7, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CDE, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CDF, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CE0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CE2, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CE6, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000CF0, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D02, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D04, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D05, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D0D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D0E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D11, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D12, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D29, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D2A, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D3A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D3E, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D44, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D46, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D49, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D4A, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D4E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D57, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D58, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D60, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D62, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D66, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000D70, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E01, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E2F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E30, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E31, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E32, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E34, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E3B, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E40, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E46, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E4F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E50, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E5A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E81, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E83, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E84, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E85, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E87, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E89, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E8A, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E8B, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E8D, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E8E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E94, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E98, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000E99, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EA0, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EA1, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EA4, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EA5, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EA6, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EA7, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EA8, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EAA, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EAC, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EAD, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EAF, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EB0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EB1, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EB2, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EB4, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EBA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EBB, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EBD, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EBE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EC0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EC5, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EC6, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EC7, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EC8, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000ECE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000ED0, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000EDA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F18, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F1A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F20, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F2A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F35, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F36, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F37, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F38, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F39, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F3A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F3E, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F40, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F48, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F49, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F6A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F71, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F85, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F86, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F8C, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F90, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F96, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F97, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F98, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000F99, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000FAE, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000FB1, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000FB8, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000FB9, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x000FBA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0010A0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0010C6, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0010D0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0010F7, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001100, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001101, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001102, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001104, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001105, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001108, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001109, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00110A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00110B, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00110D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00110E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001113, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00113C, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00113D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00113E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00113F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001140, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001141, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00114C, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00114D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00114E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00114F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001150, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001151, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001154, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001156, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001159, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00115A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00115F, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001162, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001163, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001164, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001165, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001166, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001167, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001168, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001169, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00116A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00116D, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00116F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001172, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001174, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001175, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001176, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00119E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00119F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011A8, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011A9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011AB, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011AC, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011AE, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011B0, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011B7, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011B9, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011BA, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011BB, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011BC, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011C3, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011EB, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011EC, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011F0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011F1, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011F9, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0011FA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001E00, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001E9C, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001EA0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001EFA, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F00, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F16, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F18, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F1E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F20, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F46, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F48, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F4E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F50, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F58, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F59, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F5A, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F5B, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F5C, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F5D, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F5E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F5F, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F7E, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001F80, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FB5, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FB6, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FBD, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FBE, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FBF, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FC2, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FC5, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FC6, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FCD, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FD0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FD4, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FD6, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FDC, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FE0, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FED, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FF2, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FF5, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FF6, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x001FFD, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002000, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00200C, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00200E, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00203F, NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002041, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002070, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0020D0, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0020DD, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0020E1, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0020E2, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002126, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002127, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00212A, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00212C, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00212E, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00212F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002180, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002183, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002190, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002C00, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x002FF0, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003001, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003005, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003006, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003007, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003008, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003021, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00302A, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003030, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003031, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003036, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003041, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003095, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003099, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00309B, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00309D, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00309F, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0030A1, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0030FB, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0030FC, NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0030FF, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x003105, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00312D, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x004E00, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x009FA6, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00AC00, NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00D7A4, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00D800, 0 },
  { 0x00E000, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00F900, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00FDD0, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00FDF0, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x00FFFE, 0 },
  { 0x010000, NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x0F0000, NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 },
  { 0x110000, 0 }
};

const uint8_t FAXPP_char_flags_256[256] = {
  /* 0x00 */ 0,
  /* 0x01 */ CHAR11,
  /* 0x02 */ CHAR11,
  /* 0x03 */ CHAR11,
  /* 0x04 */ CHAR11,
  /* 0x05 */ CHAR11,
  /* 0x06 */ CHAR11,
  /* 0x07 */ CHAR11,
  /* 0x08 */ CHAR11,
  /* 0x09 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 | WHITESPACE_CHAR,
  /* 0x0A */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 | WHITESPACE_CHAR,
  /* 0x0B */ CHAR11,
  /* 0x0C */ CHAR11,
  /* 0x0D */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 | WHITESPACE_CHAR,
  /* 0x0E */ CHAR11,
  /* 0x0F */ CHAR11,
  /* 0x10 */ CHAR11,
  /* 0x11 */ CHAR11,
  /* 0x12 */ CHAR11,
  /* 0x13 */ CHAR11,
  /* 0x14 */ CHAR11,
  /* 0x15 */ CHAR11,
  /* 0x16 */ CHAR11,
  /* 0x17 */ CHAR11,
  /* 0x18 */ CHAR11,
  /* 0x19 */ CHAR11,
  /* 0x1A */ CHAR11,
  /* 0x1B */ CHAR11,
  /* 0x1C */ CHAR11,
  /* 0x1D */ CHAR11,
  /* 0x1E */ CHAR11,
  /* 0x1F */ CHAR11,
  /* 0x20 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11 | WHITESPACE_CHAR,
  /* 0x21 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x22 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x23 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x24 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x25 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x26 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x27 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x28 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x29 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x2A */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x2B */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x2C */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x2D */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x2E */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x2F */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x30 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x31 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x32 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x33 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x34 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x35 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x36 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x37 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x38 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x39 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x3A */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x3B */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x3C */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x3D */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x3E */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x3F */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x40 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x41 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x42 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x43 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x44 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x45 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x46 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x47 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x48 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x49 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x4A */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x4B */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x4C */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x4D */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x4E */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x4F */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x50 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x51 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x52 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x53 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x54 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x55 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x56 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x57 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x58 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x59 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x5A */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x5B */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x5C */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x5D */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x5E */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x5F */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x60 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x61 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x62 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x63 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x64 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x65 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x66 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x67 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x68 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x69 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x6A */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x6B */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x6C */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x6D */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x6E */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x6F */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x70 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x71 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x72 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x73 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x74 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x75 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x76 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x77 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x78 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x79 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x7A */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x7B */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x7C */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x7D */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x7E */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x7F */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x80 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x81 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x82 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x83 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x84 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x85 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0x86 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x87 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x88 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x89 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x8A */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x8B */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x8C */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x8D */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x8E */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x8F */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x90 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x91 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x92 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x93 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x94 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x95 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x96 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x97 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x98 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x99 */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x9A */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x9B */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x9C */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x9D */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x9E */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0x9F */ NON_RESTRICTED_CHAR10 | CHAR11,
  /* 0xA0 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xA1 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xA2 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xA3 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xA4 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xA5 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xA6 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xA7 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xA8 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xA9 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xAA */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xAB */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xAC */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xAD */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xAE */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xAF */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB0 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB1 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB2 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB3 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB4 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB5 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB6 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB7 */ NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB8 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xB9 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xBA */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xBB */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xBC */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xBD */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xBE */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xBF */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC0 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC1 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC2 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC3 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC4 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC5 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC6 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC7 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC8 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xC9 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xCA */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xCB */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xCC */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xCD */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xCE */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xCF */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD0 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD1 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD2 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD3 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD4 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD5 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD6 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD7 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD8 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xD9 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xDA */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xDB */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xDC */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xDD */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xDE */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xDF */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE0 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE1 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE2 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE3 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE4 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE5 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE6 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE7 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE8 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xE9 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xEA */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xEB */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xEC */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xED */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xEE */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xEF */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF0 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF1 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF2 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF3 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF4 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF5 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF6 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF7 */ NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF8 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xF9 */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xFA */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xFB */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xFC */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xFD */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xFE */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11,
  /* 0xFF */ NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | CHAR11
};

const char *FAXPP_char_flags_to_string(unsigned int flags)
{
  switch(flags) {
  case 0:
    return "0";

  case NCNAME_START_CHAR10:
    return "NCNAME_START_CHAR10";
  case NCNAME_CHAR10:
    return "NCNAME_CHAR10";
  case NCNAME_START_CHAR11:
    return "NAME_START_CHAR11";
  case NCNAME_CHAR11:
    return "NAME_CHAR11";
  case WHITESPACE_CHAR:
    return "WHITESPACE_CHAR";
  case NON_RESTRICTED_CHAR10:
    return "NON_RESTRICTED_CHAR10";
  case NON_RESTRICTED_CHAR11:
    return "NON_RESTRICTED_CHAR11";
  case CHAR11:
    return "CHAR11";

  case NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | WHITESPACE_CHAR:
    return "NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11 | WHITESPACE_CHAR";
  case NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11:
    return "NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11";
  case NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11:
    return "NCNAME_CHAR10 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11";
  case NCNAME_CHAR10 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11:
    return "NCNAME_CHAR10 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11";
  case NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11:
    return "NCNAME_START_CHAR10 | NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11";
  case NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11:
    return "NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11";
  case NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11:
    return "NCNAME_CHAR10 | NCNAME_START_CHAR11 | NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11";
  case NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11:
    return "NCNAME_CHAR11 | NON_RESTRICTED_CHAR10 | NON_RESTRICTED_CHAR11";
  }

  return "UNKNOWN";
}

uint8_t FAXPP_char_flags_impl(Char32 c)
{
  unsigned int min, max, middle, result;
  int cmp;

  // Binary search in the char_classes table
  min = 0;
  max = CHAR_CLASSES_SIZE;

  while(min < max) {
    middle = (max + min) >> 1;

    cmp = char_classes[middle].c - c;
    if(cmp > 0) max = middle;
    else if(cmp < 0) {
      result = middle;
      min = middle + 1;
    }
    else {
      result = middle;
      break;
    }
  }

  return char_classes[result].flags;
}

/* #include <stdio.h> */
/* void printCharClassTable() */
/* { */
/*   int ch; */
/*   for(ch = 0; ch < 0x100; ++ch) { */
/*     printf("  /\* 0x%02X *\/ %s,\n", ch, FAXPP_char_flags_to_string(FAXPP_char_flags_impl(ch))); */
/*   } */
/* } */
