###
# Copyright (c) 2015, Valentin Lorentz
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   * Redistributions of source code must retain the above copyright notice,
#     this list of conditions, and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright notice,
#     this list of conditions, and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the author of this software nor the name of
#     contributors to this software may be used to endorse or promote products
#     derived from this software without specific prior written consent.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

###

from supybot.test import *


class AlternativeToTestCase(PluginTestCase):
    plugins = ('AlternativeTo',)

    def testBase(self):
        self.assertRegexp('alternatives avidemux', 'handbrake')
        self.assertRegexp('alternatives --exact avidemux', 'handbrake')

    def testFiltersBase(self):
        self.assertRegexp('alternatives avidemux', 'lightworks')
        self.assertRegexp('alternatives --license opensource avidemux', 'handbrake')
        self.assertRegexp('alternatives --exact --license opensource avidemux',
                'handbrake')
        self.assertNotRegexp('alternatives --license opensource avidemux',
                'lightworks')
        self.assertNotRegexp('alternatives --exact --license opensource avidemux',
                'lightworks')

    def testNotFound(self):
        self.assertResponse('alternatives ergjerpoergpg',
                'Error: Software not found.')
        self.assertResponse('alternatives lightdm',
                'No alternative found.')

    def testSearch(self):
        self.assertRegexp('alternatives Microsoft Word', 'google docs')

    def testFiltersSearch(self):
        self.assertRegexp('alternatives Word', 'google docs')
        self.assertNotRegexp('alternatives --license opensource Word',
            'google docs')
        self.assertRegexp('alternatives --license opensource Word',
            'libreoffice')


# vim:set shiftwidth=4 tabstop=4 expandtab textwidth=79:
