//  pppstat.hh for bbppp - a ppp connection manager for Blackbox
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#ifndef __PPPSTAT_HH
#define __PPPSTAT_HH

#include "bbppp.hh"
#include "Timer.hh"
#include <sys/timeb.h>

class ToolWindow;

class PPPStat : public TimeoutHandler
{
public :
	PPPStat(ToolWindow *);
	virtual ~PPPStat(void);
	void checkPPP(void);
	void startPPP(void);
	void stopPPP(void);
	bool getConnected(void)
	{
		return(connect_status);
	}

private:
	pid_t execCommand(char *);
	bool stillonline(char *);
	int get_statistics(char *);
	void get_ppp_stats(struct ppp_stats *cur);  // ppp_stats record found in <linux/ppp_defs.h>
	float calcThruput(timeb&);
	BTimer *timer;
	void timeout(void);
	ToolWindow *bbtool;

	bool connect_status;
	long starttime;
	long currenttime;
	long lasttime;
	//  long waittime; // never used, but leave it here just in case

	long ppp_send,ppp_sl;         // *sl vars hold previous packet count
	long ppp_recv,ppp_rl;
	long ppp_sbytes,ppp_rbytes;
	long ppp_lastByteTotal;       // previous bytecount sum (send+recv)
	double lastTimeMil;        // used for throughput calculations, granularity of millisecs
	int ppp_h;

	char	*active_interface;
	struct stat st;

	pid_t	stop_child;
	pid_t	start_child;
	int status;
	bool switched_on;    // to let checkPPP() know whether it should execute the resume command

}
;

#endif /* __PPPSTAT_HH */
