// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: private/pbpeerstream/peerstream.proto

package pbpeerstream

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	pbpeering "github.com/hashicorp/consul/proto/private/pbpeering"
	pbservice "github.com/hashicorp/consul/proto/private/pbservice"
	pbstatus "github.com/hashicorp/consul/proto/private/pbstatus"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Operation enumerates supported operations for replicated resources.
type Operation int32

const (
	Operation_OPERATION_UNSPECIFIED Operation = 0
	// UPSERT represents a create or update event.
	Operation_OPERATION_UPSERT Operation = 1
)

// Enum value maps for Operation.
var (
	Operation_name = map[int32]string{
		0: "OPERATION_UNSPECIFIED",
		1: "OPERATION_UPSERT",
	}
	Operation_value = map[string]int32{
		"OPERATION_UNSPECIFIED": 0,
		"OPERATION_UPSERT":      1,
	}
)

func (x Operation) Enum() *Operation {
	p := new(Operation)
	*p = x
	return p
}

func (x Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbpeerstream_peerstream_proto_enumTypes[0].Descriptor()
}

func (Operation) Type() protoreflect.EnumType {
	return &file_private_pbpeerstream_peerstream_proto_enumTypes[0]
}

func (x Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation.Descriptor instead.
func (Operation) EnumDescriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0}
}

type ReplicationMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Payload:
	//
	//	*ReplicationMessage_Open_
	//	*ReplicationMessage_Request_
	//	*ReplicationMessage_Response_
	//	*ReplicationMessage_Terminated_
	//	*ReplicationMessage_Heartbeat_
	Payload isReplicationMessage_Payload `protobuf_oneof:"Payload"`
}

func (x *ReplicationMessage) Reset() {
	*x = ReplicationMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage) ProtoMessage() {}

func (x *ReplicationMessage) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage.ProtoReflect.Descriptor instead.
func (*ReplicationMessage) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0}
}

func (m *ReplicationMessage) GetPayload() isReplicationMessage_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (x *ReplicationMessage) GetOpen() *ReplicationMessage_Open {
	if x, ok := x.GetPayload().(*ReplicationMessage_Open_); ok {
		return x.Open
	}
	return nil
}

func (x *ReplicationMessage) GetRequest() *ReplicationMessage_Request {
	if x, ok := x.GetPayload().(*ReplicationMessage_Request_); ok {
		return x.Request
	}
	return nil
}

func (x *ReplicationMessage) GetResponse() *ReplicationMessage_Response {
	if x, ok := x.GetPayload().(*ReplicationMessage_Response_); ok {
		return x.Response
	}
	return nil
}

func (x *ReplicationMessage) GetTerminated() *ReplicationMessage_Terminated {
	if x, ok := x.GetPayload().(*ReplicationMessage_Terminated_); ok {
		return x.Terminated
	}
	return nil
}

func (x *ReplicationMessage) GetHeartbeat() *ReplicationMessage_Heartbeat {
	if x, ok := x.GetPayload().(*ReplicationMessage_Heartbeat_); ok {
		return x.Heartbeat
	}
	return nil
}

type isReplicationMessage_Payload interface {
	isReplicationMessage_Payload()
}

type ReplicationMessage_Open_ struct {
	Open *ReplicationMessage_Open `protobuf:"bytes,1,opt,name=open,proto3,oneof"`
}

type ReplicationMessage_Request_ struct {
	Request *ReplicationMessage_Request `protobuf:"bytes,2,opt,name=request,proto3,oneof"`
}

type ReplicationMessage_Response_ struct {
	Response *ReplicationMessage_Response `protobuf:"bytes,3,opt,name=response,proto3,oneof"`
}

type ReplicationMessage_Terminated_ struct {
	Terminated *ReplicationMessage_Terminated `protobuf:"bytes,4,opt,name=terminated,proto3,oneof"`
}

type ReplicationMessage_Heartbeat_ struct {
	Heartbeat *ReplicationMessage_Heartbeat `protobuf:"bytes,5,opt,name=heartbeat,proto3,oneof"`
}

func (*ReplicationMessage_Open_) isReplicationMessage_Payload() {}

func (*ReplicationMessage_Request_) isReplicationMessage_Payload() {}

func (*ReplicationMessage_Response_) isReplicationMessage_Payload() {}

func (*ReplicationMessage_Terminated_) isReplicationMessage_Payload() {}

func (*ReplicationMessage_Heartbeat_) isReplicationMessage_Payload() {}

// LeaderAddress is sent when the peering service runs on a consul node
// that is not a leader. The node either lost leadership, or never was a leader.
type LeaderAddress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// address is an ip:port best effort hint at what could be the cluster leader's address
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *LeaderAddress) Reset() {
	*x = LeaderAddress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeaderAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeaderAddress) ProtoMessage() {}

func (x *LeaderAddress) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeaderAddress.ProtoReflect.Descriptor instead.
func (*LeaderAddress) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{1}
}

func (x *LeaderAddress) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// ExportedService is one of the types of data returned via peer stream replication.
type ExportedService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nodes []*pbservice.CheckServiceNode `protobuf:"bytes,1,rep,name=Nodes,proto3" json:"Nodes,omitempty"`
}

func (x *ExportedService) Reset() {
	*x = ExportedService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportedService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportedService) ProtoMessage() {}

func (x *ExportedService) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportedService.ProtoReflect.Descriptor instead.
func (*ExportedService) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{2}
}

func (x *ExportedService) GetNodes() []*pbservice.CheckServiceNode {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// ExportedServiceList is one of the types of data returned via peer stream replication.
type ExportedServiceList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifiers for the services being exported.
	Services []string `protobuf:"bytes,1,rep,name=Services,proto3" json:"Services,omitempty"`
}

func (x *ExportedServiceList) Reset() {
	*x = ExportedServiceList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportedServiceList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportedServiceList) ProtoMessage() {}

func (x *ExportedServiceList) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportedServiceList.ProtoReflect.Descriptor instead.
func (*ExportedServiceList) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{3}
}

func (x *ExportedServiceList) GetServices() []string {
	if x != nil {
		return x.Services
	}
	return nil
}

type ExchangeSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PeerID is the ID of the peering, as determined by the cluster that generated the
	// peering token.
	PeerID string `protobuf:"bytes,1,opt,name=PeerID,proto3" json:"PeerID,omitempty"`
	// EstablishmentSecret is the one-time-use secret encoded in the received peering token.
	EstablishmentSecret string `protobuf:"bytes,2,opt,name=EstablishmentSecret,proto3" json:"EstablishmentSecret,omitempty"`
}

func (x *ExchangeSecretRequest) Reset() {
	*x = ExchangeSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangeSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeSecretRequest) ProtoMessage() {}

func (x *ExchangeSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeSecretRequest.ProtoReflect.Descriptor instead.
func (*ExchangeSecretRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{4}
}

func (x *ExchangeSecretRequest) GetPeerID() string {
	if x != nil {
		return x.PeerID
	}
	return ""
}

func (x *ExchangeSecretRequest) GetEstablishmentSecret() string {
	if x != nil {
		return x.EstablishmentSecret
	}
	return ""
}

type ExchangeSecretResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// StreamSecret is the long-lived secret to be used for authentication with the
	// peering stream handler.
	StreamSecret string `protobuf:"bytes,1,opt,name=StreamSecret,proto3" json:"StreamSecret,omitempty"`
}

func (x *ExchangeSecretResponse) Reset() {
	*x = ExchangeSecretResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangeSecretResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeSecretResponse) ProtoMessage() {}

func (x *ExchangeSecretResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeSecretResponse.ProtoReflect.Descriptor instead.
func (*ExchangeSecretResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{5}
}

func (x *ExchangeSecretResponse) GetStreamSecret() string {
	if x != nil {
		return x.StreamSecret
	}
	return ""
}

// Open is the initial message send by a dialing peer to establish the peering stream.
type ReplicationMessage_Open struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An identifier for the peer making the request.
	// This identifier is provisioned by the serving peer prior to the request from the dialing peer.
	PeerID string `protobuf:"bytes,1,opt,name=PeerID,proto3" json:"PeerID,omitempty"`
	// StreamSecretID contains the long-lived secret from stream authn/authz.
	StreamSecretID string `protobuf:"bytes,2,opt,name=StreamSecretID,proto3" json:"StreamSecretID,omitempty"`
	// Remote contains metadata about the remote peer.
	Remote *pbpeering.RemoteInfo `protobuf:"bytes,3,opt,name=Remote,proto3" json:"Remote,omitempty"`
}

func (x *ReplicationMessage_Open) Reset() {
	*x = ReplicationMessage_Open{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationMessage_Open) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Open) ProtoMessage() {}

func (x *ReplicationMessage_Open) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Open.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Open) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ReplicationMessage_Open) GetPeerID() string {
	if x != nil {
		return x.PeerID
	}
	return ""
}

func (x *ReplicationMessage_Open) GetStreamSecretID() string {
	if x != nil {
		return x.StreamSecretID
	}
	return ""
}

func (x *ReplicationMessage_Open) GetRemote() *pbpeering.RemoteInfo {
	if x != nil {
		return x.Remote
	}
	return nil
}

// A Request requests to subscribe to a resource of a given type.
type ReplicationMessage_Request struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An identifier for the peer making the request.
	// This identifier is provisioned by the serving peer prior to the request from the dialing peer.
	PeerID string `protobuf:"bytes,1,opt,name=PeerID,proto3" json:"PeerID,omitempty"`
	// ResponseNonce corresponding to that of the response being ACKed or NACKed.
	// Initial subscription requests will have an empty nonce.
	// The nonce is generated and incremented by the exporting peer.
	// TODO
	ResponseNonce string `protobuf:"bytes,2,opt,name=ResponseNonce,proto3" json:"ResponseNonce,omitempty"`
	// The type URL for the resource being requested or ACK/NACKed.
	ResourceURL string `protobuf:"bytes,3,opt,name=ResourceURL,proto3" json:"ResourceURL,omitempty"`
	// The error if the previous response was not applied successfully.
	// This field is empty in the first subscription request.
	Error *pbstatus.Status `protobuf:"bytes,5,opt,name=Error,proto3" json:"Error,omitempty"`
}

func (x *ReplicationMessage_Request) Reset() {
	*x = ReplicationMessage_Request{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationMessage_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Request) ProtoMessage() {}

func (x *ReplicationMessage_Request) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Request.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Request) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ReplicationMessage_Request) GetPeerID() string {
	if x != nil {
		return x.PeerID
	}
	return ""
}

func (x *ReplicationMessage_Request) GetResponseNonce() string {
	if x != nil {
		return x.ResponseNonce
	}
	return ""
}

func (x *ReplicationMessage_Request) GetResourceURL() string {
	if x != nil {
		return x.ResourceURL
	}
	return ""
}

func (x *ReplicationMessage_Request) GetError() *pbstatus.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A Response contains resources corresponding to a subscription request.
type ReplicationMessage_Response struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Nonce identifying a response in a stream.
	Nonce string `protobuf:"bytes,1,opt,name=Nonce,proto3" json:"Nonce,omitempty"`
	// The type URL of resource being returned.
	ResourceURL string `protobuf:"bytes,2,opt,name=ResourceURL,proto3" json:"ResourceURL,omitempty"`
	// An identifier for the resource being returned.
	// This could be the SPIFFE ID of the service.
	ResourceID string `protobuf:"bytes,3,opt,name=ResourceID,proto3" json:"ResourceID,omitempty"`
	// The resource being returned.
	Resource *anypb.Any `protobuf:"bytes,4,opt,name=Resource,proto3" json:"Resource,omitempty"`
	// REQUIRED. The operation to be performed in relation to the resource.
	Operation Operation `protobuf:"varint,5,opt,name=operation,proto3,enum=hashicorp.consul.internal.peerstream.Operation" json:"operation,omitempty"`
}

func (x *ReplicationMessage_Response) Reset() {
	*x = ReplicationMessage_Response{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationMessage_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Response) ProtoMessage() {}

func (x *ReplicationMessage_Response) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Response.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Response) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 2}
}

func (x *ReplicationMessage_Response) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

func (x *ReplicationMessage_Response) GetResourceURL() string {
	if x != nil {
		return x.ResourceURL
	}
	return ""
}

func (x *ReplicationMessage_Response) GetResourceID() string {
	if x != nil {
		return x.ResourceID
	}
	return ""
}

func (x *ReplicationMessage_Response) GetResource() *anypb.Any {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *ReplicationMessage_Response) GetOperation() Operation {
	if x != nil {
		return x.Operation
	}
	return Operation_OPERATION_UNSPECIFIED
}

// Terminated is sent when a peering is deleted locally.
// This message signals to the peer that they should clean up their local state about the peering.
type ReplicationMessage_Terminated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReplicationMessage_Terminated) Reset() {
	*x = ReplicationMessage_Terminated{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationMessage_Terminated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Terminated) ProtoMessage() {}

func (x *ReplicationMessage_Terminated) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Terminated.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Terminated) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 3}
}

// Heartbeat is sent to verify that the connection is still active.
type ReplicationMessage_Heartbeat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReplicationMessage_Heartbeat) Reset() {
	*x = ReplicationMessage_Heartbeat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationMessage_Heartbeat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Heartbeat) ProtoMessage() {}

func (x *ReplicationMessage_Heartbeat) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Heartbeat.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Heartbeat) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 4}
}

var File_private_pbpeerstream_peerstream_proto protoreflect.FileDescriptor

var file_private_pbpeerstream_peerstream_proto_rawDesc = []byte{
	0x0a, 0x25, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x70, 0x65, 0x65, 0x72,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f, 0x70, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x1a, 0x25, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x72, 0x61, 0x74, 0x65, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x2f, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x70, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x2f, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbb, 0x08,
	0x0a, 0x12, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x53, 0x0a, 0x04, 0x6f, 0x70, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70,
	0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4f, 0x70, 0x65,
	0x6e, 0x48, 0x00, 0x52, 0x04, 0x6f, 0x70, 0x65, 0x6e, 0x12, 0x5c, 0x0a, 0x07, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x08,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x0a, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x12,
	0x62, 0x0a, 0x09, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70,
	0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x48, 0x65, 0x61,
	0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x48, 0x00, 0x52, 0x09, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62,
	0x65, 0x61, 0x74, 0x1a, 0x8d, 0x01, 0x0a, 0x04, 0x4f, 0x70, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x50, 0x65, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x50, 0x65,
	0x65, 0x72, 0x49, 0x44, 0x12, 0x26, 0x0a, 0x0e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x49, 0x44, 0x12, 0x45, 0x0a, 0x06,
	0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x1a, 0xa9, 0x01, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x50, 0x65, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x50, 0x65, 0x65, 0x72, 0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x12,
	0x3e, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x1a,
	0xe3, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x4e, 0x6f, 0x6e,
	0x63, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x52,
	0x4c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x55, 0x52, 0x4c, 0x12, 0x1e, 0x0a, 0x0a, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x44, 0x12, 0x30, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x08, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x0c, 0x0a, 0x0a, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61,
	0x74, 0x65, 0x64, 0x1a, 0x0b, 0x0a, 0x09, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74,
	0x42, 0x09, 0x0a, 0x07, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x29, 0x0a, 0x0d, 0x4c,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x5c, 0x0a, 0x0f, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x49, 0x0a, 0x05, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x4e,
	0x6f, 0x64, 0x65, 0x73, 0x22, 0x31, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0x61, 0x0a, 0x15, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x50, 0x65, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x50, 0x65, 0x65, 0x72, 0x49, 0x44, 0x12, 0x30, 0x0a, 0x13, 0x45, 0x73, 0x74, 0x61,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x3c, 0x0a, 0x16, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2a, 0x3c, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x14, 0x0a, 0x10, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x50,
	0x53, 0x45, 0x52, 0x54, 0x10, 0x01, 0x32, 0xc1, 0x02, 0x0a, 0x11, 0x50, 0x65, 0x65, 0x72, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x93, 0x01, 0x0a,
	0x0f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65,
	0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x38, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x22, 0x08, 0xe2, 0x86, 0x04, 0x04, 0x08, 0x02, 0x10, 0x02, 0x28, 0x01,
	0x30, 0x01, 0x12, 0x95, 0x01, 0x0a, 0x0e, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70,
	0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x08, 0xe2, 0x86, 0x04, 0x04, 0x08, 0x03, 0x10, 0x02, 0x42, 0xa7, 0x02, 0x0a, 0x28, 0x63,
	0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65,
	0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x0f, 0x50, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x70, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0xa2, 0x02, 0x04, 0x48, 0x43, 0x49, 0x50, 0xaa, 0x02, 0x24, 0x48, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0xca, 0x02, 0x24, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x5c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5c, 0x50, 0x65, 0x65,
	0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xe2, 0x02, 0x30, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5c, 0x50, 0x65, 0x65, 0x72, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5c, 0x47,
	0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x27, 0x48, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x3a, 0x3a,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x3a, 0x3a, 0x50, 0x65, 0x65, 0x72, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_private_pbpeerstream_peerstream_proto_rawDescOnce sync.Once
	file_private_pbpeerstream_peerstream_proto_rawDescData = file_private_pbpeerstream_peerstream_proto_rawDesc
)

func file_private_pbpeerstream_peerstream_proto_rawDescGZIP() []byte {
	file_private_pbpeerstream_peerstream_proto_rawDescOnce.Do(func() {
		file_private_pbpeerstream_peerstream_proto_rawDescData = protoimpl.X.CompressGZIP(file_private_pbpeerstream_peerstream_proto_rawDescData)
	})
	return file_private_pbpeerstream_peerstream_proto_rawDescData
}

var file_private_pbpeerstream_peerstream_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_private_pbpeerstream_peerstream_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_private_pbpeerstream_peerstream_proto_goTypes = []interface{}{
	(Operation)(0),                        // 0: hashicorp.consul.internal.peerstream.Operation
	(*ReplicationMessage)(nil),            // 1: hashicorp.consul.internal.peerstream.ReplicationMessage
	(*LeaderAddress)(nil),                 // 2: hashicorp.consul.internal.peerstream.LeaderAddress
	(*ExportedService)(nil),               // 3: hashicorp.consul.internal.peerstream.ExportedService
	(*ExportedServiceList)(nil),           // 4: hashicorp.consul.internal.peerstream.ExportedServiceList
	(*ExchangeSecretRequest)(nil),         // 5: hashicorp.consul.internal.peerstream.ExchangeSecretRequest
	(*ExchangeSecretResponse)(nil),        // 6: hashicorp.consul.internal.peerstream.ExchangeSecretResponse
	(*ReplicationMessage_Open)(nil),       // 7: hashicorp.consul.internal.peerstream.ReplicationMessage.Open
	(*ReplicationMessage_Request)(nil),    // 8: hashicorp.consul.internal.peerstream.ReplicationMessage.Request
	(*ReplicationMessage_Response)(nil),   // 9: hashicorp.consul.internal.peerstream.ReplicationMessage.Response
	(*ReplicationMessage_Terminated)(nil), // 10: hashicorp.consul.internal.peerstream.ReplicationMessage.Terminated
	(*ReplicationMessage_Heartbeat)(nil),  // 11: hashicorp.consul.internal.peerstream.ReplicationMessage.Heartbeat
	(*pbservice.CheckServiceNode)(nil),    // 12: hashicorp.consul.internal.service.CheckServiceNode
	(*pbpeering.RemoteInfo)(nil),          // 13: hashicorp.consul.internal.peering.RemoteInfo
	(*pbstatus.Status)(nil),               // 14: hashicorp.consul.internal.status.Status
	(*anypb.Any)(nil),                     // 15: google.protobuf.Any
}
var file_private_pbpeerstream_peerstream_proto_depIdxs = []int32{
	7,  // 0: hashicorp.consul.internal.peerstream.ReplicationMessage.open:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Open
	8,  // 1: hashicorp.consul.internal.peerstream.ReplicationMessage.request:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Request
	9,  // 2: hashicorp.consul.internal.peerstream.ReplicationMessage.response:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Response
	10, // 3: hashicorp.consul.internal.peerstream.ReplicationMessage.terminated:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Terminated
	11, // 4: hashicorp.consul.internal.peerstream.ReplicationMessage.heartbeat:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Heartbeat
	12, // 5: hashicorp.consul.internal.peerstream.ExportedService.Nodes:type_name -> hashicorp.consul.internal.service.CheckServiceNode
	13, // 6: hashicorp.consul.internal.peerstream.ReplicationMessage.Open.Remote:type_name -> hashicorp.consul.internal.peering.RemoteInfo
	14, // 7: hashicorp.consul.internal.peerstream.ReplicationMessage.Request.Error:type_name -> hashicorp.consul.internal.status.Status
	15, // 8: hashicorp.consul.internal.peerstream.ReplicationMessage.Response.Resource:type_name -> google.protobuf.Any
	0,  // 9: hashicorp.consul.internal.peerstream.ReplicationMessage.Response.operation:type_name -> hashicorp.consul.internal.peerstream.Operation
	1,  // 10: hashicorp.consul.internal.peerstream.PeerStreamService.StreamResources:input_type -> hashicorp.consul.internal.peerstream.ReplicationMessage
	5,  // 11: hashicorp.consul.internal.peerstream.PeerStreamService.ExchangeSecret:input_type -> hashicorp.consul.internal.peerstream.ExchangeSecretRequest
	1,  // 12: hashicorp.consul.internal.peerstream.PeerStreamService.StreamResources:output_type -> hashicorp.consul.internal.peerstream.ReplicationMessage
	6,  // 13: hashicorp.consul.internal.peerstream.PeerStreamService.ExchangeSecret:output_type -> hashicorp.consul.internal.peerstream.ExchangeSecretResponse
	12, // [12:14] is the sub-list for method output_type
	10, // [10:12] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_private_pbpeerstream_peerstream_proto_init() }
func file_private_pbpeerstream_peerstream_proto_init() {
	if File_private_pbpeerstream_peerstream_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_private_pbpeerstream_peerstream_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeaderAddress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportedService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportedServiceList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExchangeSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExchangeSecretResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationMessage_Open); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationMessage_Request); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationMessage_Response); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationMessage_Terminated); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeerstream_peerstream_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationMessage_Heartbeat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_private_pbpeerstream_peerstream_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ReplicationMessage_Open_)(nil),
		(*ReplicationMessage_Request_)(nil),
		(*ReplicationMessage_Response_)(nil),
		(*ReplicationMessage_Terminated_)(nil),
		(*ReplicationMessage_Heartbeat_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_private_pbpeerstream_peerstream_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_private_pbpeerstream_peerstream_proto_goTypes,
		DependencyIndexes: file_private_pbpeerstream_peerstream_proto_depIdxs,
		EnumInfos:         file_private_pbpeerstream_peerstream_proto_enumTypes,
		MessageInfos:      file_private_pbpeerstream_peerstream_proto_msgTypes,
	}.Build()
	File_private_pbpeerstream_peerstream_proto = out.File
	file_private_pbpeerstream_peerstream_proto_rawDesc = nil
	file_private_pbpeerstream_peerstream_proto_goTypes = nil
	file_private_pbpeerstream_peerstream_proto_depIdxs = nil
}
