/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.filesystem;

import java.io.File;
import java.util.Vector;
import org.eso.util.filesystem.FileSelectionModel;

public class DirectoryFileSelectionModel
extends FileSelectionModel {
    private String[] dirs = null;

    public DirectoryFileSelectionModel() {
        this.dirs = new String[0];
    }

    public DirectoryFileSelectionModel(String[] dirlist) {
        this.dirs = dirlist;
    }

    public DirectoryFileSelectionModel(String filePath) {
        this.dirs = new String[1];
        this.dirs[0] = filePath;
    }

    public String[] getDirs() {
        return this.dirs;
    }

    @Override
    public Vector getFileList() {
        return this.getComponentFiles();
    }

    private Vector getComponentFiles() {
        Vector<String> rc = new Vector<String>();
        if (this.dirs == null) {
            return rc;
        }
        for (int i = 0; i < this.dirs.length; ++i) {
            String[] files = null;
            if (this.dirs[i] == null) continue;
            File dir = new File(this.dirs[i]);
            if (dir.isDirectory()) {
                try {
                    files = dir.list();
                }
                catch (SecurityException e2) {
                    System.out.println(e2.toString());
                }
                if (files == null) {
                    System.out.println("No files found under: " + this.dirs[i]);
                    continue;
                }
                for (int x = 0; x < files.length; ++x) {
                    rc.addElement(dir.getPath() + File.separator + files[x]);
                }
                continue;
            }
            rc.addElement(this.dirs[i]);
        }
        return rc;
    }
}

