/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.keyword;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.eso.gasgano.keyword.BinaryKeywordExpr;
import org.eso.gasgano.keyword.DefaultBoolKeywordExpr;
import org.eso.gasgano.keyword.ExpressionEvaluationException;
import org.eso.gasgano.keyword.KeywordSet;

public class LikeKeywordExpr
extends BinaryKeywordExpr {
    static final long serialVersionUID = -4276010844095737983L;
    public static final String opString = "like";
    private boolean argumentsValidated = false;
    private String exceptionMessage = null;
    private Vector matchTokens = new Vector();
    public static final char WILD_CARD = '*';

    public LikeKeywordExpr(Object l, Object r) {
        super(l, r);
    }

    @Override
    public boolean eval(float l, float r) {
        return false;
    }

    @Override
    public boolean eval(String l, String r) {
        return false;
    }

    @Override
    public boolean evaluate(KeywordSet s) throws ExpressionEvaluationException {
        boolean rc = true;
        if (!this.argumentsValidated) {
            if (!this.isStringCompatible(this.getLeftValue())) {
                this.exceptionMessage = new String("Left argument could not be read as a character string.");
            }
            if (!(this.getRightValue() instanceof String)) {
                this.exceptionMessage = new String("Right argument is not a character string.");
            } else {
                String matchString = (String)this.getRightValue();
                int offset = 0;
                int matchLen = matchString.length();
                try {
                    while (offset != matchLen) {
                        String token;
                        if (matchString.charAt(offset) == '*') {
                            this.matchTokens.addElement(new WildCard());
                            ++offset;
                            continue;
                        }
                        int tokenEnd = matchString.indexOf(42, offset);
                        if (tokenEnd == -1) {
                            tokenEnd = matchString.length();
                        }
                        if ((token = matchString.substring(offset, tokenEnd)).length() > 0) {
                            this.matchTokens.addElement(token.toUpperCase());
                        }
                        offset = tokenEnd;
                    }
                }
                catch (StringIndexOutOfBoundsException e2) {
                    this.exceptionMessage = new String("Invalid match string: " + matchString + ".");
                }
            }
            this.argumentsValidated = true;
        }
        if (this.exceptionMessage != null) {
            throw new ExpressionEvaluationException(this.exceptionMessage);
        }
        this.resolveKeyword(this.getLeftValue(), s);
        String val = LikeKeywordExpr.getString(this.getLeftValue());
        if (this.matchTokens.size() == 0 && val.length() > 0) {
            rc = false;
        }
        Enumeration e3 = this.matchTokens.elements();
        boolean exactTokenMatchRequired = true;
        int offset = 0;
        while (rc && e3.hasMoreElements()) {
            Object tok = e3.nextElement();
            if (tok instanceof WildCard) {
                exactTokenMatchRequired = false;
                continue;
            }
            String tokStr = (String)tok;
            int matchIndex = val.indexOf(tokStr, offset);
            if (matchIndex == -1) {
                rc = false;
                continue;
            }
            if (matchIndex != offset && exactTokenMatchRequired) {
                rc = false;
                continue;
            }
            offset = matchIndex + 1 + tokStr.length();
            exactTokenMatchRequired = true;
        }
        if (offset < val.length() && exactTokenMatchRequired) {
            rc = false;
        }
        return rc;
    }

    public void printTokens() {
        Enumeration e2 = this.matchTokens.elements();
        System.out.print("Like Tokens:");
        while (e2.hasMoreElements()) {
            Object o = e2.nextElement();
            if (o instanceof WildCard) {
                System.out.print(" *");
                continue;
            }
            System.out.print(" " + o.toString());
        }
        System.out.println("");
    }

    @Override
    public String getOpString() {
        return opString;
    }

    @Override
    public DefaultBoolKeywordExpr copy() {
        LikeKeywordExpr rc = new LikeKeywordExpr(this.getLeftValue(), this.getRightValue());
        return rc;
    }

    class WildCard
    implements Serializable {
        private static final long serialVersionUID = -7913486541337811589L;

        WildCard() {
        }
    }
}

