/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class NamingScheme {
    public static final NamingScheme NUMERIC = new NamingScheme("Numeric"){

        @Override
        public File transform(File raw) {
            File file;
            String extension;
            String path = raw.getPath();
            int extIdx = path.lastIndexOf(46);
            if (extIdx > 0) {
                extension = path.substring(extIdx);
                path = path.substring(0, extIdx);
            } else {
                extension = "";
            }
            int index = 0;
            while ((file = new File(path + "_" + NamingScheme.pad("" + index++, '0', 4) + extension)).exists()) {
            }
            return file;
        }
    };
    public static final NamingScheme OVERWRITE = new NamingScheme("Overwrite"){

        @Override
        public File transform(File raw) {
            return raw;
        }
    };
    public static final List STANDARD_SCHEMES = Collections.unmodifiableList(Arrays.asList(OVERWRITE, NUMERIC));
    public static final NamingScheme DEFAULT = NUMERIC;
    private final String name_;

    private static String pad(String in, char padCh, int len) {
        while (in.length() < len) {
            in = padCh + in;
        }
        return in;
    }

    protected NamingScheme(String name) {
        this.name_ = name;
    }

    public abstract File transform(File var1);

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.name_;
    }
}

