/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.TdsCursor;
import com.sybase.jdbc3.tds.TdsDataOutputStream;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.tds.Token;
import java.io.IOException;
import java.sql.SQLException;

public class CurDeclareToken
extends Token {
    protected TdsCursor _cursor;
    protected String _query;
    protected int _nameLen;
    protected long _queryLen;
    protected int _colLen;

    protected CurDeclareToken() {
    }

    public CurDeclareToken(TdsCursor tdsCursor, String string) throws SQLException {
        this._query = string;
        this._cursor = tdsCursor;
    }

    public void send(TdsDataOutputStream tdsDataOutputStream) throws IOException {
        byte[] byArray;
        int n;
        byte[] byArray2 = tdsDataOutputStream.stringToByte(this._cursor.getName());
        this._nameLen = byArray2.length;
        byte[] byArray3 = tdsDataOutputStream.stringToByte(this._query);
        this._queryLen = byArray3.length;
        this._colLen = 0;
        if (this._cursor._columns != null) {
            this._colLen = this._cursor._columns.length;
            for (n = 0; n < this._cursor._columns.length; ++n) {
                byArray = tdsDataOutputStream.stringToByte(this._cursor._columns[n]);
                this._colLen += byArray.length;
            }
        }
        try {
            this.sendTokenName(tdsDataOutputStream);
            this.sendTokenLength(tdsDataOutputStream);
            tdsDataOutputStream.writeByte(this._nameLen);
            tdsDataOutputStream.write(byArray2);
            this.sendOptions(tdsDataOutputStream);
            tdsDataOutputStream.writeByte(this._cursor._hasArgs);
            this.sendQueryLen(tdsDataOutputStream);
            tdsDataOutputStream.write(byArray3);
            if (this._cursor._columns != null) {
                this.sendNumColumns(tdsDataOutputStream, this._cursor._columns.length);
                for (n = 0; n < this._cursor._columns.length; ++n) {
                    byArray = tdsDataOutputStream.stringToByte(this._cursor._columns[n]);
                    int n2 = byArray.length;
                    tdsDataOutputStream.writeByte(n2);
                    tdsDataOutputStream.write(byArray);
                }
            } else {
                this.sendNumColumns(tdsDataOutputStream, 0);
            }
        }
        catch (IOException iOException) {
            CurDeclareToken.writeSQE(iOException);
        }
    }

    protected void sendTokenName(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(134);
    }

    protected void sendTokenLength(TdsOutputStream tdsOutputStream) throws IOException {
        long l = (long)(1 + this._nameLen + 1 + 1 + 2) + this._queryLen + 1L + (long)this._colLen;
        tdsOutputStream.writeShort((int)l);
    }

    protected void sendNumColumns(TdsOutputStream tdsOutputStream, int n) throws IOException {
        tdsOutputStream.writeByte(n);
    }

    protected void sendQueryLen(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeShort((int)this._queryLen);
    }

    protected void sendOptions(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(this._cursor._type);
    }

    protected String getTokenNameAsString() {
        return "CurDeclareToken";
    }
}

