﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime-sdk-voice/ChimeSDKVoiceErrors.h>
#include <aws/core/client/AWSError.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Client;
using namespace Aws::Utils;
using namespace Aws::ChimeSDKVoice;

namespace Aws {
namespace ChimeSDKVoice {
namespace ChimeSDKVoiceErrorMapper {

static const int CONFLICT_HASH = HashingUtils::HashString("ConflictException");
static const int NOT_FOUND_HASH = HashingUtils::HashString("NotFoundException");
static const int SERVICE_FAILURE_HASH = HashingUtils::HashString("ServiceFailureException");
static const int FORBIDDEN_HASH = HashingUtils::HashString("ForbiddenException");
static const int RESOURCE_LIMIT_EXCEEDED_HASH = HashingUtils::HashString("ResourceLimitExceededException");
static const int GONE_HASH = HashingUtils::HashString("GoneException");
static const int THROTTLED_CLIENT_HASH = HashingUtils::HashString("ThrottledClientException");
static const int UNPROCESSABLE_ENTITY_HASH = HashingUtils::HashString("UnprocessableEntityException");
static const int UNAUTHORIZED_CLIENT_HASH = HashingUtils::HashString("UnauthorizedClientException");
static const int BAD_REQUEST_HASH = HashingUtils::HashString("BadRequestException");

AWSError<CoreErrors> GetErrorForName(const char* errorName) {
  int hashCode = HashingUtils::HashString(errorName);

  if (hashCode == CONFLICT_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::CONFLICT), RetryableType::NOT_RETRYABLE);
  } else if (hashCode == NOT_FOUND_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::NOT_FOUND), RetryableType::NOT_RETRYABLE);
  } else if (hashCode == SERVICE_FAILURE_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::SERVICE_FAILURE), RetryableType::RETRYABLE);
  } else if (hashCode == FORBIDDEN_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::FORBIDDEN), RetryableType::NOT_RETRYABLE);
  } else if (hashCode == RESOURCE_LIMIT_EXCEEDED_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::RESOURCE_LIMIT_EXCEEDED), RetryableType::NOT_RETRYABLE);
  } else if (hashCode == GONE_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::GONE), RetryableType::NOT_RETRYABLE);
  } else if (hashCode == THROTTLED_CLIENT_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::THROTTLED_CLIENT), RetryableType::NOT_RETRYABLE);
  } else if (hashCode == UNPROCESSABLE_ENTITY_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::UNPROCESSABLE_ENTITY), RetryableType::NOT_RETRYABLE);
  } else if (hashCode == UNAUTHORIZED_CLIENT_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::UNAUTHORIZED_CLIENT), RetryableType::NOT_RETRYABLE);
  } else if (hashCode == BAD_REQUEST_HASH) {
    return AWSError<CoreErrors>(static_cast<CoreErrors>(ChimeSDKVoiceErrors::BAD_REQUEST), RetryableType::NOT_RETRYABLE);
  }
  return AWSError<CoreErrors>(CoreErrors::UNKNOWN, false);
}

}  // namespace ChimeSDKVoiceErrorMapper
}  // namespace ChimeSDKVoice
}  // namespace Aws
