﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/backupsearch/model/ListSearchJobsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::BackupSearch::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListSearchJobsResult::ListSearchJobsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListSearchJobsResult& ListSearchJobsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("SearchJobs")) {
    Aws::Utils::Array<JsonView> searchJobsJsonList = jsonValue.GetArray("SearchJobs");
    for (unsigned searchJobsIndex = 0; searchJobsIndex < searchJobsJsonList.GetLength(); ++searchJobsIndex) {
      m_searchJobs.push_back(searchJobsJsonList[searchJobsIndex].AsObject());
    }
    m_searchJobsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
