/* automatically generated by rust-bindgen 0.55.1 */

extern "C" {
    pub static NK_PWS_SLOT_COUNT: u8;
}
pub const MAXIMUM_STR_REPLY_LENGTH: ::std::os::raw::c_int = 8192;
#[doc = " Use, if no supported device is connected"]
pub const NK_device_model_NK_DISCONNECTED: NK_device_model = 0;
#[doc = " Nitrokey Pro."]
pub const NK_device_model_NK_PRO: NK_device_model = 1;
#[doc = " Nitrokey Storage."]
pub const NK_device_model_NK_STORAGE: NK_device_model = 2;
#[doc = " Librem Key."]
pub const NK_device_model_NK_LIBREM: NK_device_model = 3;
#[doc = " The Nitrokey device models supported by the API."]
pub type NK_device_model = ::std::os::raw::c_uint;
#[doc = " The connection info for a Nitrokey device as a linked list."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NK_device_info {
    #[doc = " The model of the Nitrokey device."]
    pub model: NK_device_model,
    #[doc = " The USB device path for NK_connect_with_path."]
    pub path: *mut ::std::os::raw::c_char,
    #[doc = " The serial number."]
    pub serial_number: *mut ::std::os::raw::c_char,
    #[doc = " The pointer to the next element of the linked list or null"]
    #[doc = " if this is the last element in the list."]
    pub next: *mut NK_device_info,
}
impl Default for NK_device_info {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[doc = " Stores the common device status for all Nitrokey devices."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct NK_status {
    #[doc = " The major firmware version, e. g. 0 in v0.40."]
    pub firmware_version_major: u8,
    #[doc = " The minor firmware version, e. g. 40 in v0.40."]
    pub firmware_version_minor: u8,
    #[doc = " The serial number of the smart card."]
    pub serial_number_smart_card: u32,
    #[doc = " The HOTP slot to generate a password from if the numlock"]
    #[doc = " key is pressed twice (slot 0-1, or any other value to"]
    #[doc = " disable the function)."]
    pub config_numlock: u8,
    #[doc = " The HOTP slot to generate a password from if the capslock"]
    #[doc = " key is pressed twice (slot 0-1, or any other value to"]
    #[doc = " disable the function)."]
    pub config_capslock: u8,
    #[doc = " The HOTP slot to generate a password from if the scrolllock"]
    #[doc = " key is pressed twice (slot 0-1, or any other value to"]
    #[doc = " disable the function)."]
    pub config_scrolllock: u8,
    #[doc = " Indicates whether the user password is required to generate"]
    #[doc = " an OTP value."]
    pub otp_user_password: bool,
}
#[doc = " Stores the status of a Storage device."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct NK_storage_status {
    #[doc = " Indicates whether the unencrypted volume is read-only."]
    pub unencrypted_volume_read_only: bool,
    #[doc = " Indicates whether the unencrypted volume is active."]
    pub unencrypted_volume_active: bool,
    #[doc = " Indicates whether the encrypted volume is read-only."]
    pub encrypted_volume_read_only: bool,
    #[doc = " Indicates whether the encrypted volume is active."]
    pub encrypted_volume_active: bool,
    #[doc = " Indicates whether the hidden volume is read-only."]
    pub hidden_volume_read_only: bool,
    #[doc = " Indicates whether the hidden volume is active."]
    pub hidden_volume_active: bool,
    #[doc = " The major firmware version, e. g. 0 in v0.40."]
    pub firmware_version_major: u8,
    #[doc = " The minor firmware version, e. g. 40 in v0.40."]
    pub firmware_version_minor: u8,
    #[doc = " Indicates whether the firmware is locked."]
    pub firmware_locked: bool,
    #[doc = " The serial number of the SD card in the Storage stick."]
    pub serial_number_sd_card: u32,
    #[doc = " The serial number of the smart card in the Storage stick."]
    pub serial_number_smart_card: u32,
    #[doc = " The number of remaining login attempts for the user PIN."]
    pub user_retry_count: u8,
    #[doc = " The number of remaining login attempts for the admin PIN."]
    pub admin_retry_count: u8,
    #[doc = " Indicates whether a new SD card was found."]
    pub new_sd_card_found: bool,
    #[doc = " Indicates whether the SD card is filled with random characters."]
    pub filled_with_random: bool,
    #[doc = " Indicates whether the stick has been initialized by generating"]
    #[doc = " the AES keys."]
    pub stick_initialized: bool,
}
#[doc = " Data about the usage of the SD card."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct NK_SD_usage_data {
    #[doc = " The minimum write level, as a percentage of the total card"]
    #[doc = " size."]
    pub write_level_min: u8,
    #[doc = " The maximum write level, as a percentage of the total card"]
    #[doc = " size."]
    pub write_level_max: u8,
}
#[doc = " The general configuration of a Nitrokey device."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct NK_config {
    #[doc = " value in range [0-1] to send HOTP code from slot 'numlock' after double pressing numlock"]
    #[doc = " or outside the range to disable this function"]
    pub numlock: u8,
    #[doc = " similar to numlock but with capslock"]
    pub capslock: u8,
    #[doc = " similar to numlock but with scrolllock"]
    pub scrolllock: u8,
    #[doc = " True to enable OTP PIN protection (require PIN each OTP code request)"]
    pub enable_user_password: bool,
    #[doc = " Unused."]
    pub disable_user_password: bool,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct NK_storage_ProductionTest {
    pub FirmwareVersion_au8: [u8; 2usize],
    pub FirmwareVersionInternal_u8: u8,
    pub SD_Card_Size_u8: u8,
    pub CPU_CardID_u32: u32,
    pub SmartCardID_u32: u32,
    pub SD_CardID_u32: u32,
    pub SC_UserPwRetryCount: u8,
    pub SC_AdminPwRetryCount: u8,
    pub SD_Card_ManufacturingYear_u8: u8,
    pub SD_Card_ManufacturingMonth_u8: u8,
    pub SD_Card_OEM_u16: u16,
    pub SD_WriteSpeed_u16: u16,
    pub SD_Card_Manufacturer_u8: u8,
}
extern "C" {
    pub fn NK_get_storage_production_info(
        out: *mut NK_storage_ProductionTest,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set debug level of messages written on stderr"]
    #[doc = " @param state state=True - most messages, state=False - only errors level"]
    pub fn NK_set_debug(state: bool);
}
extern "C" {
    #[doc = " Set debug level of messages written on stderr"]
    #[doc = " @param level (int) 0-lowest verbosity, 5-highest verbosity"]
    pub fn NK_set_debug_level(level: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " Get the major library version, e. g. the 3 in v3.2."]
    #[doc = " @return the major library version"]
    pub fn NK_get_major_library_version() -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Get the minor library version, e. g. the 2 in v3.2."]
    #[doc = " @return the minor library version"]
    pub fn NK_get_minor_library_version() -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Get the library version as a string.  This is the output of"]
    #[doc = " `git describe --always` at compile time, for example \"v3.3\" or"]
    #[doc = " \"v3.3-19-gaee920b\"."]
    #[doc = " The return value is a string literal and must not be freed."]
    #[doc = " @return the library version as a string"]
    pub fn NK_get_library_version() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Connect to device of given model. Currently library can be connected only to one device at once."]
    #[doc = " @param device_model char 'S': Nitrokey Storage, 'P': Nitrokey Pro"]
    #[doc = " @return 1 if connected, 0 if wrong model or cannot connect"]
    pub fn NK_login(device_model: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Connect to device of given model. Currently library can be connected only to one device at once."]
    #[doc = " @param device_model NK_device_model: NK_PRO: Nitrokey Pro, NK_STORAGE: Nitrokey Storage, NK_LIBREM: Librem Key"]
    #[doc = " @return 1 if connected, 0 if wrong model or cannot connect"]
    pub fn NK_login_enum(device_model: NK_device_model) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Connect to first available device, starting checking from Pro 1st to Storage 2nd."]
    #[doc = " @return 1 if connected, 0 if wrong model or cannot connect"]
    pub fn NK_login_auto() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Disconnect from the device."]
    #[doc = " @return command processing error code"]
    pub fn NK_logout() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Query the model of the connected device."]
    #[doc = " Returns the model of the connected device or NK_DISCONNECTED."]
    #[doc = ""]
    #[doc = " @return true if a device is connected and the out argument has been set"]
    pub fn NK_get_device_model() -> NK_device_model;
}
extern "C" {
    #[doc = " Return the debug status string. Debug purposes.  This function is"]
    #[doc = " deprecated in favor of NK_get_status_as_string."]
    #[doc = " @return string representation of the status or an empty string"]
    #[doc = "         if the command failed"]
    #[deprecated(since = "3.5.0", note = "use `NK_get_status_as_string` instead")]
    pub fn NK_status() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return the debug status string. Debug purposes."]
    #[doc = " @return string representation of the status or an empty string"]
    #[doc = "         if the command failed"]
    pub fn NK_get_status_as_string() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the stick status common to all Nitrokey devices and return the"]
    #[doc = " command processing error code.  If the code is zero, i. e. the"]
    #[doc = " command was successful, the storage status is written to the output"]
    #[doc = " pointer's target.  The output pointer must not be null."]
    #[doc = ""]
    #[doc = " @param out the output pointer for the status"]
    #[doc = " @return command processing error code"]
    pub fn NK_get_status(out: *mut NK_status) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return the device's serial number string in hex."]
    #[doc = " @return string device's serial number in hex"]
    pub fn NK_device_serial_number() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return the device's serial number string as an integer.  Use"]
    #[doc = " NK_last_command_status to check for an error if this function"]
    #[doc = " returns zero."]
    #[doc = " @return device's serial number as an integer"]
    pub fn NK_device_serial_number_as_u32() -> u32;
}
extern "C" {
    #[doc = " Get last command processing status. Useful for commands which returns the results of their own and could not return"]
    #[doc = " an error code."]
    #[doc = " @return previous command processing error code"]
    pub fn NK_get_last_command_status() -> u8;
}
extern "C" {
    #[doc = " Lock device - cancel any user device unlocking."]
    #[doc = " @return command processing error code"]
    pub fn NK_lock_device() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Authenticates the user on USER privilages with user_password and sets user's temporary password on device to user_temporary_password."]
    #[doc = " @param user_password char[25] current user password"]
    #[doc = " @param user_temporary_password char[25] user temporary password to be set on device for further communication (authentication command)"]
    #[doc = " @return command processing error code"]
    pub fn NK_user_authenticate(
        user_password: *const ::std::os::raw::c_char,
        user_temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Authenticates the user on ADMIN privilages with admin_password and sets user's temporary password on device to admin_temporary_password."]
    #[doc = " @param admin_password char[25] current administrator PIN"]
    #[doc = " @param admin_temporary_password char[25] admin temporary password to be set on device for further communication (authentication command)"]
    #[doc = " @return command processing error code"]
    pub fn NK_first_authenticate(
        admin_password: *const ::std::os::raw::c_char,
        admin_temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Execute a factory reset."]
    #[doc = " @param admin_password char[20] current administrator PIN"]
    #[doc = " @return command processing error code"]
    pub fn NK_factory_reset(admin_password: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Generates AES key on the device"]
    #[doc = " @param admin_password char[20] current administrator PIN"]
    #[doc = " @return command processing error code"]
    pub fn NK_build_aes_key(admin_password: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Unlock user PIN locked after 3 incorrect codes tries."]
    #[doc = " @param admin_password char[20] current administrator PIN"]
    #[doc = " @return command processing error code"]
    pub fn NK_unlock_user_password(
        admin_password: *const ::std::os::raw::c_char,
        new_user_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write general config to the device"]
    #[doc = " @param numlock set value in range [0-1] to send HOTP code from slot 'numlock' after double pressing numlock"]
    #[doc = " or outside the range to disable this function"]
    #[doc = " @param capslock similar to numlock but with capslock"]
    #[doc = " @param scrolllock similar to numlock but with scrolllock"]
    #[doc = " @param enable_user_password set True to enable OTP PIN protection (require PIN each OTP code request)"]
    #[doc = " @param delete_user_password (unused)"]
    #[doc = " @param admin_temporary_password current admin temporary password"]
    #[doc = " @return command processing error code"]
    pub fn NK_write_config(
        numlock: u8,
        capslock: u8,
        scrolllock: u8,
        enable_user_password: bool,
        delete_user_password: bool,
        admin_temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write general config to the device"]
    #[doc = " @param config the configuration data"]
    #[doc = " @param admin_temporary_password current admin temporary password"]
    #[doc = " @return command processing error code"]
    pub fn NK_write_config_struct(
        config: NK_config,
        admin_temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get currently set config - status of function Numlock/Capslock/Scrollock OTP sending and is enabled PIN protected OTP"]
    #[doc = " The return value must be freed using NK_free_config."]
    #[doc = " @see NK_write_config"]
    #[doc = " @return  uint8_t general_config[5]:"]
    #[doc = "            uint8_t numlock;"]
    #[doc = "uint8_t capslock;"]
    #[doc = "uint8_t scrolllock;"]
    #[doc = "uint8_t enable_user_password;"]
    #[doc = "uint8_t delete_user_password;"]
    #[doc = ""]
    pub fn NK_read_config() -> *mut u8;
}
extern "C" {
    #[doc = " Free a value returned by NK_read_config.  May be called with a NULL"]
    #[doc = " argument."]
    pub fn NK_free_config(config: *mut u8);
}
extern "C" {
    #[doc = " Get currently set config and write it to the given pointer."]
    #[doc = " @see NK_read_config"]
    #[doc = " @see NK_write_config_struct"]
    #[doc = " @param out a pointer to the struct that should be written to"]
    #[doc = " @return command processing error code"]
    pub fn NK_read_config_struct(out: *mut NK_config) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get name of given TOTP slot"]
    #[doc = " @param slot_number TOTP slot number, slot_number<15"]
    #[doc = " @return char[20] the name of the slot"]
    pub fn NK_get_totp_slot_name(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @param slot_number HOTP slot number, slot_number<3"]
    #[doc = " @return char[20] the name of the slot"]
    pub fn NK_get_hotp_slot_name(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Erase HOTP slot data from the device"]
    #[doc = " @param slot_number HOTP slot number, slot_number<3"]
    #[doc = " @param temporary_password admin temporary password"]
    #[doc = " @return command processing error code"]
    pub fn NK_erase_hotp_slot(
        slot_number: u8,
        temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Erase TOTP slot data from the device"]
    #[doc = " @param slot_number TOTP slot number, slot_number<15"]
    #[doc = " @param temporary_password admin temporary password"]
    #[doc = " @return command processing error code"]
    pub fn NK_erase_totp_slot(
        slot_number: u8,
        temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write HOTP slot data to the device"]
    #[doc = " @param slot_number HOTP slot number, slot_number<3, 0-numbered"]
    #[doc = " @param slot_name char[15] desired slot name. C string (requires ending '\\0'; 16 bytes)."]
    #[doc = " @param secret char[40] 160-bit or 320-bit (currently Pro v0.8 only) secret as a hex string. C string (requires ending '\\0'; 41 bytes)."]
    #[doc = " See NitrokeyManager::is_320_OTP_secret_supported."]
    #[doc = " @param hotp_counter uint32_t starting value of HOTP counter"]
    #[doc = " @param use_8_digits should returned codes be 6 (false) or 8 digits (true)"]
    #[doc = " @param use_enter press ENTER key after sending OTP code using double-pressed scroll/num/capslock"]
    #[doc = " @param use_tokenID @see token_ID"]
    #[doc = " @param token_ID @see https://openauthentication.org/token-specs/, 'Class A' section"]
    #[doc = " @param temporary_password char[25] admin temporary password"]
    #[doc = " @return command processing error code"]
    pub fn NK_write_hotp_slot(
        slot_number: u8,
        slot_name: *const ::std::os::raw::c_char,
        secret: *const ::std::os::raw::c_char,
        hotp_counter: u64,
        use_8_digits: bool,
        use_enter: bool,
        use_tokenID: bool,
        token_ID: *const ::std::os::raw::c_char,
        temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write TOTP slot data to the device"]
    #[doc = " @param slot_number TOTP slot number, slot_number<15, 0-numbered"]
    #[doc = " @param slot_name char[15] desired slot name. C string (requires ending '\\0'; 16 bytes)."]
    #[doc = " @param secret char[40] 160-bit or 320-bit (currently Pro v0.8 only) secret as a hex string. C string (requires ending '\\0'; 41 bytes)."]
    #[doc = " See NitrokeyManager::is_320_OTP_secret_supported."]
    #[doc = " @param time_window uint16_t time window for this TOTP"]
    #[doc = " @param use_8_digits should returned codes be 6 (false) or 8 digits (true)"]
    #[doc = " @param use_enter press ENTER key after sending OTP code using double-pressed scroll/num/capslock"]
    #[doc = " @param use_tokenID @see token_ID"]
    #[doc = " @param token_ID @see https://openauthentication.org/token-specs/, 'Class A' section"]
    #[doc = " @param temporary_password char[20] admin temporary password"]
    #[doc = " @return command processing error code"]
    pub fn NK_write_totp_slot(
        slot_number: u8,
        slot_name: *const ::std::os::raw::c_char,
        secret: *const ::std::os::raw::c_char,
        time_window: u16,
        use_8_digits: bool,
        use_enter: bool,
        use_tokenID: bool,
        token_ID: *const ::std::os::raw::c_char,
        temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get HOTP code from the device"]
    #[doc = " @param slot_number HOTP slot number, slot_number<3"]
    #[doc = " @return HOTP code"]
    pub fn NK_get_hotp_code(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get HOTP code from the device (PIN protected)"]
    #[doc = " @param slot_number HOTP slot number, slot_number<3"]
    #[doc = " @param user_temporary_password char[25] user temporary password if PIN protected OTP codes are enabled,"]
    #[doc = " otherwise should be set to empty string - ''"]
    #[doc = " @return HOTP code"]
    pub fn NK_get_hotp_code_PIN(
        slot_number: u8,
        user_temporary_password: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get TOTP code from the device"]
    #[doc = " @param slot_number TOTP slot number, slot_number<15"]
    #[doc = " @param challenge TOTP challenge -- unused"]
    #[doc = " @param last_totp_time last time -- unused"]
    #[doc = " @param last_interval last interval --unused"]
    #[doc = " @return TOTP code"]
    pub fn NK_get_totp_code(
        slot_number: u8,
        challenge: u64,
        last_totp_time: u64,
        last_interval: u8,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get TOTP code from the device (PIN protected)"]
    #[doc = " @param slot_number TOTP slot number, slot_number<15"]
    #[doc = " @param challenge TOTP challenge -- unused"]
    #[doc = " @param last_totp_time last time -- unused"]
    #[doc = " @param last_interval last interval -- unused"]
    #[doc = " @param user_temporary_password char[25] user temporary password if PIN protected OTP codes are enabled,"]
    #[doc = " otherwise should be set to empty string - ''"]
    #[doc = " @return TOTP code"]
    pub fn NK_get_totp_code_PIN(
        slot_number: u8,
        challenge: u64,
        last_totp_time: u64,
        last_interval: u8,
        user_temporary_password: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Set time on the device (for TOTP requests)"]
    #[doc = " @param time seconds in unix epoch (from 01.01.1970)"]
    #[doc = " @return command processing error code"]
    pub fn NK_totp_set_time(time: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set the device time used for TOTP to the given time.  Contrary to"]
    #[doc = " {@code set_time(uint64_t)}, this command fails if {@code old_time}"]
    #[doc = " &gt; {@code time} or if {@code old_time} is zero (where {@code"]
    #[doc = " old_time} is the current time on the device)."]
    #[doc = ""]
    #[doc = " @param time new device time as Unix timestamp (seconds since"]
    #[doc = "        1970-01-01)"]
    #[doc = " @return command processing error code"]
    pub fn NK_totp_set_time_soft(time: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[deprecated(since = "3.4.0", note = "use `NK_totp_set_time_soft` instead")]
    pub fn NK_totp_get_time() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Change administrator PIN"]
    #[doc = " @param current_PIN char[25] current PIN"]
    #[doc = " @param new_PIN char[25] new PIN"]
    #[doc = " @return command processing error code"]
    pub fn NK_change_admin_PIN(
        current_PIN: *const ::std::os::raw::c_char,
        new_PIN: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Change user PIN"]
    #[doc = " @param current_PIN char[25] current PIN"]
    #[doc = " @param new_PIN char[25] new PIN"]
    #[doc = " @return command processing error code"]
    pub fn NK_change_user_PIN(
        current_PIN: *const ::std::os::raw::c_char,
        new_PIN: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get retry count of user PIN"]
    #[doc = " @return user PIN retry count"]
    pub fn NK_get_user_retry_count() -> u8;
}
extern "C" {
    #[doc = " Get retry count of admin PIN"]
    #[doc = " @return admin PIN retry count"]
    pub fn NK_get_admin_retry_count() -> u8;
}
extern "C" {
    #[doc = " Enable password safe access"]
    #[doc = " @param user_pin char[30] current user PIN"]
    #[doc = " @return command processing error code"]
    pub fn NK_enable_password_safe(
        user_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get password safe slots' status"]
    #[doc = " The return value must be freed using NK_free_password_safe_slot_status."]
    #[doc = " @return uint8_t[16] slot statuses - each byte represents one slot with 0 (not programmed) and 1 (programmed)"]
    pub fn NK_get_password_safe_slot_status() -> *mut u8;
}
extern "C" {
    #[doc = " Free a value returned by NK_get_password_safe_slot_status.  May be"]
    #[doc = " called with a NULL argument."]
    pub fn NK_free_password_safe_slot_status(status: *mut u8);
}
extern "C" {
    #[doc = " Get password safe slot name"]
    #[doc = " @param slot_number password safe slot number, slot_number<16"]
    #[doc = " @return slot name"]
    pub fn NK_get_password_safe_slot_name(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get password safe slot login"]
    #[doc = " @param slot_number password safe slot number, slot_number<16"]
    #[doc = " @return login from the PWS slot"]
    pub fn NK_get_password_safe_slot_login(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the password safe slot password"]
    #[doc = " @param slot_number password safe slot number, slot_number<16"]
    #[doc = " @return password from the PWS slot"]
    pub fn NK_get_password_safe_slot_password(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Write password safe data to the slot"]
    #[doc = " @param slot_number password safe slot number, slot_number<16"]
    #[doc = " @param slot_name char[11] name of the slot"]
    #[doc = " @param slot_login char[32] login string"]
    #[doc = " @param slot_password char[20] password string"]
    #[doc = " @return command processing error code"]
    pub fn NK_write_password_safe_slot(
        slot_number: u8,
        slot_name: *const ::std::os::raw::c_char,
        slot_login: *const ::std::os::raw::c_char,
        slot_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Erase the password safe slot from the device"]
    #[doc = " @param slot_number password safe slot number, slot_number<16"]
    #[doc = " @return command processing error code"]
    pub fn NK_erase_password_safe_slot(slot_number: u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Check whether AES is supported by the device"]
    #[doc = " @return 0 for no and 1 for yes"]
    pub fn NK_is_AES_supported(
        user_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get device's major firmware version"]
    #[doc = " @return major part of the version number (e.g. 0 from 0.48, 0 from 0.7 etc.)"]
    pub fn NK_get_major_firmware_version() -> u8;
}
extern "C" {
    #[doc = " Get device's minor firmware version"]
    #[doc = " @return minor part of the version number (e.g. 7 from 0.7, 48 from 0.48 etc.)"]
    pub fn NK_get_minor_firmware_version() -> u8;
}
extern "C" {
    #[doc = " Function to determine unencrypted volume PIN type"]
    #[doc = " @param minor_firmware_version"]
    #[doc = " @return Returns 1, if set unencrypted volume ro/rw pin type is User, 0 otherwise."]
    pub fn NK_set_unencrypted_volume_rorw_pin_type_user() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " This command is typically run to initiate"]
    #[doc = " communication with the device (altough not required)."]
    #[doc = " It sets time on device and returns its current status"]
    #[doc = " - a combination of set_time and get_status_storage commands"]
    #[doc = " Storage only"]
    #[doc = " @param seconds_from_epoch date and time expressed in seconds"]
    pub fn NK_send_startup(seconds_from_epoch: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Unlock encrypted volume."]
    #[doc = " Storage only"]
    #[doc = " @param user_pin user pin 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_unlock_encrypted_volume(
        user_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Locks encrypted volume"]
    #[doc = " @return command processing error code"]
    pub fn NK_lock_encrypted_volume() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Unlock hidden volume and lock encrypted volume."]
    #[doc = " Requires encrypted volume to be unlocked."]
    #[doc = " Storage only"]
    #[doc = " @param hidden_volume_password 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_unlock_hidden_volume(
        hidden_volume_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Locks hidden volume"]
    #[doc = " @return command processing error code"]
    pub fn NK_lock_hidden_volume() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create hidden volume."]
    #[doc = " Requires encrypted volume to be unlocked."]
    #[doc = " Storage only"]
    #[doc = " @param slot_nr slot number in range 0-3"]
    #[doc = " @param start_percent volume begin expressed in percent of total available storage, int in range 0-99"]
    #[doc = " @param end_percent volume end expressed in percent of total available storage, int in range 1-100"]
    #[doc = " @param hidden_volume_password 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_create_hidden_volume(
        slot_nr: u8,
        start_percent: u8,
        end_percent: u8,
        hidden_volume_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Make unencrypted volume read-only."]
    #[doc = " Device hides unencrypted volume for a second therefore make sure"]
    #[doc = " buffers are flushed before running."]
    #[doc = " Does nothing if firmware version is not matched"]
    #[doc = " Firmware range: Storage v0.50, v0.48 and below"]
    #[doc = " Storage only"]
    #[doc = " @param user_pin 20 characters User PIN"]
    #[doc = " @return command processing error code"]
    #[deprecated(
        since = "3.6.0",
        note = "use `set_unencrypted_read_only_admin` instead"
    )]
    pub fn NK_set_unencrypted_read_only(
        user_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Make unencrypted volume read-write."]
    #[doc = " Device hides unencrypted volume for a second therefore make sure"]
    #[doc = " buffers are flushed before running."]
    #[doc = " Does nothing if firmware version is not matched"]
    #[doc = " Firmware range: Storage v0.50, v0.48 and below"]
    #[doc = " Storage only"]
    #[doc = " @param user_pin 20 characters User PIN"]
    #[doc = " @return command processing error code"]
    #[deprecated(
        since = "3.6.0",
        note = "use `set_unencrypted_read_write_admin` instead"
    )]
    pub fn NK_set_unencrypted_read_write(
        user_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Make unencrypted volume read-only."]
    #[doc = " Device hides unencrypted volume for a second therefore make sure"]
    #[doc = " buffers are flushed before running."]
    #[doc = " Does nothing if firmware version is not matched"]
    #[doc = " Firmware range: Storage v0.49, v0.51+"]
    #[doc = " Storage only"]
    #[doc = " @param admin_pin 20 characters Admin PIN"]
    #[doc = " @return command processing error code"]
    pub fn NK_set_unencrypted_read_only_admin(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Make unencrypted volume read-write."]
    #[doc = " Device hides unencrypted volume for a second therefore make sure"]
    #[doc = " buffers are flushed before running."]
    #[doc = " Does nothing if firmware version is not matched"]
    #[doc = " Firmware range: Storage v0.49, v0.51+"]
    #[doc = " Storage only"]
    #[doc = " @param admin_pin 20 characters Admin PIN"]
    #[doc = " @return command processing error code"]
    pub fn NK_set_unencrypted_read_write_admin(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Make encrypted volume read-only."]
    #[doc = " Device hides encrypted volume for a second therefore make sure"]
    #[doc = " buffers are flushed before running."]
    #[doc = " Firmware range: v0.49 only, future (see firmware release notes)"]
    #[doc = " Storage only"]
    #[doc = " @param admin_pin 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_set_encrypted_read_only(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Make encrypted volume read-write."]
    #[doc = " Device hides encrypted volume for a second therefore make sure"]
    #[doc = " buffers are flushed before running."]
    #[doc = " Firmware range: v0.49 only, future (see firmware release notes)"]
    #[doc = " Storage only"]
    #[doc = " @param admin_pin 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_set_encrypted_read_write(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Exports device's firmware to unencrypted volume."]
    #[doc = " Storage only"]
    #[doc = " @param admin_pin 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_export_firmware(admin_pin: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Clear new SD card notification. It is set after factory reset."]
    #[doc = " Storage only"]
    #[doc = " @param admin_pin 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_clear_new_sd_card_warning(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Fill SD card with random data."]
    #[doc = " Should be done on first stick initialization after creating keys."]
    #[doc = " Storage only"]
    #[doc = " @param admin_pin 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_fill_SD_card_with_random_data(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Change update password."]
    #[doc = " Update password is used for entering update mode, where firmware"]
    #[doc = " could be uploaded using dfu-programmer or other means."]
    #[doc = " Storage only"]
    #[doc = " @param current_update_password 20 characters"]
    #[doc = " @param new_update_password 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_change_update_password(
        current_update_password: *const ::std::os::raw::c_char,
        new_update_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Enter update mode. Needs update password."]
    #[doc = " When device is in update mode it no longer accepts any HID commands until"]
    #[doc = " firmware is launched (regardless of being updated or not)."]
    #[doc = " Smartcard (through CCID interface) and its all volumes are not visible as well."]
    #[doc = " Its VID and PID are changed to factory-default (03eb:2ff1 Atmel Corp.)"]
    #[doc = " to be detected by flashing software. Result of this command can be reversed"]
    #[doc = " by using 'launch' command."]
    #[doc = " For dfu-programmer it would be: 'dfu-programmer at32uc3a3256s launch'."]
    #[doc = " Storage only"]
    #[doc = " @param update_password 20 characters"]
    #[doc = " @return command processing error code"]
    pub fn NK_enable_firmware_update(
        update_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get Storage stick status as string."]
    #[doc = " Storage only"]
    #[doc = " @return string with devices attributes"]
    pub fn NK_get_status_storage_as_string() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the Storage stick status and return the command processing"]
    #[doc = " error code.  If the code is zero, i. e. the command was successful,"]
    #[doc = " the storage status is written to the output pointer's target."]
    #[doc = " The output pointer must not be null."]
    #[doc = ""]
    #[doc = " @param out the output pointer for the storage status"]
    #[doc = " @return command processing error code"]
    pub fn NK_get_status_storage(out: *mut NK_storage_status) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get SD card usage attributes. Usable during hidden volumes creation."]
    #[doc = " If the command was successful (return value 0), the usage data is"]
    #[doc = " written to the output pointer\u{2019}s target.  The output pointer must"]
    #[doc = " not be null."]
    #[doc = " Storage only"]
    #[doc = " @param out the output pointer for the usage data"]
    #[doc = " @return command processing error code"]
    pub fn NK_get_SD_usage_data(out: *mut NK_SD_usage_data) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get SD card usage attributes as string."]
    #[doc = " Usable during hidden volumes creation."]
    #[doc = " Storage only"]
    #[doc = " @return string with SD card usage attributes"]
    pub fn NK_get_SD_usage_data_as_string() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get progress value of current long operation."]
    #[doc = " Storage only"]
    #[doc = " @return int in range 0-100 or -1 if device is not busy or -2 if an"]
    #[doc = "         error occured"]
    pub fn NK_get_progress_bar_value() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns a list of connected devices' id's, delimited by ';' character. Empty string is returned on no device found."]
    #[doc = " Each ID could consist of:"]
    #[doc = " 1. SC_id:SD_id_p_path (about 40 bytes)"]
    #[doc = " 2. path (about 10 bytes)"]
    #[doc = " where 'path' is USB path (bus:num), 'SC_id' is smartcard ID, 'SD_id' is storage card ID and"]
    #[doc = " '_p_' and ':' are field delimiters."]
    #[doc = " Case 2 (USB path only) is used, when the device cannot be asked about its status data (e.g. during a long operation,"]
    #[doc = " like clearing SD card."]
    #[doc = " Internally connects to all available devices and creates a map between ids and connection objects."]
    #[doc = " Side effects: changes active device to last detected Storage device."]
    #[doc = " Storage only"]
    #[doc = " @example Example of returned data: '00005d19:dacc2cb4_p_0001:0010:02;000037c7:4cf12445_p_0001:000f:02;0001:000c:02'"]
    #[doc = " @return string delimited id's of connected devices"]
    pub fn NK_list_devices_by_cpuID() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns a linked list of all connected devices, or null if no devices"]
    #[doc = " are connected or an error occured.  The linked list must be freed by"]
    #[doc = " calling NK_free_device_info."]
    #[doc = " @return a linked list of all connected devices"]
    pub fn NK_list_devices() -> *mut NK_device_info;
}
extern "C" {
    #[doc = " Free a linked list returned by NK_list_devices."]
    #[doc = " @param the linked list to free or null"]
    pub fn NK_free_device_info(device_info: *mut NK_device_info);
}
extern "C" {
    #[doc = " Connects to the device with given ID. ID's list could be created with NK_list_devices_by_cpuID."]
    #[doc = " Requires calling to NK_list_devices_by_cpuID first. Connecting to arbitrary ID/USB path is not handled."]
    #[doc = " On connection requests status from device and disconnects it / removes from map on connection failure."]
    #[doc = " Storage only"]
    #[doc = " @param id Target device ID (example: '00005d19:dacc2cb4_p_0001:0010:02')"]
    #[doc = " @return 1 on successful connection, 0 otherwise"]
    pub fn NK_connect_with_ID(id: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Connects to a device with the given path.  The path is a USB device"]
    #[doc = " path as returned by hidapi."]
    #[doc = " @param path the device path"]
    #[doc = " @return 1 on successful connection, 0 otherwise"]
    pub fn NK_connect_with_path(path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Blink red and green LED alternatively and infinitely (until device is reconnected)."]
    #[doc = " @return command processing error code"]
    pub fn NK_wink() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Enable update mode on Nitrokey Pro."]
    #[doc = " Supported from v0.11."]
    #[doc = " @param update_password 20 bytes update password"]
    #[doc = " @return command processing error code"]
    pub fn NK_enable_firmware_update_pro(
        update_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Change update-mode password on Nitrokey Pro."]
    #[doc = " Supported from v0.11."]
    #[doc = " @param current_firmware_password 20 bytes update password"]
    #[doc = " @param new_firmware_password 20 bytes update password"]
    #[doc = " @return command processing error code"]
    pub fn NK_change_firmware_password_pro(
        current_firmware_password: *const ::std::os::raw::c_char,
        new_firmware_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ReadSlot_t {
    pub slot_name: [u8; 15usize],
    pub _slot_config: u8,
    pub slot_token_id: [u8; 13usize],
    pub slot_counter: u64,
}
extern "C" {
    pub fn NK_read_HOTP_slot(slot_num: u8, out: *mut ReadSlot_t) -> ::std::os::raw::c_int;
}
