/***************************************************************************
                          route.h  -  For routing protocols packet headers
                             -------------------
    begin                : Wed Jan 30 2002
    copyright            : (C) 2002 by Josiah Zayner
    email                : phric@legions.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ROUTE_H
#define _ROUTE_H

#ifndef _NETINET_IN_H
#include <netinet/in.h>
#endif

struct rip {

  u_char comm;
  u_char vers;
  u_short none;
};

struct rip_ent {
  /* for RIP entry table */
  u_short addr_fam;
  u_short route_tag;
  struct in_addr addr;
  struct in_addr mask;
  struct in_addr nhop;
  u_int metric;

};


struct ospf {

  u_char vers;
  u_char type;
  u_short length;
  u_int router_id;
  u_int area_id;
  u_short cs;
  /*
    0 - No Authentication
    1 - Simple Password  Authentication
    2 - Cryptographic Authentication
    3-65535 - Reserved

  */
  u_short auth_type;
  char auth[8];
};


int get_rip_arg(char *arg,
                char *next_arg,
                struct rip *rip,
                struct rip_ent rip_e[25]
               );

int get_ospf_arg(char *arg, char *next_arg, struct ospf *oh);

#define S_RIP		sizeof(struct rip)
#define S_RIPE  (sizeof(struct rip) + sizeof(struct rip_ent))
#define S_OSPF  sizeof(struct ospf)

#endif /* _ROUTE_H */

