/***************************************************************************
                          ip.h  -  For IP packet header
                             -------------------
    begin                : Wed Jan 30 2002
    copyright            : (C) 2002 by Josiah Zayner
    email                : phric@legions.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _IP_H
#define _IP_H

#ifndef _NETINET_IP_H
#include <netinet/ip.h>
#endif

#define S_IP        sizeof(struct ip)
#define SOL_IP      0

int get_ip_arg(char *arg, char *next_arg, struct ip *yourp, int *opts);

/*
 For IP options
 + ++ +++++ ++++++++
|C|CL| OPT | Length |
 -------------------
Copy to frags: 0|1
Class
Option
Length
*/
/* IP options */
#define OPT_NOOP     htonl(0x01010000) /* NOOP */
#define OPT_RA       htonl(0x94040000) /* router alert */
#define OPT_TRACERO  htonl(0x520c0000) /* trace route */

struct ip_option {
		int opt;
};	


#endif /* _IP_H */

