/* intel.h

    icdprog - an open source PIC programmer for use with the Microchip ICD(1)
    Copyright (C) 2001-2004  Geir Thomassen.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/


typedef struct {
	FILE *fp;
	unsigned long adr;
	unsigned long segment;
	unsigned int checksum;
	unsigned char dat[256], *dp, *ep; /* line buffer, data pointer, end pointer */
	char mode;
} HEXFILE;

HEXFILE *open_hexfile (char *filename, char *mode);
void close_hexfile (HEXFILE * fp);
int write_hexfile (HEXFILE * fp, unsigned char data);
int read_hexfile (HEXFILE * fp, int *data, unsigned long *adr);

enum { HEX_OK = 0, HEX_EOF = -1, HEX_ERR = -2 };
