/*****************************************************************************
*                                                                            *
*  OpenNI 1.x Alpha                                                          *
*  Copyright (C) 2012 PrimeSense Ltd.                                        *
*                                                                            *
*  This file is part of OpenNI.                                              *
*                                                                            *
*  Licensed under the Apache License, Version 2.0 (the "License");           *
*  you may not use this file except in compliance with the License.          *
*  You may obtain a copy of the License at                                   *
*                                                                            *
*      http://www.apache.org/licenses/LICENSE-2.0                            *
*                                                                            *
*  Unless required by applicable law or agreed to in writing, software       *
*  distributed under the License is distributed on an "AS IS" BASIS,         *
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
*  See the License for the specific language governing permissions and       *
*  limitations under the License.                                            *
*                                                                            *
*****************************************************************************/
static JNINativeMethod methods[] = {
	{ "readByte", "(J)B", (void*)&Java_org_openni_NativeMethods_readByte },
	{ "readShort", "(J)S", (void*)&Java_org_openni_NativeMethods_readShort },
	{ "readInt", "(J)I", (void*)&Java_org_openni_NativeMethods_readInt },
	{ "readLong", "(J)J", (void*)&Java_org_openni_NativeMethods_readLong },
	{ "copyToBuffer", "(Ljava/nio/ByteBuffer;JI)V", (void*)&Java_org_openni_NativeMethods_copyToBuffer },
	{ "createProductionNodeDescription", "(ILjava/lang/String;Ljava/lang/String;BBSI)J", (void*)&Java_org_openni_NativeMethods_createProductionNodeDescription },
	{ "freeProductionNodeDescription", "(J)V", (void*)&Java_org_openni_NativeMethods_freeProductionNodeDescription },
	{ "xnGetStatusString", "(I)Ljava/lang/String;", (void*)&Java_org_openni_NativeMethods_xnGetStatusString },
	{ "xnInit", "(Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnInit },
	{ "xnContextRunXmlScriptFromFileEx", "(JLjava/lang/String;JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnContextRunXmlScriptFromFileEx },
	{ "xnContextRunXmlScriptEx", "(JLjava/lang/String;JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnContextRunXmlScriptEx },
	{ "xnInitFromXmlFileEx", "(Ljava/lang/String;Lorg/openni/OutArg;JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnInitFromXmlFileEx },
	{ "xnContextOpenFileRecordingEx", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnContextOpenFileRecordingEx },
	{ "xnContextAddRef", "(J)I", (void*)&Java_org_openni_NativeMethods_xnContextAddRef },
	{ "xnContextRelease", "(J)V", (void*)&Java_org_openni_NativeMethods_xnContextRelease },
	{ "xnEnumerateProductionTrees", "(JIJLorg/openni/OutArg;J)I", (void*)&Java_org_openni_NativeMethods_xnEnumerateProductionTrees },
	{ "xnCreateProductionTree", "(JJLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnCreateProductionTree },
	{ "xnCreateAnyProductionTree", "(JIJLorg/openni/OutArg;J)I", (void*)&Java_org_openni_NativeMethods_xnCreateAnyProductionTree },
	{ "xnEnumerateExistingNodes", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnEnumerateExistingNodes },
	{ "xnEnumerateExistingNodesByType", "(JILorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnEnumerateExistingNodesByType },
	{ "xnFindExistingRefNodeByType", "(JILorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnFindExistingRefNodeByType },
	{ "xnGetRefNodeHandleByName", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetRefNodeHandleByName },
	{ "xnWaitAndUpdateAll", "(J)I", (void*)&Java_org_openni_NativeMethods_xnWaitAndUpdateAll },
	{ "xnWaitOneUpdateAll", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnWaitOneUpdateAll },
	{ "xnWaitAnyUpdateAll", "(J)I", (void*)&Java_org_openni_NativeMethods_xnWaitAnyUpdateAll },
	{ "xnWaitNoneUpdateAll", "(J)I", (void*)&Java_org_openni_NativeMethods_xnWaitNoneUpdateAll },
	{ "xnStartGeneratingAll", "(J)I", (void*)&Java_org_openni_NativeMethods_xnStartGeneratingAll },
	{ "xnStopGeneratingAll", "(J)I", (void*)&Java_org_openni_NativeMethods_xnStopGeneratingAll },
	{ "xnSetGlobalMirror", "(JZ)I", (void*)&Java_org_openni_NativeMethods_xnSetGlobalMirror },
	{ "xnGetGlobalMirror", "(J)Z", (void*)&Java_org_openni_NativeMethods_xnGetGlobalMirror },
	{ "xnGetGlobalErrorState", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetGlobalErrorState },
	{ "xnRegisterToGlobalErrorStateChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToGlobalErrorStateChange },
	{ "xnUnregisterFromGlobalErrorStateChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromGlobalErrorStateChange },
	{ "xnRegisterToNodeCreation", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToNodeCreation },
	{ "xnUnregisterFromNodeCreation", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromNodeCreation },
	{ "xnRegisterToNodeDestruction", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToNodeDestruction },
	{ "xnUnregisterFromNodeDestruction", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromNodeDestruction },
	{ "xnAddLicense", "(JLjava/lang/String;Ljava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnAddLicense },
	{ "xnEnumerateLicenses", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnEnumerateLicenses },
	{ "xnEnumerationErrorsAllocate", "(Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnEnumerationErrorsAllocate },
	{ "xnEnumerationErrorsFree", "(J)V", (void*)&Java_org_openni_NativeMethods_xnEnumerationErrorsFree },
	{ "xnEnumerationErrorsToString", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnEnumerationErrorsToString },
	{ "xnEnumerationErrorsClear", "(J)I", (void*)&Java_org_openni_NativeMethods_xnEnumerationErrorsClear },
	{ "xnEnumerationErrorsGetFirst", "(J)J", (void*)&Java_org_openni_NativeMethods_xnEnumerationErrorsGetFirst },
	{ "xnEnumerationErrorsIteratorIsValid", "(J)Z", (void*)&Java_org_openni_NativeMethods_xnEnumerationErrorsIteratorIsValid },
	{ "xnNodeInfoSetInstanceName", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnNodeInfoSetInstanceName },
	{ "xnNodeInfoGetDescription", "(J)Lorg/openni/ProductionNodeDescription;", (void*)&Java_org_openni_NativeMethods_xnNodeInfoGetDescription },
	{ "xnNodeInfoGetTreeStringRepresentation", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnNodeInfoGetTreeStringRepresentation },
	{ "xnNodeInfoGetInstanceName", "(J)Ljava/lang/String;", (void*)&Java_org_openni_NativeMethods_xnNodeInfoGetInstanceName },
	{ "xnNodeInfoGetCreationInfo", "(J)Ljava/lang/String;", (void*)&Java_org_openni_NativeMethods_xnNodeInfoGetCreationInfo },
	{ "xnNodeInfoGetNeededNodes", "(J)J", (void*)&Java_org_openni_NativeMethods_xnNodeInfoGetNeededNodes },
	{ "xnNodeInfoGetRefHandle", "(J)J", (void*)&Java_org_openni_NativeMethods_xnNodeInfoGetRefHandle },
	{ "xnNodeInfoListAllocate", "(Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListAllocate },
	{ "xnNodeInfoListFree", "(J)V", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListFree },
	{ "xnNodeInfoListAdd", "(JJLjava/lang/String;J)I", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListAdd },
	{ "xnNodeInfoListAddNode", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListAddNode },
	{ "xnNodeInfoListAddNodeFromList", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListAddNodeFromList },
	{ "xnNodeInfoListRemove", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListRemove },
	{ "xnNodeInfoListClear", "(J)I", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListClear },
	{ "xnNodeInfoListAppend", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListAppend },
	{ "xnNodeInfoListIsEmpty", "(J)Z", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListIsEmpty },
	{ "xnNodeInfoListGetFirst", "(J)J", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListGetFirst },
	{ "xnNodeInfoListIteratorIsValid", "(J)Z", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListIteratorIsValid },
	{ "xnNodeInfoListGetCurrent", "(J)J", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListGetCurrent },
	{ "xnNodeInfoListGetNext", "(J)J", (void*)&Java_org_openni_NativeMethods_xnNodeInfoListGetNext },
	{ "xnNodeQueryAllocate", "(Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnNodeQueryAllocate },
	{ "xnNodeQueryFree", "(J)V", (void*)&Java_org_openni_NativeMethods_xnNodeQueryFree },
	{ "xnNodeQuerySetVendor", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnNodeQuerySetVendor },
	{ "xnNodeQuerySetName", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnNodeQuerySetName },
	{ "xnNodeQuerySetMinVersion", "(JBBSI)I", (void*)&Java_org_openni_NativeMethods_xnNodeQuerySetMinVersion },
	{ "xnNodeQuerySetMaxVersion", "(JBBSI)I", (void*)&Java_org_openni_NativeMethods_xnNodeQuerySetMaxVersion },
	{ "xnNodeQueryAddSupportedCapability", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnNodeQueryAddSupportedCapability },
	{ "xnNodeQueryAddSupportedMapOutputMode", "(JIII)I", (void*)&Java_org_openni_NativeMethods_xnNodeQueryAddSupportedMapOutputMode },
	{ "xnNodeQuerySetSupportedMinUserPositions", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnNodeQuerySetSupportedMinUserPositions },
	{ "xnNodeQuerySetExistingNodeOnly", "(JZ)I", (void*)&Java_org_openni_NativeMethods_xnNodeQuerySetExistingNodeOnly },
	{ "xnNodeQuerySetNonExistingNodeOnly", "(JZ)I", (void*)&Java_org_openni_NativeMethods_xnNodeQuerySetNonExistingNodeOnly },
	{ "xnNodeQueryAddNeededNode", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnNodeQueryAddNeededNode },
	{ "xnNodeQuerySetCreationInfo", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnNodeQuerySetCreationInfo },
	{ "xnNodeQueryFilterList", "(JJJ)I", (void*)&Java_org_openni_NativeMethods_xnNodeQueryFilterList },
	{ "xnProductionNodeAddRef", "(J)I", (void*)&Java_org_openni_NativeMethods_xnProductionNodeAddRef },
	{ "xnProductionNodeRelease", "(J)V", (void*)&Java_org_openni_NativeMethods_xnProductionNodeRelease },
	{ "xnGetNodeInfo", "(J)J", (void*)&Java_org_openni_NativeMethods_xnGetNodeInfo },
	{ "xnGetNodeName", "(J)Ljava/lang/String;", (void*)&Java_org_openni_NativeMethods_xnGetNodeName },
	{ "xnGetRefContextFromNodeHandle", "(J)J", (void*)&Java_org_openni_NativeMethods_xnGetRefContextFromNodeHandle },
	{ "xnIsCapabilitySupported", "(JLjava/lang/String;)Z", (void*)&Java_org_openni_NativeMethods_xnIsCapabilitySupported },
	{ "xnSetIntProperty", "(JLjava/lang/String;J)I", (void*)&Java_org_openni_NativeMethods_xnSetIntProperty },
	{ "xnSetRealProperty", "(JLjava/lang/String;D)I", (void*)&Java_org_openni_NativeMethods_xnSetRealProperty },
	{ "xnSetStringProperty", "(JLjava/lang/String;Ljava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnSetStringProperty },
	{ "xnSetGeneralProperty", "(JLjava/lang/String;IJ)I", (void*)&Java_org_openni_NativeMethods_xnSetGeneralProperty },
	{ "xnSetGeneralPropertyArray", "(JLjava/lang/String;[B)I", (void*)&Java_org_openni_NativeMethods_xnSetGeneralPropertyArray },
	{ "xnGetIntProperty", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetIntProperty },
	{ "xnGetRealProperty", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetRealProperty },
	{ "xnGetStringProperty", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetStringProperty },
	{ "xnGetGeneralProperty", "(JLjava/lang/String;IJ)I", (void*)&Java_org_openni_NativeMethods_xnGetGeneralProperty },
	{ "xnGetGeneralPropertyArray", "(JLjava/lang/String;[B)I", (void*)&Java_org_openni_NativeMethods_xnGetGeneralPropertyArray },
	{ "xnLockNodeForChanges", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnLockNodeForChanges },
	{ "xnUnlockNodeForChanges", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnUnlockNodeForChanges },
	{ "xnLockedNodeStartChanges", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnLockedNodeStartChanges },
	{ "xnLockedNodeEndChanges", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnLockedNodeEndChanges },
	{ "xnAddNeededNode", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnAddNeededNode },
	{ "xnRemoveNeededNode", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnRemoveNeededNode },
	{ "xnCreateDevice", "(JLorg/openni/OutArg;JJ)I", (void*)&Java_org_openni_NativeMethods_xnCreateDevice },
	{ "xnGetDeviceName", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetDeviceName },
	{ "xnGetVendorSpecificData", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetVendorSpecificData },
	{ "xnGetSerialNumber", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetSerialNumber },
	{ "xnGetNodeErrorState", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetNodeErrorState },
	{ "xnRegisterToNodeErrorStateChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToNodeErrorStateChange },
	{ "xnUnregisterFromNodeErrorStateChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromNodeErrorStateChange },
	{ "xnGetGeneralIntRange", "(JLjava/lang/String;Lorg/openni/OutArg;Lorg/openni/OutArg;Lorg/openni/OutArg;Lorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetGeneralIntRange },
	{ "xnGetGeneralIntValue", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetGeneralIntValue },
	{ "xnSetGeneralIntValue", "(JLjava/lang/String;I)I", (void*)&Java_org_openni_NativeMethods_xnSetGeneralIntValue },
	{ "xnRegisterToGeneralIntValueChange", "(JLjava/lang/String;Ljava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToGeneralIntValueChange },
	{ "xnUnregisterFromGeneralIntValueChange", "(JLjava/lang/String;J)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromGeneralIntValueChange },
	{ "xnStartGenerating", "(J)I", (void*)&Java_org_openni_NativeMethods_xnStartGenerating },
	{ "xnIsGenerating", "(J)Z", (void*)&Java_org_openni_NativeMethods_xnIsGenerating },
	{ "xnStopGenerating", "(J)I", (void*)&Java_org_openni_NativeMethods_xnStopGenerating },
	{ "xnRegisterToGenerationRunningChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToGenerationRunningChange },
	{ "xnUnregisterFromGenerationRunningChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromGenerationRunningChange },
	{ "xnRegisterToNewDataAvailable", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToNewDataAvailable },
	{ "xnUnregisterFromNewDataAvailable", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromNewDataAvailable },
	{ "xnIsNewDataAvailable", "(JLorg/openni/OutArg;)Z", (void*)&Java_org_openni_NativeMethods_xnIsNewDataAvailable },
	{ "xnWaitAndUpdateData", "(J)I", (void*)&Java_org_openni_NativeMethods_xnWaitAndUpdateData },
	{ "xnIsDataNew", "(J)Z", (void*)&Java_org_openni_NativeMethods_xnIsDataNew },
	{ "xnGetData", "(J)J", (void*)&Java_org_openni_NativeMethods_xnGetData },
	{ "xnGetDataSize", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetDataSize },
	{ "xnGetTimestamp", "(J)J", (void*)&Java_org_openni_NativeMethods_xnGetTimestamp },
	{ "xnGetFrameID", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetFrameID },
	{ "xnSetMirror", "(JZ)I", (void*)&Java_org_openni_NativeMethods_xnSetMirror },
	{ "xnIsMirrored", "(J)Z", (void*)&Java_org_openni_NativeMethods_xnIsMirrored },
	{ "xnRegisterToMirrorChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToMirrorChange },
	{ "xnUnregisterFromMirrorChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromMirrorChange },
	{ "xnIsViewPointSupported", "(JJ)Z", (void*)&Java_org_openni_NativeMethods_xnIsViewPointSupported },
	{ "xnSetViewPoint", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnSetViewPoint },
	{ "xnResetViewPoint", "(J)I", (void*)&Java_org_openni_NativeMethods_xnResetViewPoint },
	{ "xnIsViewPointAs", "(JJ)Z", (void*)&Java_org_openni_NativeMethods_xnIsViewPointAs },
	{ "xnRegisterToViewPointChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToViewPointChange },
	{ "xnUnregisterFromViewPointChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromViewPointChange },
	{ "xnGetPixelCoordinatesInViewPoint", "(JJIILorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetPixelCoordinatesInViewPoint },
	{ "xnCanFrameSyncWith", "(JJ)Z", (void*)&Java_org_openni_NativeMethods_xnCanFrameSyncWith },
	{ "xnFrameSyncWith", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnFrameSyncWith },
	{ "xnStopFrameSyncWith", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnStopFrameSyncWith },
	{ "xnIsFrameSyncedWith", "(JJ)Z", (void*)&Java_org_openni_NativeMethods_xnIsFrameSyncedWith },
	{ "xnRegisterToFrameSyncChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToFrameSyncChange },
	{ "xnUnregisterFromFrameSyncChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromFrameSyncChange },
	{ "xnGetSupportedMapOutputModesCount", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetSupportedMapOutputModesCount },
	{ "xnGetSupportedMapOutputModes", "(J[Lorg/openni/MapOutputMode;)I", (void*)&Java_org_openni_NativeMethods_xnGetSupportedMapOutputModes },
	{ "xnSetMapOutputMode", "(JIII)I", (void*)&Java_org_openni_NativeMethods_xnSetMapOutputMode },
	{ "xnGetMapOutputMode", "(JLorg/openni/OutArg;Lorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetMapOutputMode },
	{ "xnRegisterToMapOutputModeChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToMapOutputModeChange },
	{ "xnUnregisterFromMapOutputModeChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromMapOutputModeChange },
	{ "xnGetBytesPerPixel", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetBytesPerPixel },
	{ "xnSetCropping", "(JIIIIZ)I", (void*)&Java_org_openni_NativeMethods_xnSetCropping },
	{ "xnGetCropping", "(JLorg/openni/OutArg;Lorg/openni/OutArg;Lorg/openni/OutArg;Lorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetCropping },
	{ "xnRegisterToCroppingChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToCroppingChange },
	{ "xnUnregisterFromCroppingChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromCroppingChange },
	{ "xnSetPowerLineFrequency", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnSetPowerLineFrequency },
	{ "xnGetPowerLineFrequency", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetPowerLineFrequency },
	{ "xnRegisterToPowerLineFrequencyChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToPowerLineFrequencyChange },
	{ "xnUnregisterFromPowerLineFrequencyChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromPowerLineFrequencyChange },
	{ "xnCreateDepthGenerator", "(JLorg/openni/OutArg;JJ)I", (void*)&Java_org_openni_NativeMethods_xnCreateDepthGenerator },
	{ "xnGetDeviceMaxDepth", "(J)S", (void*)&Java_org_openni_NativeMethods_xnGetDeviceMaxDepth },
	{ "xnGetDepthFieldOfView", "(JLorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetDepthFieldOfView },
	{ "xnRegisterToDepthFieldOfViewChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToDepthFieldOfViewChange },
	{ "xnUnregisterFromDepthFieldOfViewChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromDepthFieldOfViewChange },
	{ "xnConvertProjectiveToRealWorld", "(J[Lorg/openni/Point3D;[Lorg/openni/Point3D;)I", (void*)&Java_org_openni_NativeMethods_xnConvertProjectiveToRealWorld },
	{ "xnConvertRealWorldToProjective", "(J[Lorg/openni/Point3D;[Lorg/openni/Point3D;)I", (void*)&Java_org_openni_NativeMethods_xnConvertRealWorldToProjective },
	{ "xnGetDepthMap", "(J)J", (void*)&Java_org_openni_NativeMethods_xnGetDepthMap },
	{ "xnGetDepthMetaData", "(JLorg/openni/DepthMetaData;)V", (void*)&Java_org_openni_NativeMethods_xnGetDepthMetaData },
	{ "xnGetSupportedUserPositionsCount", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetSupportedUserPositionsCount },
	{ "xnSetUserPosition", "(JIFFFFFF)I", (void*)&Java_org_openni_NativeMethods_xnSetUserPosition },
	{ "xnGetUserPosition", "(JILorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetUserPosition },
	{ "xnRegisterToUserPositionChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToUserPositionChange },
	{ "xnUnregisterFromUserPositionChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromUserPositionChange },
	{ "xnCreateImageGenerator", "(JLorg/openni/OutArg;JJ)I", (void*)&Java_org_openni_NativeMethods_xnCreateImageGenerator },
	{ "xnGetImageMap", "(J)J", (void*)&Java_org_openni_NativeMethods_xnGetImageMap },
	{ "xnIsPixelFormatSupported", "(JI)Z", (void*)&Java_org_openni_NativeMethods_xnIsPixelFormatSupported },
	{ "xnSetPixelFormat", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnSetPixelFormat },
	{ "xnGetPixelFormat", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetPixelFormat },
	{ "xnRegisterToPixelFormatChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToPixelFormatChange },
	{ "xnUnregisterFromPixelFormatChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromPixelFormatChange },
	{ "xnGetImageMetaData", "(JLorg/openni/ImageMetaData;)V", (void*)&Java_org_openni_NativeMethods_xnGetImageMetaData },
	{ "xnCreateIRGenerator", "(JLorg/openni/OutArg;JJ)I", (void*)&Java_org_openni_NativeMethods_xnCreateIRGenerator },
	{ "xnGetIRMap", "(J)J", (void*)&Java_org_openni_NativeMethods_xnGetIRMap },
	{ "xnGetIRMetaData", "(JLorg/openni/IRMetaData;)V", (void*)&Java_org_openni_NativeMethods_xnGetIRMetaData },
	{ "xnCreateGestureGenerator", "(JLorg/openni/OutArg;JJ)I", (void*)&Java_org_openni_NativeMethods_xnCreateGestureGenerator },
	{ "xnAddGesture", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnAddGesture__JLjava_lang_String_2 },
	{ "xnAddGesture", "(JLjava/lang/String;FFFFFF)I", (void*)&Java_org_openni_NativeMethods_xnAddGesture__JLjava_lang_String_2FFFFFF },
	{ "xnRemoveGesture", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnRemoveGesture },
	{ "xnGetAllActiveGestures", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetAllActiveGestures },
	{ "xnGetNumberOfAvailableGestures", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetNumberOfAvailableGestures },
	{ "xnEnumerateAllGestures", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnEnumerateAllGestures },
	{ "xnIsGestureAvailable", "(JLjava/lang/String;)Z", (void*)&Java_org_openni_NativeMethods_xnIsGestureAvailable },
	{ "xnIsGestureProgressSupported", "(JLjava/lang/String;)Z", (void*)&Java_org_openni_NativeMethods_xnIsGestureProgressSupported },
	{ "xnRegisterGestureCallbacks", "(JLjava/lang/Object;Ljava/lang/String;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterGestureCallbacks },
	{ "xnUnregisterGestureCallbacks", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterGestureCallbacks },
	{ "xnRegisterToGestureChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToGestureChange },
	{ "xnUnregisterFromGestureChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromGestureChange },
	{ "xnRegisterToGestureIntermediateStageCompleted", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToGestureIntermediateStageCompleted },
	{ "xnUnregisterFromGestureIntermediateStageCompleted", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromGestureIntermediateStageCompleted },
	{ "xnRegisterToGestureReadyForNextIntermediateStage", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToGestureReadyForNextIntermediateStage },
	{ "xnUnregisterFromGestureReadyForNextIntermediateStage", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromGestureReadyForNextIntermediateStage },
	{ "xnCreateSceneAnalyzer", "(JLorg/openni/OutArg;JJ)I", (void*)&Java_org_openni_NativeMethods_xnCreateSceneAnalyzer },
	{ "xnGetLabelMap", "(J)J", (void*)&Java_org_openni_NativeMethods_xnGetLabelMap },
	{ "xnGetFloor", "(JLorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetFloor },
	{ "xnGetSceneMetaData", "(JLorg/openni/SceneMetaData;)V", (void*)&Java_org_openni_NativeMethods_xnGetSceneMetaData },
	{ "xnCreateUserGenerator", "(JLorg/openni/OutArg;JJ)I", (void*)&Java_org_openni_NativeMethods_xnCreateUserGenerator },
	{ "xnGetNumberOfUsers", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetNumberOfUsers },
	{ "xnGetUsers", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetUsers },
	{ "xnGetUserCoM", "(JILorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetUserCoM },
	{ "xnGetUserPixels", "(JILorg/openni/SceneMetaData;)I", (void*)&Java_org_openni_NativeMethods_xnGetUserPixels },
	{ "xnRegisterUserCallbacks", "(JLjava/lang/Object;Ljava/lang/String;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterUserCallbacks },
	{ "xnUnregisterUserCallbacks", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterUserCallbacks },
	{ "xnRegisterToUserExit", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToUserExit },
	{ "xnUnregisterFromUserExit", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromUserExit },
	{ "xnRegisterToUserReEnter", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToUserReEnter },
	{ "xnUnregisterFromUserReEnter", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromUserReEnter },
	{ "xnIsJointAvailable", "(JI)Z", (void*)&Java_org_openni_NativeMethods_xnIsJointAvailable },
	{ "xnIsProfileAvailable", "(JI)Z", (void*)&Java_org_openni_NativeMethods_xnIsProfileAvailable },
	{ "xnSetSkeletonProfile", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnSetSkeletonProfile },
	{ "xnSetJointActive", "(JIZ)I", (void*)&Java_org_openni_NativeMethods_xnSetJointActive },
	{ "xnIsJointActive", "(JI)Z", (void*)&Java_org_openni_NativeMethods_xnIsJointActive },
	{ "xnRegisterToJointConfigurationChange", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToJointConfigurationChange },
	{ "xnUnregisterFromJointConfigurationChange", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromJointConfigurationChange },
	{ "xnEnumerateActiveJoints", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnEnumerateActiveJoints },
	{ "xnGetSkeletonJoint", "(JIILorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetSkeletonJoint },
	{ "xnGetSkeletonJointPosition", "(JIILorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetSkeletonJointPosition },
	{ "xnGetSkeletonJointOrientation", "(JIILorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetSkeletonJointOrientation },
	{ "xnIsSkeletonTracking", "(JI)Z", (void*)&Java_org_openni_NativeMethods_xnIsSkeletonTracking },
	{ "xnIsSkeletonCalibrated", "(JI)Z", (void*)&Java_org_openni_NativeMethods_xnIsSkeletonCalibrated },
	{ "xnIsSkeletonCalibrating", "(JI)Z", (void*)&Java_org_openni_NativeMethods_xnIsSkeletonCalibrating },
	{ "xnRequestSkeletonCalibration", "(JIZ)I", (void*)&Java_org_openni_NativeMethods_xnRequestSkeletonCalibration },
	{ "xnAbortSkeletonCalibration", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnAbortSkeletonCalibration },
	{ "xnSaveSkeletonCalibrationDataToFile", "(JILjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnSaveSkeletonCalibrationDataToFile },
	{ "xnLoadSkeletonCalibrationDataFromFile", "(JILjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnLoadSkeletonCalibrationDataFromFile },
	{ "xnSaveSkeletonCalibrationData", "(JII)I", (void*)&Java_org_openni_NativeMethods_xnSaveSkeletonCalibrationData },
	{ "xnLoadSkeletonCalibrationData", "(JII)I", (void*)&Java_org_openni_NativeMethods_xnLoadSkeletonCalibrationData },
	{ "xnClearSkeletonCalibrationData", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnClearSkeletonCalibrationData },
	{ "xnIsSkeletonCalibrationData", "(JI)Z", (void*)&Java_org_openni_NativeMethods_xnIsSkeletonCalibrationData },
	{ "xnStartSkeletonTracking", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnStartSkeletonTracking },
	{ "xnStopSkeletonTracking", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnStopSkeletonTracking },
	{ "xnResetSkeleton", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnResetSkeleton },
	{ "xnNeedPoseForSkeletonCalibration", "(J)Z", (void*)&Java_org_openni_NativeMethods_xnNeedPoseForSkeletonCalibration },
	{ "xnGetSkeletonCalibrationPose", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetSkeletonCalibrationPose },
	{ "xnSetSkeletonSmoothing", "(JF)I", (void*)&Java_org_openni_NativeMethods_xnSetSkeletonSmoothing },
	{ "xnRegisterToCalibrationStart", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToCalibrationStart },
	{ "xnUnregisterFromCalibrationStart", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromCalibrationStart },
	{ "xnRegisterToCalibrationInProgress", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToCalibrationInProgress },
	{ "xnUnregisterFromCalibrationInProgress", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromCalibrationInProgress },
	{ "xnRegisterToCalibrationComplete", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToCalibrationComplete },
	{ "xnUnregisterFromCalibrationComplete", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromCalibrationComplete },
	{ "xnGetNumberOfPoses", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetNumberOfPoses },
	{ "xnGetAllAvailablePoses", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetAllAvailablePoses },
	{ "xnStartPoseDetection", "(JLjava/lang/String;I)I", (void*)&Java_org_openni_NativeMethods_xnStartPoseDetection },
	{ "xnStopPoseDetection", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnStopPoseDetection },
	{ "xnStopSinglePoseDetection", "(JILjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnStopSinglePoseDetection },
	{ "xnRegisterToPoseDetected", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToPoseDetected },
	{ "xnUnregisterFromPoseDetected", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromPoseDetected },
	{ "xnRegisterToOutOfPose", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToOutOfPose },
	{ "xnUnregisterFromOutOfPose", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromOutOfPose },
	{ "xnRegisterToPoseDetectionInProgress", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToPoseDetectionInProgress },
	{ "xnUnregisterFromPoseDetectionInProgress", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromPoseDetectionInProgress },
	{ "xnIsPoseSupported", "(JLjava/lang/String;)Z", (void*)&Java_org_openni_NativeMethods_xnIsPoseSupported },
	{ "xnGetPoseStatus", "(JILjava/lang/String;Lorg/openni/OutArg;Lorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetPoseStatus },
	{ "xnCreateHandsGenerator", "(JLorg/openni/OutArg;JJ)I", (void*)&Java_org_openni_NativeMethods_xnCreateHandsGenerator },
	{ "xnRegisterHandCallbacks", "(JLjava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterHandCallbacks },
	{ "xnUnregisterHandCallbacks", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterHandCallbacks },
	{ "xnStopTracking", "(JI)I", (void*)&Java_org_openni_NativeMethods_xnStopTracking },
	{ "xnStopTrackingAll", "(J)I", (void*)&Java_org_openni_NativeMethods_xnStopTrackingAll },
	{ "xnStartTracking", "(JFFF)I", (void*)&Java_org_openni_NativeMethods_xnStartTracking },
	{ "xnSetTrackingSmoothing", "(JF)I", (void*)&Java_org_openni_NativeMethods_xnSetTrackingSmoothing },
	{ "xnRegisterToHandTouchingFOVEdge", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToHandTouchingFOVEdge },
	{ "xnUnregisterFromHandTouchingFOVEdge", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromHandTouchingFOVEdge },
	{ "xnCreateAudioGenerator", "(JLorg/openni/OutArg;JJ)I", (void*)&Java_org_openni_NativeMethods_xnCreateAudioGenerator },
	{ "xnGetAudioBuffer", "(J)J", (void*)&Java_org_openni_NativeMethods_xnGetAudioBuffer },
	{ "xnGetSupportedWaveOutputModesCount", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetSupportedWaveOutputModesCount },
	{ "xnGetSupportedWaveOutputModes", "(J[Lorg/openni/WaveOutputMode;)I", (void*)&Java_org_openni_NativeMethods_xnGetSupportedWaveOutputModes },
	{ "xnSetWaveOutputMode", "(JISB)I", (void*)&Java_org_openni_NativeMethods_xnSetWaveOutputMode },
	{ "xnGetWaveOutputMode", "(JLorg/openni/OutArg;Lorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetWaveOutputMode },
	{ "xnRegisterToWaveOutputModeChanges", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToWaveOutputModeChanges },
	{ "xnUnregisterFromWaveOutputModeChanges", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromWaveOutputModeChanges },
	{ "xnGetAudioMetaData", "(JLorg/openni/AudioMetaData;)V", (void*)&Java_org_openni_NativeMethods_xnGetAudioMetaData },
	{ "xnCreateCodec", "(JIJLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnCreateCodec },
	{ "xnGetCodecID", "(J)I", (void*)&Java_org_openni_NativeMethods_xnGetCodecID },
	{ "xnEncodeData", "(JJIJILorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnEncodeData },
	{ "xnDecodeData", "(JJIJILorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnDecodeData },
	{ "xnCreateRecorder", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnCreateRecorder },
	{ "xnSetRecorderDestination", "(JILjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnSetRecorderDestination },
	{ "xnGetRecorderDestination", "(JLorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetRecorderDestination },
	{ "xnAddNodeToRecording", "(JJI)I", (void*)&Java_org_openni_NativeMethods_xnAddNodeToRecording },
	{ "xnRemoveNodeFromRecording", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnRemoveNodeFromRecording },
	{ "xnRecord", "(J)I", (void*)&Java_org_openni_NativeMethods_xnRecord },
	{ "xnGetRecorderFormat", "(J)Ljava/lang/String;", (void*)&Java_org_openni_NativeMethods_xnGetRecorderFormat },
	{ "xnCreatePlayer", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnCreatePlayer },
	{ "xnSetPlayerRepeat", "(JZ)I", (void*)&Java_org_openni_NativeMethods_xnSetPlayerRepeat },
	{ "xnSetPlayerSource", "(JILjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnSetPlayerSource },
	{ "xnGetPlayerSource", "(JLorg/openni/OutArg;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetPlayerSource },
	{ "xnPlayerReadNext", "(J)I", (void*)&Java_org_openni_NativeMethods_xnPlayerReadNext },
	{ "xnSeekPlayerToTimeStamp", "(JJI)I", (void*)&Java_org_openni_NativeMethods_xnSeekPlayerToTimeStamp },
	{ "xnSeekPlayerToFrame", "(JLjava/lang/String;II)I", (void*)&Java_org_openni_NativeMethods_xnSeekPlayerToFrame },
	{ "xnTellPlayerTimestamp", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnTellPlayerTimestamp },
	{ "xnTellPlayerFrame", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnTellPlayerFrame },
	{ "xnGetPlayerNumFrames", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetPlayerNumFrames },
	{ "xnGetPlayerSupportedFormat", "(J)Ljava/lang/String;", (void*)&Java_org_openni_NativeMethods_xnGetPlayerSupportedFormat },
	{ "xnEnumeratePlayerNodes", "(JLorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnEnumeratePlayerNodes },
	{ "xnIsPlayerAtEOF", "(J)Z", (void*)&Java_org_openni_NativeMethods_xnIsPlayerAtEOF },
	{ "xnRegisterToEndOfFileReached", "(JLjava/lang/Object;Ljava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnRegisterToEndOfFileReached },
	{ "xnUnregisterFromEndOfFileReached", "(JJ)V", (void*)&Java_org_openni_NativeMethods_xnUnregisterFromEndOfFileReached },
	{ "xnSetPlaybackSpeed", "(JD)I", (void*)&Java_org_openni_NativeMethods_xnSetPlaybackSpeed },
	{ "xnGetPlaybackSpeed", "(J)D", (void*)&Java_org_openni_NativeMethods_xnGetPlaybackSpeed },
	{ "xnCreateScriptNode", "(JLjava/lang/String;Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnCreateScriptNode },
	{ "xnScriptNodeGetSupportedFormat", "(J)Ljava/lang/String;", (void*)&Java_org_openni_NativeMethods_xnScriptNodeGetSupportedFormat },
	{ "xnLoadScriptFromFile", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnLoadScriptFromFile },
	{ "xnLoadScriptFromString", "(JLjava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnLoadScriptFromString },
	{ "xnScriptNodeRun", "(JJ)I", (void*)&Java_org_openni_NativeMethods_xnScriptNodeRun },
	{ "xnProductionNodeTypeToString", "(I)Ljava/lang/String;", (void*)&Java_org_openni_NativeMethods_xnProductionNodeTypeToString },
	{ "xnResolutionGetXRes", "(I)I", (void*)&Java_org_openni_NativeMethods_xnResolutionGetXRes },
	{ "xnResolutionGetYRes", "(I)I", (void*)&Java_org_openni_NativeMethods_xnResolutionGetYRes },
	{ "xnResolutionGetFromXYRes", "(II)I", (void*)&Java_org_openni_NativeMethods_xnResolutionGetFromXYRes },
	{ "xnResolutionGetFromName", "(Ljava/lang/String;)I", (void*)&Java_org_openni_NativeMethods_xnResolutionGetFromName },
	{ "xnResolutionGetName", "(I)Ljava/lang/String;", (void*)&Java_org_openni_NativeMethods_xnResolutionGetName },
	{ "xnGetVersion", "(Lorg/openni/OutArg;)I", (void*)&Java_org_openni_NativeMethods_xnGetVersion },
	{ "xnIsTypeGenerator", "(I)Z", (void*)&Java_org_openni_NativeMethods_xnIsTypeGenerator },
	{ "xnIsTypeDerivedFrom", "(II)Z", (void*)&Java_org_openni_NativeMethods_xnIsTypeDerivedFrom },
	{ "xnGetBytesPerPixelForPixelFormat", "(I)I", (void*)&Java_org_openni_NativeMethods_xnGetBytesPerPixelForPixelFormat },
};
