//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cParticleEmitter.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cParticleEmitter_hpp
#define cParticleEmitter_hpp
//==============================================================================
// Includes
#include "cPositionable.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================

//! Object that emits particles
class cParticleEmitter : virtual public cPositionable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cParticleEmitter (void);
		//! Destructor
		virtual ~cParticleEmitter (void);
	
	// Public methods
	public:
		//! Set emitting distance
		void SetEmittingDistance (float distance) { mDistance = distance; };	
		//! Return emitting distance
		float GetEmittingDistance (void) const { return mDistance; };
		//! Set emitting angle
		void SetEmittingAngle (float angle) { mAngle = angle; };
		//! Get emitting angle
		float GetEmittingAngle (void) const { return mAngle; };
		
		//! Return emitting position
		cVector2f GetEmittingPosition (void) const
		{
			cVector2f position = GetPosition ();
			position += GetDirection (mAngle) * mDistance;
			return position;
		};
		//! Return emitting direction
		cVector2f GetEmittingDirection (float angleVar) const
		{
			return GetDirection (angleVar);
		}
	
	// Member variables
	private:
		float mDistance;	//!< Emitting distance
		float mAngle;		//!< Emitting angle
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cParticleEmitter_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
