//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// experimental_microdosimetry.cc
// Authors: Susanna Guatelli and Francesco Romano
// susanna@uow.edu.au, francesco.romano@ct.infn.it

#include "G4RunManager.hh"
#include "DetectorConstruction.hh"
#include "PhysicsList.hh"
#include "G4UImanager.hh"
#include "G4VisExecutive.hh"
#include "G4RunManagerFactory.hh"
#include "AnalysisManager.hh"
#include "ActionInitialization.hh"
#include "AnalysisManager.hh"
#include "G4UIExecutive.hh"

#include "DetectorMessenger.hh"
#include "AnalysisMessenger.hh"

int main(int argc, char** argv)
{

  auto* pRunManager = G4RunManagerFactory::CreateRunManager();
  G4int nThreads = 4;
  pRunManager->SetNumberOfThreads(nThreads);
  
  AnalysisMessenger* anMess = new AnalysisMessenger();
  AnalysisManager* analysis = new AnalysisManager(anMess);
  
  // Construct geometry
  
  DetectorMessenger* detMess = new DetectorMessenger(analysis);
  DetectorConstruction* detector = new DetectorConstruction(analysis, detMess);  
    
  pRunManager -> SetUserInitialization(detector);

  G4VUserPhysicsList* physics = new PhysicsList();
  
  pRunManager -> SetUserInitialization(physics); 

   // User action initialization  

  ActionInitialization* actions = new ActionInitialization(analysis, detMess);
  pRunManager->SetUserInitialization(actions);

  G4VisManager* visManager = new G4VisExecutive();
  visManager->Initialize();
 
  // Get the pointer to the User Interface manager
  //
  G4UImanager* UImanager = G4UImanager::GetUIpointer();

  if(argc == 1){

    /*this sets up the user interface to run in interactive mode */
    G4UIExecutive* ui = new G4UIExecutive(argc, argv); 
    G4cout << " UI session starts ..." << G4endl;
    UImanager -> ApplyCommand("/control/execute vis.mac");
    //now, we run in interactive mode so tell the UI manager to read the vis.mac macro file and 
    //UI->ApplyCommand("/control/execute vis.mac"); 
    ui -> SessionStart();
    delete ui;

  } else { 
    //otherwise we run in batch mode
    G4String command = "/control/execute ";//create first part of command
    G4String fileName = argv[1];//second part is the file name that was typed at the command line 
    UImanager->ApplyCommand(command+fileName);//join the two and pass to the UI manager for interpretation
  }

  delete visManager;
  delete analysis; 
  delete pRunManager;
  delete detMess;
  delete anMess;
  
  return 0;
}
