/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;

public class FloatingPointContentCommand
extends TextualContentCommand
implements TeXNumber {
    protected boolean isConstant = false;

    public FloatingPointContentCommand(String string, double d) {
        this(string, d, false);
    }

    public FloatingPointContentCommand(String string, double d, boolean bl) {
        this(string, "" + d, new TeXFloatingPoint(d), bl);
    }

    protected FloatingPointContentCommand(String string, String string2, TeXFloatingPoint teXFloatingPoint) {
        this(string, string2, teXFloatingPoint, false);
    }

    protected FloatingPointContentCommand(String string, String string2, TeXFloatingPoint teXFloatingPoint, boolean bl) {
        super(string, string2, teXFloatingPoint);
        this.isConstant = bl;
    }

    @Override
    public Object clone() {
        return this.isConstant ? this : new FloatingPointContentCommand(this.getName(), this.getText(), (TeXFloatingPoint)this.getNumber().clone());
    }

    @Override
    public TextualContentCommand duplicate(String string) {
        return new FloatingPointContentCommand(string, this.getText(), new TeXFloatingPoint(this.getValue()), false);
    }

    @Override
    public int getValue() {
        return this.getNumber().getValue();
    }

    @Override
    public double doubleValue() {
        return this.getNumber().doubleValue();
    }

    public void setValue(int n) {
        this.setValue((double)n);
    }

    public void setValue(double d) {
        if (!this.isConstant) {
            this.text = "" + d;
            this.getNumber().setValue(d);
        }
    }

    public TeXFloatingPoint getNumber() {
        return (TeXFloatingPoint)this.data;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.getNumber().number(teXParser);
    }

    @Override
    public void multiply(int n) {
        if (!this.isConstant) {
            this.getNumber().multiply(n);
            this.text = "" + this.getValue();
        }
    }

    @Override
    public void divide(int n) {
        if (!this.isConstant) {
            this.getNumber().divide(n);
            this.text = "" + this.getValue();
        }
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (this.isConstant) {
            throw new TeXSyntaxException(teXParser, "tex.error.cant_change_const", this.toString(teXParser));
        }
        this.getNumber().advance(teXParser, numerical);
        this.text = "" + this.getValue();
    }
}

