#!/bin/sh

rm -rf autom4te.cache
rm -f config.cache
rm -f configure.ac configure

# it doesn't make any difference whether we pass configure-gtk2.ac or
# configure-gtk3.ac to aclocal, automake and autoheader (the minor
# differences between them don't affect the output of those tools),
# but we will copy configure-gtk2.ac to configure.ac so any unqualifed
# calls to autoconf do the right thing
cp configure-gtk2.ac configure.ac
aclocal -I m4
libtoolize
autoheader
automake --add-missing
autoconf -o configure-gtk2

# make configure-gtk2 the default if the user calls 'configure'
cp configure-gtk2 configure

cd po
for lang in `cat LINGUAS`; do msgfmt $lang.po; mv messages.mo $lang.gmo; done
cd ..

./configure $@
