/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HUSLColorConverter;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuvColorSpace;
import com.github.ajalt.colormath.model.LCHuvColorSpaces;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.LUVKt;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0000H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020)H\u00d6\u0001J\b\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/github/ajalt/colormath/model/LCHuv;", "Lcom/github/ajalt/colormath/HueColor;", "l", "", "c", "h", "alpha", "space", "Lcom/github/ajalt/colormath/model/LCHuvColorSpace;", "(FFFFLcom/github/ajalt/colormath/model/LCHuvColorSpace;)V", "getAlpha", "()F", "getC", "getH", "getL", "getSpace", "()Lcom/github/ajalt/colormath/model/LCHuvColorSpace;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "", "toHPLuv", "Lcom/github/ajalt/colormath/model/HPLuv;", "toHSLuv", "Lcom/github/ajalt/colormath/model/HSLuv;", "toLCHuv", "toLUV", "Lcom/github/ajalt/colormath/model/LUV;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nLCHuv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LCHuv.kt\ncom/github/ajalt/colormath/model/LCHuv\n+ 2 InternalMath.kt\ncom/github/ajalt/colormath/internal/InternalMathKt\n*L\n1#1,84:1\n37#2,4:85\n*S KotlinDebug\n*F\n+ 1 LCHuv.kt\ncom/github/ajalt/colormath/model/LCHuv\n*L\n80#1:85,4\n*E\n"})
public final class LCHuv
implements HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float l;
    private final float c;
    private final float h;
    private final float alpha;
    @NotNull
    private final LCHuvColorSpace space;

    public LCHuv(float l, float c, float h, float alpha, @NotNull LCHuvColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        this.l = l;
        this.c = c;
        this.h = h;
        this.alpha = alpha;
        this.space = space;
    }

    public final float getL() {
        return this.l;
    }

    public final float getC() {
        return this.c;
    }

    @Override
    public float getH() {
        return this.h;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @NotNull
    public LCHuvColorSpace getSpace() {
        return this.space;
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        if ((double)this.l > 99.9999) {
            return new HSLuv(this.getH(), 0.0f, 100.0f, this.getAlpha());
        }
        if ((double)this.l < 1.0E-5) {
            return new HSLuv(this.getH(), 0.0f, 0.0f, this.getAlpha());
        }
        double max2 = HUSLColorConverter.INSTANCE.maxChromaForLH(this.l, this.getH());
        double s = (double)this.c / max2 * (double)100;
        return new HSLuv(this.getH(), (float)s, this.l, this.getAlpha());
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        if ((double)this.l > 99.9999) {
            return new HPLuv(this.getH(), 0.0f, 100.0f, this.getAlpha());
        }
        if ((double)this.l < 1.0E-5) {
            return new HPLuv(this.getH(), 0.0f, 0.0f, this.getAlpha());
        }
        double max2 = HUSLColorConverter.INSTANCE.maxSafeChromaForL(this.l);
        double s = (double)this.c / max2 * (double)100;
        return new HPLuv(this.getH(), (float)s, this.l, this.getAlpha());
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.toLUV().toSRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return this.toLUV().toXYZ();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LUV toLUV() {
        void v;
        void b$iv;
        void c$iv;
        float f = this.c;
        float h$iv = this.getH();
        boolean $i$f$fromPolarModel = false;
        float hDegrees$iv = Float.isNaN(h$iv) ? 0.0f : InternalMathKt.degToRad(h$iv);
        void a$iv = c$iv * (float)Math.cos(hDegrees$iv);
        void var7_7 = b$iv = c$iv * (float)Math.sin(hDegrees$iv);
        void u = a$iv;
        boolean bl = false;
        return LUVKt.LUVColorSpace(this.getSpace().getWhitePoint()).invoke(this.l, (float)u, (float)v, this.getAlpha());
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.l, this.c, this.getH(), this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return HueColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return HueColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return HueColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return HueColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return HueColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return HueColor.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return HueColor.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return HueColor.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return HueColor.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return HueColor.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return HueColor.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return HueColor.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return HueColor.DefaultImpls.toICtCp(this);
    }

    public final float component1() {
        return this.l;
    }

    public final float component2() {
        return this.c;
    }

    public final float component3() {
        return this.h;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final LCHuvColorSpace component5() {
        return this.space;
    }

    @NotNull
    public final LCHuv copy(float l, float c, float h, float alpha, @NotNull LCHuvColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        return new LCHuv(l, c, h, alpha, space);
    }

    public static /* synthetic */ LCHuv copy$default(LCHuv lCHuv, float f, float f2, float f3, float f4, LCHuvColorSpace lCHuvColorSpace, int n, Object object) {
        if ((n & 1) != 0) {
            f = lCHuv.l;
        }
        if ((n & 2) != 0) {
            f2 = lCHuv.c;
        }
        if ((n & 4) != 0) {
            f3 = lCHuv.h;
        }
        if ((n & 8) != 0) {
            f4 = lCHuv.alpha;
        }
        if ((n & 0x10) != 0) {
            lCHuvColorSpace = lCHuv.space;
        }
        return lCHuv.copy(f, f2, f3, f4, lCHuvColorSpace);
    }

    @NotNull
    public String toString() {
        return "LCHuv(l=" + this.l + ", c=" + this.c + ", h=" + this.h + ", alpha=" + this.alpha + ", space=" + this.space + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.l);
        result2 = result2 * 31 + Float.hashCode(this.c);
        result2 = result2 * 31 + Float.hashCode(this.h);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        result2 = result2 * 31 + this.space.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LCHuv)) {
            return false;
        }
        LCHuv lCHuv = (LCHuv)other;
        if (Float.compare(this.l, lCHuv.l) != 0) {
            return false;
        }
        if (Float.compare(this.c, lCHuv.c) != 0) {
            return false;
        }
        if (Float.compare(this.h, lCHuv.h) != 0) {
            return false;
        }
        if (Float.compare(this.alpha, lCHuv.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.space, lCHuv.space);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0011\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0015H\u0096\u0001J+\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u0018H\u0096\u0003J+\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001c2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0096\u0003R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/github/ajalt/colormath/model/LCHuv$Companion;", "Lcom/github/ajalt/colormath/model/LCHuvColorSpace;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "convert", "Lcom/github/ajalt/colormath/model/LCHuv;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "invoke", "l", "", "c", "h", "alpha", "", "colormath"})
    public static final class Companion
    implements LCHuvColorSpace {
        private final /* synthetic */ LCHuvColorSpace $$delegate_0;

        private Companion() {
            this.$$delegate_0 = LCHuvColorSpaces.INSTANCE.getLCHuv65();
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return this.$$delegate_0.getComponents();
        }

        @Override
        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        @Override
        @NotNull
        public WhitePoint getWhitePoint() {
            return this.$$delegate_0.getWhitePoint();
        }

        @Override
        @NotNull
        public LCHuv convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return (LCHuv)this.$$delegate_0.convert(color);
        }

        @Override
        @NotNull
        public LCHuv create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter(components, "components");
            return (LCHuv)this.$$delegate_0.create(components);
        }

        @Override
        @NotNull
        public LCHuv invoke(float l, float c, float h, float alpha) {
            return this.$$delegate_0.invoke(l, c, h, alpha);
        }

        @Override
        @NotNull
        public LCHuv invoke(@NotNull Number l, @NotNull Number c, @NotNull Number h, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter(l, "l");
            Intrinsics.checkNotNullParameter(c, "c");
            Intrinsics.checkNotNullParameter(h, "h");
            Intrinsics.checkNotNullParameter(alpha, "alpha");
            return this.$$delegate_0.invoke(l, c, h, alpha);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

