/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.PropertyField;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.MapGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.MapSetter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;

class BeanMapPropertyField<M, K, V, T extends ObservableMap<K, V>, R extends Property<T>>
implements PropertyField<T, M, R> {
    private final MapGetter<M, K, V> getter;
    private final MapSetter<M, K, V> setter;
    private Map<K, V> defaultValue;
    private final MapProperty<K, V> targetProperty;

    BeanMapPropertyField(SideEffect updateFunction, MapGetter<M, K, V> getter, MapSetter<M, K, V> setter, Supplier<MapProperty<K, V>> propertySupplier) {
        this(updateFunction, getter, setter, propertySupplier, Collections.emptyMap());
    }

    BeanMapPropertyField(SideEffect updateFunction, MapGetter<M, K, V> getter, MapSetter<M, K, V> setter, Supplier<MapProperty<K, V>> propertySupplier, Map<K, V> defaultValue) {
        this.defaultValue = defaultValue;
        this.getter = getter;
        this.setter = setter;
        this.targetProperty = propertySupplier.get();
        this.targetProperty.setValue(FXCollections.observableMap(new HashMap()));
        this.targetProperty.addListener(change -> updateFunction.call());
    }

    static <K, V> void setAll(Map<K, V> target, Map<K, V> newValues) {
        target.keySet().retainAll(newValues.keySet());
        target.putAll(newValues);
    }

    @Override
    public void commit(M wrappedObject) {
        this.setter.accept(wrappedObject, (Map<K, V>)this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        BeanMapPropertyField.setAll(this.targetProperty, this.getter.apply((Object)wrappedObject));
    }

    @Override
    public void resetToDefault() {
        ((ObservableMap)this.targetProperty.get()).clear();
        BeanMapPropertyField.setAll(this.targetProperty, this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = new HashMap(this.getter.apply((Object)wrappedObject));
    }

    @Override
    public R getProperty() {
        return (R)this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        MapProperty<K, V> wrapperValue;
        Object modelValue = this.getter.apply((Object)wrappedObject);
        return !Objects.equals(modelValue, wrapperValue = this.targetProperty);
    }
}

