/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.incubator.columnbrowser;

import com.dlsc.gemsfx.incubator.columnbrowser.ColumnBrowser;
import com.dlsc.gemsfx.incubator.columnbrowser.ColumnValuesListSkin;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class ColumnValuesList<S, T>
extends Control {
    private TableColumn<S, T> column;
    private ListView<T> listView;
    private ColumnBrowser<S> browser;

    public ColumnValuesList(ColumnBrowser<S> browser, TableColumn<S, T> column) {
        Objects.requireNonNull(browser);
        Objects.requireNonNull(column);
        this.browser = browser;
        this.column = column;
        this.listView = new ListView();
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    protected Skin<?> createDefaultSkin() {
        return new ColumnValuesListSkin(this);
    }

    public final ColumnBrowser<S> getColumnBrowser() {
        return this.browser;
    }

    public final TableColumn<S, T> getColumn() {
        return this.column;
    }

    public final ListView<T> getListView() {
        return this.listView;
    }

    public final Predicate<S> getPredicate() {
        Predicate predicate = new Predicate<S>(){

            @Override
            public boolean test(S item) {
                TableView table = ColumnValuesList.this.column.getTableView();
                Callback valueFactory = ColumnValuesList.this.column.getCellValueFactory();
                ObservableValue value = (ObservableValue)valueFactory.call((Object)new TableColumn.CellDataFeatures(table, ColumnValuesList.this.column, item));
                MultipleSelectionModel selectionModel = ColumnValuesList.this.listView.getSelectionModel();
                if (selectionModel.isEmpty()) {
                    return true;
                }
                return selectionModel.getSelectedItems().contains(value.getValue());
            }
        };
        return predicate;
    }
}

