/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.internal;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.util.GradleVersion;

public final class TaskOption {
    private final String flag;
    private final String value;

    public TaskOption(String flag, String value) {
        this.flag = flag;
        this.value = value;
        this.validate();
    }

    private void validate() {
        if (!this.flag.startsWith("--")) {
            throw new IllegalArgumentException("Invalid flag: " + this.flag);
        }
        if (this.value.isBlank()) {
            throw new IllegalArgumentException("Invalid value: " + this.value);
        }
    }

    public String getFlag() {
        return this.flag;
    }

    public String getValue() {
        return this.value;
    }

    public String getJavadocFlag() {
        return this.flag.substring(1);
    }

    public void mutateArgs(List<String> args) {
        args.add(this.flag);
        args.add(this.value);
    }

    public void mutateOptions(CoreJavadocOptions options) {
        String javadocFlag = this.getJavadocFlag();
        if (javadocFlag.equals("-module-path") && GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            String[] paths = this.value.split(Instrumented.systemProperty((String)"path.separator", (String)"org.javamodularity.moduleplugin.internal.TaskOption"));
            List modulePath = Arrays.stream(paths).map(File::new).collect(Collectors.toList());
            options.modulePath(modulePath);
        } else {
            options.addStringOption(javadocFlag, this.value);
        }
    }
}

