/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.afterburner.injection;

import com.airhacks.afterburner.injection.Injector;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PresenterFactory {
    public static PresenterFactory discover() {
        ServiceLoader<PresenterFactory> discoveredFactories = ServiceLoader.load(PresenterFactory.class);
        List<PresenterFactory> factories = StreamSupport.stream(discoveredFactories.spliterator(), false).collect(Collectors.toList());
        if (factories.isEmpty()) {
            return new PresenterFactory(){

                @Override
                public <T> T instantiatePresenter(Class<T> clazz, Function<String, Object> injectionContext) {
                    return Injector.instantiatePresenter(clazz, injectionContext);
                }

                @Override
                public void injectMembers(Object controller, Function<String, Object> injectionContext) {
                    Injector.injectMembers(controller, injectionContext);
                }
            };
        }
        if (factories.size() == 1) {
            return (PresenterFactory)factories.get(0);
        }
        Logger logger = LoggerFactory.getLogger(PresenterFactory.class);
        factories.forEach(factory -> logger.error(factory.toString()));
        throw new IllegalStateException("More than one PresenterFactories discovered");
    }

    public <T> T instantiatePresenter(Class<T> var1, Function<String, Object> var2);

    public void injectMembers(Object var1, Function<String, Object> var2);
}

