/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.util.WrapperBase;

class ChangeListenerWrapper<T>
extends WrapperBase<ListChangeListener<? super T>>
implements LiveList.QuasiChangeObserver<T> {
    private final ObservableList<T> list;

    public ChangeListenerWrapper(ObservableList<T> list, ListChangeListener<? super T> listener) {
        super(listener);
        this.list = list;
    }

    @Override
    public void onChange(QuasiListChange<? extends T> change) {
        final List modifications = change.getModifications();
        if (modifications.isEmpty()) {
            return;
        }
        ((ListChangeListener)this.getWrappedValue()).onChanged(new ListChangeListener.Change<T>(this.list){
            private int current;
            {
                super(x0);
                this.current = -1;
            }

            public int getFrom() {
                return ((QuasiListModification)modifications.get(this.current)).getFrom();
            }

            protected int[] getPermutation() {
                return new int[0];
            }

            public List<T> getRemoved() {
                return ((QuasiListModification)modifications.get(this.current)).getRemoved();
            }

            public int getTo() {
                return ((QuasiListModification)modifications.get(this.current)).getTo();
            }

            public boolean next() {
                if (this.current + 1 < modifications.size()) {
                    ++this.current;
                    return true;
                }
                return false;
            }

            public void reset() {
                this.current = -1;
            }
        });
    }
}

