/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.metadata.FileDirectoryPreferences;
import org.jabref.model.util.FileHelper;

public class LinkedFile
implements Serializable {
    private static final LinkedFile NULL_OBJECT = new LinkedFile("", "", "");
    private transient StringProperty description = new SimpleStringProperty();
    private transient StringProperty link = new SimpleStringProperty();
    private transient StringProperty fileType = new SimpleStringProperty();

    public LinkedFile(String description, String link, String fileType) {
        this.description.setValue(Objects.requireNonNull(description));
        this.fileType.setValue(Objects.requireNonNull(fileType));
        this.setLink(Objects.requireNonNull(link));
    }

    public LinkedFile(URL link, String fileType) {
        this("", Objects.requireNonNull(link).toString(), fileType);
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public StringProperty linkProperty() {
        return this.link;
    }

    public StringProperty fileTypeProperty() {
        return this.fileType;
    }

    public String getFileType() {
        return (String)this.fileType.get();
    }

    public void setFileType(String fileType) {
        this.fileType.setValue(fileType);
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.setValue(description);
    }

    public String getLink() {
        return (String)this.link.get();
    }

    public void setLink(String link) {
        if (!this.isOnlineLink(link)) {
            this.link.setValue(link.replace("\\", "/"));
        } else {
            this.link.setValue(link);
        }
    }

    public Observable[] getObservables() {
        return new Observable[]{this.link, this.description, this.fileType};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LinkedFile) {
            LinkedFile that = (LinkedFile)o;
            return Objects.equals(this.description.get(), that.description.get()) && Objects.equals(this.link.get(), that.link.get()) && Objects.equals(this.fileType.get(), that.fileType.get());
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.getFileType());
        out.writeUTF(this.getLink());
        out.writeUTF(this.getDescription());
        out.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.fileType = new SimpleStringProperty(in.readUTF());
        this.link = new SimpleStringProperty(in.readUTF());
        this.description = new SimpleStringProperty(in.readUTF());
    }

    private boolean isOnlineLink(String toCheck) {
        return toCheck.startsWith("http://") || toCheck.startsWith("https://") || toCheck.contains("www.");
    }

    public int hashCode() {
        return Objects.hash(this.description.get(), this.link.get(), this.fileType.get());
    }

    public String toString() {
        return "ParsedFileField{description='" + (String)this.description.get() + '\'' + ", link='" + (String)this.link.get() + '\'' + ", fileType='" + (String)this.fileType.get() + '\'' + '}';
    }

    public boolean isEmpty() {
        return NULL_OBJECT.equals(this);
    }

    public boolean isOnlineLink() {
        return this.isOnlineLink((String)this.link.get());
    }

    public Optional<Path> findIn(BibDatabaseContext databaseContext, FileDirectoryPreferences fileDirectoryPreferences) {
        List<Path> dirs = databaseContext.getFileDirectoriesAsPaths(fileDirectoryPreferences);
        return this.findIn(dirs);
    }

    public Optional<Path> findIn(List<Path> directories) {
        Path file = Paths.get((String)this.link.get(), new String[0]);
        if (file.isAbsolute() || directories.isEmpty()) {
            return Optional.of(file);
        }
        return FileHelper.expandFilenameAsPath((String)this.link.get(), directories);
    }
}

